/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.routing.validate;

import com.jd.laf.binding.annotation.Value;
import com.jd.laf.web.vertx.parameter.Parameters;
import io.vertx.ext.web.RoutingContext;
import org.joyqueue.exception.ServiceException;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.routing.validate.ValidateHandler;
import org.joyqueue.model.domain.Application;
import org.joyqueue.model.domain.ApplicationToken;
import org.joyqueue.service.ApplicationTokenService;

public class ValidateTokenOfApplicationHandler
extends ValidateHandler {
    @Value
    protected ApplicationTokenService applicationTokenService;

    @Override
    protected void validate(RoutingContext context, Parameters.RequestParameter parameter) {
        Application app = (Application)context.get("application");
        Long appTokenId = parameter.query().getLong("id");
        ApplicationToken token = null;
        try {
            token = appTokenId == null ? null : (ApplicationToken)this.applicationTokenService.findById((Object)appTokenId);
        }
        catch (Exception e) {
            throw new ServiceException(10001, e.getMessage());
        }
        if (app == null) {
            throw new ConfigException(ErrorCode.ApplicationNotExists);
        }
        if (token == null) {
            throw new ConfigException(ErrorCode.AppTokenNotExists);
        }
        if (!token.getApplication().getCode().equals(app.getCode())) {
            throw new ConfigException(ErrorCode.NoPrivilege);
        }
        context.put("appToken", (Object)token);
    }

    public String type() {
        return "validateTokenOfApplication";
    }
}

