/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.util;

import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.handler.error.IdentifierException;
import org.joyqueue.model.domain.Identifier;

public class ExceptionUtils {
    public static void checkArgument(boolean expression, ErrorCode errorCode) {
        if (!expression) {
            throw new ConfigException(errorCode);
        }
    }

    public static void checkArgument(boolean expression, ErrorCode errorCode, Object errorMessage) {
        if (!expression) {
            throw new ConfigException(errorCode, String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkIdentifier(String input, int maxLength, String field) {
        if (!Identifier.isIdentifier((String)input, (int)maxLength)) {
            throw new ConfigException(ErrorCode.BadRequest, field + " \u5fc5\u987b\u4e3a\u6807\u8bc6\u7b26\uff0c\u4ee5\u82f1\u6587\u5b57\u6bcd\u5f00\u5934\uff0c\u82f1\u6587\u5b57\u6bcd\u3001\u963f\u62c9\u4f2f\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u6a2a\u7ebf\u6216\u5c0f\u6570\u70b9\u7ec4\u6210\uff0c\u6700\u5927\u957f\u5ea6\u4e3a" + maxLength);
        }
    }

    public static void checkIdentifier(String input, int maxLength) {
        if (!Identifier.isIdentifier((String)input, (int)maxLength)) {
            throw new IdentifierException(maxLength);
        }
    }

    public static void checkIdentifier(Identifier identifier, int maxLength) {
        ExceptionUtils.checkIdentifier(identifier.getCode(), maxLength);
    }
}

