/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.util;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.handler.error.ConfigException;
import org.joyqueue.handler.error.ErrorCode;
import org.joyqueue.model.domain.grafana.GrafanaConfig;
import org.joyqueue.model.domain.grafana.GrafanaVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrafanaUtils {
    private static final Logger logger = LoggerFactory.getLogger(GrafanaUtils.class);
    private static GrafanaConfig config;
    private static Map<String, GrafanaVariable> variables;
    private static Map<String, List<String>> metrics;
    private static Map<String, String> urls;
    public static final String DELIMITER_REG = "[\\pP\\pZ\\pS]";
    public static final String VARIABLE_SYMBOL = "$";
    private static final Object configMutex;
    private static final Object variableMutex;
    private static final Object metricMutex;
    private static final Object urlMutex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrafanaConfig getConfig() {
        if (config != null) {
            return config;
        }
        Object object = configMutex;
        synchronized (object) {
            if (config == null) {
                config = GrafanaUtils.load("grafana.xml");
            }
            return config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, GrafanaVariable> getVariables() {
        if (variables != null) {
            return variables;
        }
        Object object = variableMutex;
        synchronized (object) {
            if (variables == null) {
                ConcurrentMap map = Maps.newConcurrentMap();
                GrafanaUtils.getConfig().getVariables().forEach(v -> map.put(v.getName(), v));
                variables = map;
            }
            return variables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<String>> getMetrics() {
        if (metrics != null) {
            return metrics;
        }
        Object object = metricMutex;
        synchronized (object) {
            if (metrics == null && GrafanaUtils.getConfig() != null) {
                ConcurrentMap map = Maps.newConcurrentMap();
                GrafanaUtils.getConfig().getDashboards().forEach(d -> {
                    if (d.getMetricVariables() != null) {
                        d.getMetricVariables().stream().forEach(v -> {
                            String delimiter = GrafanaUtils.getDelimiter(v.getTarget());
                            String key = v.getName() + delimiter + d.getUid();
                            map.put(key, v.getMetrics().stream().map(m -> m.getName()).collect(Collectors.toList()));
                        });
                    }
                });
                metrics = map;
            }
            return metrics;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getUrls() {
        if (urls != null) {
            return urls;
        }
        Object object = urlMutex;
        synchronized (object) {
            if (urls == null && GrafanaUtils.getConfig() != null) {
                urls = Maps.newConcurrentMap();
                String baseUrl = GrafanaUtils.getConfig().getUrl();
                if (StringUtils.isBlank((CharSequence)baseUrl)) {
                    throw new ConfigException(ErrorCode.InvalidConfiguration, "can not found url property at grafana.xml");
                }
                GrafanaUtils.getConfig().getDashboards().forEach(c -> {
                    if (StringUtils.isBlank((CharSequence)c.getUrl())) {
                        logger.error(String.format("can not found path property of dashboard with name %s at grafana.xml", c.getTitle()));
                        return;
                    }
                    if (StringUtils.isBlank((CharSequence)c.getUid())) {
                        logger.error(String.format("can not found uid property of dashboard with name %s at grafana.xml", c.getTitle()));
                        return;
                    }
                    urls.put(c.getUid(), baseUrl + c.getUrl());
                });
            }
            return urls;
        }
    }

    private static GrafanaConfig load(String file) {
        try {
            logger.info("loading grafana.xml");
            return (GrafanaConfig)new XmlMapper().readValue(StringUtils.toEncodedString((byte[])IOUtils.toByteArray((InputStream)GrafanaUtils.class.getClassLoader().getResourceAsStream(file)), (Charset)StandardCharsets.UTF_8), GrafanaConfig.class);
        }
        catch (IOException e) {
            throw new ConfigException(ErrorCode.ConfigurationNotExists, "load file grafana.xml error.");
        }
    }

    public static String getDelimiter(String target) {
        Matcher matcher = Pattern.compile(DELIMITER_REG).matcher(target);
        String delimiter = ":";
        if (matcher.find()) {
            delimiter = matcher.group(0);
        }
        return delimiter;
    }

    public static String[] getKey(String target) {
        String[] fields;
        Matcher matcher = Pattern.compile(DELIMITER_REG).matcher(target);
        String delimiter = ":";
        if (matcher.find()) {
            delimiter = matcher.group(0);
        }
        try {
            fields = target.split(delimiter);
        }
        catch (Exception e) {
            fields = target.split("\\" + delimiter);
        }
        return new String[]{fields[0], fields[0] + delimiter + fields[1]};
    }

    public static String getResult(Object obj, String format) {
        Pattern pattern = Pattern.compile(DELIMITER_REG);
        return Arrays.stream(format.split("\\$")).filter(v -> StringUtils.isNotBlank((CharSequence)v)).map(v -> {
            Matcher matcher = pattern.matcher((CharSequence)v);
            if (matcher.find()) {
                return v.substring(0, matcher.end() - 1);
            }
            return v;
        }).distinct().reduce(format, (r, v) -> {
            for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    Field field = clazz.getDeclaredField((String)v);
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    return r.replace(VARIABLE_SYMBOL + v, value == null ? "" : value.toString());
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                catch (Exception e) {
                    logger.error(String.format("get property %s of class %s error.", v, obj.getClass()), (Throwable)e);
                    return r;
                }
            }
            return r;
        });
    }

    public static String getMetricCode(String uid, String name, String granularity) {
        StringBuffer result = new StringBuffer("");
        GrafanaUtils.getConfig().getDashboards().stream().filter(c -> c.getUid().equals(uid)).findAny().ifPresent(c -> {
            if (c.getMetricVariables() != null) {
                c.getMetricVariables().stream().forEach(v -> v.getMetrics().stream().filter(m -> m.getName().equals(name)).findAny().ifPresent(m -> m.getGranularities().stream().filter(g -> g.getName().equals(granularity)).findAny().ifPresent(g -> result.append(g.getCode()).append(","))));
            }
        });
        return result.length() == 0 ? null : result.deleteCharAt(result.length() - 1).toString();
    }

    public static void main(String[] args) {
        GrafanaUtils.load("grafana.xml");
        GrafanaUtils.getKey("metrics:uid:$granularity:*");
    }

    static {
        configMutex = new Object();
        variableMutex = new Object();
        metricMutex = new Object();
        urlMutex = new Object();
    }
}

