/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.handler.util;

import java.util.Date;
import org.joyqueue.toolkit.time.SystemClock;

public class RetryUtils {
    public static final long EXPIRETIME = 604800000L;
    private static final long RETRYDELAY = 1000L;
    private static final long MAXRETRYDELAY = 300000L;
    private static final double EXPONENTIAL = 3.0;

    public static Date getExpireTime() {
        long now = SystemClock.now();
        long time = now + 604800000L;
        return new Date(time);
    }

    public static Date getNextRetryTime(Date now, int retryCount) {
        long time;
        if (now == null) {
            now = new Date();
        }
        if ((time = Math.round(1000.0 * Math.pow(3.0, retryCount + 1))) <= 0L) {
            return now;
        }
        if (time > 300000L) {
            time = Math.max(300000L, 1000L);
        }
        return new Date(now.getTime() + time);
    }
}

