/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.style;

import java.text.DecimalFormat;
import java.util.StringTokenizer;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.style.StyleTypeDefinitions;

public class Border {
    StyleTypeDefinitions.LineType lineStyle;
    Color color;
    double width;
    double innerLineWidth;
    double distance;
    double outerLineWidth;
    StyleTypeDefinitions.SupportedLinearMeasure linearMeasure;
    private static final String WidthFormatInInch = "#.####";
    public static Border NONE = new Border(StyleTypeDefinitions.LineType.NONE);

    protected Border() {
    }

    private Border(StyleTypeDefinitions.LineType lineType) {
        this.lineStyle = lineType;
        this.width = 0.0;
    }

    public Border(Color aColor, double width, StyleTypeDefinitions.SupportedLinearMeasure linearMeasure) {
        this.color = aColor;
        this.width = width;
        this.linearMeasure = linearMeasure;
        this.lineStyle = StyleTypeDefinitions.LineType.SINGLE;
    }

    public Border(Color aColor, double width, double innerLineWidth, double outerLineWidth, StyleTypeDefinitions.SupportedLinearMeasure linearMeasure) {
        this.color = aColor;
        this.width = width;
        this.linearMeasure = linearMeasure;
        this.innerLineWidth = innerLineWidth;
        this.outerLineWidth = outerLineWidth;
        this.distance = width - innerLineWidth - outerLineWidth;
        this.lineStyle = StyleTypeDefinitions.LineType.DOUBLE;
        if (this.distance <= 0.0) {
            throw new IllegalArgumentException("The width must bigger than the sum of inner line width and outer line width!");
        }
    }

    public StyleTypeDefinitions.LineType getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(StyleTypeDefinitions.LineType lineStyle) {
        this.lineStyle = lineStyle;
    }

    protected void setBorderByDescription(String borderDesc) {
        StringTokenizer st = new StringTokenizer(borderDesc);
        if (st.countTokens() != 3) {
            throw new IllegalArgumentException("The border description is invalid. Border description contains width, style and color, such as '0.0154in double #9900ff'");
        }
        String borderWidth = st.nextToken();
        String borderStyle = st.nextToken();
        Color borderColor = new Color(st.nextToken());
        if (borderStyle.equals("solid")) {
            borderStyle = StyleTypeDefinitions.LineType.SINGLE.toString();
        }
        StyleTypeDefinitions.LineType borderStyleType = StyleTypeDefinitions.LineType.enumValueOf(borderStyle);
        this.width = this.getLineWidth(borderWidth);
        this.linearMeasure = this.getLineMeasure(borderWidth);
        this.setLineStyle(borderStyleType);
        this.setColor(borderColor);
    }

    protected String getBorderDescription() {
        switch (this.lineStyle) {
            case SINGLE: {
                return this.getWidth() + this.linearMeasure.toString() + " solid " + this.getColor();
            }
            case DOUBLE: {
                return this.getWidth() + this.linearMeasure.toString() + " double " + this.getColor();
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    protected String getDoubleLineWidthDescription() {
        if (this.lineStyle == StyleTypeDefinitions.LineType.SINGLE) {
            return null;
        }
        DecimalFormat formater = new DecimalFormat(WidthFormatInInch);
        return formater.format(this.innerLineWidth) + this.linearMeasure.toString() + " " + formater.format(this.distance) + (Object)((Object)this.linearMeasure) + " " + formater.format(this.outerLineWidth) + (Object)((Object)this.linearMeasure);
    }

    protected void setDoubleLineWidthByDescription(String widthDesc) {
        StringTokenizer st = new StringTokenizer(widthDesc);
        if (st.countTokens() != 3) {
            throw new IllegalArgumentException("The width description is invalid. Width description contains inner line width, distance and outer line width, such as '0.0154in 0154in 0154in'");
        }
        String thisInnerWidth = st.nextToken();
        String thisDistance = st.nextToken();
        String thisOuterWidth = st.nextToken();
        this.setDoubleLineWidth(thisInnerWidth, thisDistance, thisOuterWidth);
    }

    public double getInnerLineWidth() {
        if (this.lineStyle == StyleTypeDefinitions.LineType.SINGLE) {
            return this.getWidth();
        }
        return this.innerLineWidth;
    }

    public void setInnerLineWidth(double innerWidth) {
        if (this.lineStyle == StyleTypeDefinitions.LineType.SINGLE) {
            return;
        }
        this.innerLineWidth = innerWidth;
    }

    public double getDistance() {
        if (this.lineStyle == StyleTypeDefinitions.LineType.SINGLE) {
            return this.getWidth();
        }
        return this.distance;
    }

    public void setDistance(double distance) {
        if (this.lineStyle == StyleTypeDefinitions.LineType.SINGLE) {
            return;
        }
        this.distance = distance;
    }

    public double getOuterLineWidth() {
        if (this.lineStyle == StyleTypeDefinitions.LineType.SINGLE) {
            return this.getWidth();
        }
        return this.outerLineWidth;
    }

    public void setOuterLineWidth(double lineWidth) {
        if (this.lineStyle == StyleTypeDefinitions.LineType.SINGLE) {
            return;
        }
        this.outerLineWidth = lineWidth;
    }

    private void setDoubleLineWidth(String innerLineWidth, String distance, String outerLineWidth) {
        this.linearMeasure = this.getLineMeasure(innerLineWidth);
        StyleTypeDefinitions.SupportedLinearMeasure lm = this.getLineMeasure(distance);
        double lf = this.getLineWidth(distance);
        this.distance = this.linearMeasure.convert(lf, lm);
        lm = this.getLineMeasure(outerLineWidth);
        lf = this.getLineWidth(outerLineWidth);
        this.outerLineWidth = this.linearMeasure.convert(lf, lm);
        this.innerLineWidth = this.getLineWidth(innerLineWidth);
        this.lineStyle = StyleTypeDefinitions.LineType.DOUBLE;
    }

    private StyleTypeDefinitions.SupportedLinearMeasure getLineMeasure(String width) {
        for (StyleTypeDefinitions.SupportedLinearMeasure aIter : StyleTypeDefinitions.SupportedLinearMeasure.values()) {
            if (!width.endsWith(aIter.toString())) continue;
            return aIter;
        }
        return null;
    }

    private double getLineWidth(String width) {
        String floatValue = width.substring(0, width.length() - 2);
        return Double.parseDouble(floatValue);
    }

    protected Border changeLineMeasure(StyleTypeDefinitions.SupportedLinearMeasure newLineMeasure) {
        if (newLineMeasure == this.linearMeasure) {
            return this;
        }
        Border newBorder = new Border();
        newBorder.width = newLineMeasure.convert(this.width, this.linearMeasure);
        newBorder.distance = newLineMeasure.convert(this.distance, this.linearMeasure);
        newBorder.innerLineWidth = newLineMeasure.convert(this.innerLineWidth, this.linearMeasure);
        newBorder.outerLineWidth = newLineMeasure.convert(this.outerLineWidth, this.linearMeasure);
        newBorder.color = this.color;
        newBorder.lineStyle = this.lineStyle;
        newBorder.linearMeasure = newLineMeasure;
        return newBorder;
    }

    public String toString() {
        return "Border:" + this.getBorderDescription() + ";" + "BorderWidth:" + this.getDoubleLineWidthDescription();
    }

    private boolean doubleEqual(double d1, double d2) {
        if (this.linearMeasure == StyleTypeDefinitions.SupportedLinearMeasure.IN && Math.abs(d1 - d2) > 2.0E-4) {
            return false;
        }
        return this.linearMeasure != StyleTypeDefinitions.SupportedLinearMeasure.PT || !(Math.abs(d1 - d2) > 0.02);
    }

    public boolean equals(Object o) {
        if (o == NONE && this == NONE) {
            return true;
        }
        if (o instanceof Border) {
            Border aBorder = (Border)o;
            if (aBorder.getLineStyle() != this.getLineStyle()) {
                return false;
            }
            if (!aBorder.color.toString().equals(this.color.toString())) {
                return false;
            }
            if (aBorder.linearMeasure != this.linearMeasure) {
                Border bBorder = aBorder.changeLineMeasure(this.linearMeasure);
                return this.equals(bBorder);
            }
            if (!this.doubleEqual(aBorder.width, this.width)) {
                return false;
            }
            if (this.lineStyle == StyleTypeDefinitions.LineType.DOUBLE) {
                if (!this.doubleEqual(aBorder.distance, this.distance)) {
                    return false;
                }
                if (!this.doubleEqual(aBorder.innerLineWidth, this.innerLineWidth)) {
                    return false;
                }
                if (!this.doubleEqual(aBorder.outerLineWidth, this.outerLineWidth)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public StyleTypeDefinitions.SupportedLinearMeasure getLinearMeasure() {
        return this.linearMeasure;
    }

    public void setLinearMeasure(StyleTypeDefinitions.SupportedLinearMeasure linearMeasure) {
        this.linearMeasure = linearMeasure;
    }
}

