/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.table;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.dc.DcCreatorElement;
import org.odftoolkit.odfdom.dom.element.dc.DcDateElement;
import org.odftoolkit.odfdom.dom.element.number.NumberCurrencySymbolElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElementBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowGroupElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowsElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberCurrencyStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberPercentageStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextSpan;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.common.TextExtractor;
import org.odftoolkit.simple.common.WhitespaceProcessor;
import org.odftoolkit.simple.style.Border;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.table.CellCoverInfo;
import org.odftoolkit.simple.table.CellStyleHandler;
import org.odftoolkit.simple.table.CellValueAdapter;
import org.odftoolkit.simple.table.Column;
import org.odftoolkit.simple.table.DomNodeList;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.text.list.AbstractListContainer;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell
implements ListContainer {
    TableTableCellElementBase mCellElement;
    Document mDocument;
    int mnRepeatedColIndex;
    int mnRepeatedRowIndex;
    Table mOwnerTable;
    String msFormatString;
    CellStyleHandler mStyleHandler;
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String DEFAULT_TIME_FORMAT = "'PT'HH'H'mm'M'ss'S'";
    private static final String DEFAULT_BACKGROUND_COLOR = "#FFFFFF";
    private static final int DEFAULT_COLUMN_SPANNED_NUMBER = 1;
    private static final int DEFAULT_ROW_SPANNED_NUMBER = 1;
    private static final int DEFAULT_COLUMNS_REPEATED_NUMBER = 1;
    private ListContainerImpl listContainerImpl = new ListContainerImpl();

    Cell(TableTableCellElementBase odfElement, int repeatedColIndex, int repeatedRowIndex) {
        this.mCellElement = odfElement;
        this.mnRepeatedColIndex = repeatedColIndex;
        this.mnRepeatedRowIndex = repeatedRowIndex;
        this.mOwnerTable = this.getTable();
        this.mDocument = (Document)((OdfFileDom)this.mCellElement.getOwnerDocument()).getDocument();
        this.mStyleHandler = new CellStyleHandler(this);
    }

    public static Cell getInstance(TableTableCellElementBase cellElement) {
        TableTableElement tableElement = null;
        for (Node node = cellElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof TableTableElement)) continue;
            tableElement = (TableTableElement)node;
        }
        Table table = null;
        if (tableElement == null) {
            throw new IllegalArgumentException("the cellElement is not in the table dom tree");
        }
        table = Table.getInstance(tableElement);
        Cell cell = table.getCellInstance(cellElement, 0, 0);
        int colRepeatedNum = cell.getColumnsRepeatedNumber();
        int rowRepeatedNum = cell.getTableRow().getRowsRepeatedNumber();
        if (colRepeatedNum > 1 && rowRepeatedNum > 1) {
            if (colRepeatedNum > 1) {
                Logger.getLogger(Cell.class.getName()).log(Level.WARNING, "the cell has the repeated column number, and puzzled about get which repeated column index of the cell,");
            }
            if (rowRepeatedNum > 1) {
                Logger.getLogger(Cell.class.getName()).log(Level.WARNING, "the row contains the current cell has the repeated row number, and puzzled about get which repeated row index of the cell,");
            }
            Logger.getLogger(Cell.class.getName()).log(Level.WARNING, "here just return the first cell that the repeated column index is 0 and repeated row index is 0, too.");
        }
        return cell;
    }

    @Deprecated
    public String getHorizontalAlignment() {
        OdfStyleBase styleElement = this.getStyleHandler().getCellStyleElementForRead();
        if (styleElement != null) {
            OdfStyleProperty property = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.ParagraphProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.FO, (String)"text-align"));
            return styleElement.getProperty(property);
        }
        return null;
    }

    public StyleTypeDefinitions.HorizontalAlignmentType getHorizontalAlignmentType() {
        return this.getStyleHandler().getHorizontalAlignment();
    }

    @Deprecated
    public void setHorizontalAlignment(String horizontalAlignment) {
        if (FoTextAlignAttribute.Value.LEFT.toString().equalsIgnoreCase(horizontalAlignment)) {
            horizontalAlignment = FoTextAlignAttribute.Value.START.toString();
        }
        if (FoTextAlignAttribute.Value.RIGHT.toString().equalsIgnoreCase(horizontalAlignment)) {
            horizontalAlignment = FoTextAlignAttribute.Value.END.toString();
        }
        this.splitRepeatedCells();
        OdfStyle styleElement = this.getStyleHandler().getCellStyleElementForWrite();
        if (styleElement != null) {
            OdfStyleProperty property = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.ParagraphProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.FO, (String)"text-align"));
            if (horizontalAlignment != null) {
                styleElement.setProperty(property, horizontalAlignment);
            } else {
                styleElement.removeProperty(property);
            }
        }
    }

    public void setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType alignType) {
        this.getStyleHandler().setHorizontalAlignment(alignType);
    }

    @Deprecated
    public String getVerticalAlignment() {
        OdfStyleBase styleElement = this.getStyleHandler().getCellStyleElementForRead();
        if (styleElement != null) {
            OdfStyleProperty property = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.TableCellProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.STYLE, (String)"vertical-align"));
            return styleElement.getProperty(property);
        }
        return null;
    }

    public StyleTypeDefinitions.VerticalAlignmentType getVerticalAlignmentType() {
        return this.getStyleHandler().getVerticalAlignment();
    }

    @Deprecated
    public void setVerticalAlignment(String verticalAlignment) {
        this.splitRepeatedCells();
        OdfStyle styleElement = this.getStyleHandler().getCellStyleElementForWrite();
        if (styleElement != null) {
            OdfStyleProperty property = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.TableCellProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.STYLE, (String)"vertical-align"));
            if (verticalAlignment != null) {
                styleElement.setProperty(property, verticalAlignment);
            } else {
                styleElement.removeProperty(property);
            }
        }
    }

    public void setVerticalAlignment(StyleTypeDefinitions.VerticalAlignmentType verticalAlignment) {
        this.getStyleHandler().setVerticalAlignment(verticalAlignment);
    }

    public boolean isTextWrapped() {
        return this.getStyleHandler().isTextWrapped();
    }

    public void setTextWrapped(boolean isTextWrapped) {
        this.getStyleHandler().setTextWrapped(isTextWrapped);
    }

    private TableTableRowElement findRowInTableHeaderRows(TableTableHeaderRowsElement headers, TableTableRowElement tr, int[] indexs) {
        int result = 0;
        for (Node m : new DomNodeList(headers.getChildNodes())) {
            if (m == tr) {
                indexs[0] = result;
                return tr;
            }
            if (!(m instanceof TableTableRowElement)) continue;
            result += ((TableTableRowElement)m).getTableNumberRowsRepeatedAttribute().intValue();
        }
        indexs[0] = result;
        return null;
    }

    private TableTableRowElement findRowInTableRows(TableTableRowsElement rows, TableTableRowElement tr, int[] indexs) {
        int result = 0;
        for (Node m : new DomNodeList(rows.getChildNodes())) {
            if (m == tr) {
                indexs[0] = result;
                return tr;
            }
            if (!(m instanceof TableTableRowElement)) continue;
            result += ((TableTableRowElement)m).getTableNumberRowsRepeatedAttribute().intValue();
        }
        indexs[0] = result;
        return null;
    }

    private TableTableRowElement findRowInTableRowGroup(OdfElement group, TableTableRowElement tr, int[] indexs) {
        int result = 0;
        int[] resultIndexs = new int[1];
        if (!(group instanceof TableTableRowGroupElement) && !(group instanceof TableTableElement)) {
            indexs[0] = 0;
            return null;
        }
        for (Node m : new DomNodeList(group.getChildNodes())) {
            TableTableRowElement returnEle;
            if (m instanceof TableTableHeaderRowsElement) {
                TableTableHeaderRowsElement headers = (TableTableHeaderRowsElement)m;
                returnEle = this.findRowInTableHeaderRows(headers, tr, resultIndexs);
                result += resultIndexs[0];
                if (returnEle == null) continue;
                indexs[0] = result;
                return returnEle;
            }
            if (m instanceof TableTableRowGroupElement) {
                TableTableRowGroupElement aGroup = (TableTableRowGroupElement)m;
                returnEle = this.findRowInTableRowGroup((OdfElement)aGroup, tr, resultIndexs);
                result += resultIndexs[0];
                if (returnEle == null) continue;
                indexs[0] = result;
                return returnEle;
            }
            if (m instanceof TableTableRowsElement) {
                TableTableRowsElement rows = (TableTableRowsElement)m;
                returnEle = this.findRowInTableRows(rows, tr, resultIndexs);
                result += resultIndexs[0];
                if (returnEle == null) continue;
                indexs[0] = result;
                return returnEle;
            }
            if (!(m instanceof TableTableRowElement)) continue;
            if (m == tr) {
                indexs[0] = result;
                return tr;
            }
            result += ((TableTableRowElement)m).getTableNumberRowsRepeatedAttribute().intValue();
        }
        indexs[0] = result;
        return null;
    }

    public int getRowIndex() {
        int[] indexs;
        TableTableRowElement tr;
        TableTableElement table = this.getTableElement();
        TableTableRowElement returnEle = this.findRowInTableRowGroup((OdfElement)table, tr = this.getTableRowElement(), indexs = new int[1]);
        if (returnEle != null) {
            return indexs[0] + this.mnRepeatedRowIndex;
        }
        return -1;
    }

    public Table getTable() {
        TableTableElement tableElement = this.getTableElement();
        if (tableElement != null) {
            return Table.getInstance(tableElement);
        }
        return null;
    }

    public int getColumnIndex() {
        TableTableRowElement tr = (TableTableRowElement)this.mCellElement.getParentNode();
        int result = 0;
        for (Node n : new DomNodeList(tr.getChildNodes())) {
            if (n == this.mCellElement) {
                return result + this.mnRepeatedColIndex;
            }
            if (!(n instanceof TableTableCellElementBase)) continue;
            result += ((TableTableCellElementBase)n).getTableNumberColumnsRepeatedAttribute().intValue();
        }
        return result;
    }

    public Column getTableColumn() {
        Table table = this.getTable();
        int index = this.getColumnIndex();
        return table.getColumnByIndex(index);
    }

    TableTableColumnElement getTableColumnElement() {
        TableTableElement tableElement = this.getTableElement();
        int columnindex = this.getColumnIndex();
        Table fTable = Table.getInstance(tableElement);
        return fTable.getColumnElementByIndex(columnindex);
    }

    public Row getTableRow() {
        Table table = this.getTable();
        return table.getRowInstance(this.getTableRowElement(), this.mnRepeatedRowIndex);
    }

    private TableTableRowElement getTableRowElement() {
        Node node = this.mCellElement.getParentNode();
        if (node instanceof TableTableRowElement) {
            return (TableTableRowElement)node;
        }
        return null;
    }

    private TableTableElement getTableElement() {
        for (Node node = this.mCellElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof TableTableElement)) continue;
            return (TableTableElement)node;
        }
        return null;
    }

    public Cell getOwnerTableCell() {
        Table ownerTable = this.getTable();
        List<CellCoverInfo> coverList = ownerTable.getCellCoverInfos(0, 0, ownerTable.getColumnCount() - 1, ownerTable.getRowCount() - 1);
        return ownerTable.getOwnerCellByPosition(coverList, this.getColumnIndex(), this.getRowIndex());
    }

    public TableTableCellElementBase getOdfElement() {
        return this.mCellElement;
    }

    public String getCurrencyCode() {
        if (this.mCellElement.getOfficeValueTypeAttribute().equals(OfficeValueTypeAttribute.Value.CURRENCY.toString())) {
            return this.mCellElement.getOfficeCurrencyAttribute();
        }
        throw new IllegalArgumentException();
    }

    public void setCurrencyCode(String currency) {
        if (currency == null) {
            throw new IllegalArgumentException("Currency code of cell should not be null.");
        }
        this.splitRepeatedCells();
        if (!this.mCellElement.getOfficeValueTypeAttribute().equals(OfficeValueTypeAttribute.Value.CURRENCY.toString())) {
            throw new IllegalArgumentException();
        }
        this.mCellElement.setOfficeCurrencyAttribute(currency);
    }

    private void setTypeAttr(OfficeValueTypeAttribute.Value type) {
        this.mCellElement.setOfficeValueTypeAttribute(type.toString());
    }

    public void setValueType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("type shouldn't be null.");
        }
        String sType = type.toLowerCase();
        OfficeValueTypeAttribute.Value value = OfficeValueTypeAttribute.Value.enumValueOf((String)sType);
        if (value == null) {
            throw new IllegalArgumentException("the value type of cell is not valid");
        }
        this.mCellElement.setOfficeValueTypeAttribute(sType);
    }

    public String getValueType() {
        return this.mCellElement.getOfficeValueTypeAttribute();
    }

    private OfficeValueTypeAttribute.Value getTypeAttr() {
        String type = this.mCellElement.getOfficeValueTypeAttribute();
        return OfficeValueTypeAttribute.Value.enumValueOf((String)type);
    }

    public Double getDoubleValue() {
        if (this.getTypeAttr() == OfficeValueTypeAttribute.Value.FLOAT) {
            return this.mCellElement.getOfficeValueAttribute();
        }
        throw new IllegalArgumentException();
    }

    public Double getCurrencyValue() {
        if (this.getTypeAttr() == OfficeValueTypeAttribute.Value.CURRENCY) {
            return this.mCellElement.getOfficeValueAttribute();
        }
        throw new IllegalArgumentException();
    }

    public String getCurrencySymbol() {
        if (this.getTypeAttr() != OfficeValueTypeAttribute.Value.CURRENCY) {
            throw new IllegalArgumentException();
        }
        OdfStyleBase style = this.getStyleHandler().getCellStyleElementForRead();
        if (style != null) {
            String dataStyleName = style.getOdfAttributeValue(OdfName.newName((NamespaceName)OdfDocumentNamespace.STYLE, (String)"data-style-name"));
            OdfNumberCurrencyStyle dataStyle = this.mCellElement.getAutomaticStyles().getCurrencyStyle(dataStyleName);
            if (dataStyle == null) {
                dataStyle = this.mDocument.getDocumentStyles().getCurrencyStyle(dataStyleName);
            }
            if (dataStyle != null && dataStyle.getCurrencySymbolElement() != null) {
                return dataStyle.getCurrencySymbolElement().getTextContent();
            }
        }
        return null;
    }

    public void setCurrencyValue(Double value, String currency) {
        if (currency == null) {
            throw new IllegalArgumentException("currency shouldn't be null.");
        }
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.CURRENCY);
        this.mCellElement.setOfficeValueAttribute(value);
        this.mCellElement.setOfficeCurrencyAttribute(currency);
    }

    public Double getPercentageValue() {
        if (this.getTypeAttr() == OfficeValueTypeAttribute.Value.PERCENTAGE) {
            return this.mCellElement.getOfficeValueAttribute();
        }
        throw new IllegalArgumentException();
    }

    public void setPercentageValue(Double value) {
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.PERCENTAGE);
        this.mCellElement.setOfficeValueAttribute(value);
    }

    public String getDisplayText() {
        return TextExtractor.getText((OdfElement)this.mCellElement);
    }

    public void setDisplayText(String content, CellValueAdapter adapter) {
        if (content == null) {
            content = "";
        }
        this.setDisplayTextContent(content, null);
        adapter.adaptValue(this, content);
    }

    public void setDisplayText(String content) {
        this.setDisplayText(content, CellValueAdapter.DEFAULT_VALUE_ADAPTER);
    }

    public void setDisplayText(String content, CellValueAdapter adapter, String stylename) {
        if (content == null) {
            content = "";
        }
        this.setDisplayTextContent(content, stylename);
        adapter.adaptValue(this, content);
    }

    public void setDisplayText(String content, String stylename) {
        this.setDisplayText(content, CellValueAdapter.DEFAULT_VALUE_ADAPTER, stylename);
    }

    private void setDisplayTextContent(String content, String stylename) {
        WhitespaceProcessor textProcessor = new WhitespaceProcessor();
        OdfStylableElement element = (OdfStylableElement)OdfElement.findFirstChildNode(OdfTextParagraph.class, (Node)this.mCellElement);
        if (element == null) {
            this.removeContent();
            element = new OdfTextParagraph((OdfFileDom)this.mCellElement.getOwnerDocument());
            this.mCellElement.appendChild((Node)element);
        } else {
            OdfTextSpan span;
            String formerContent = element.getTextContent();
            while ((formerContent == null || "".equals(formerContent)) && (span = (OdfTextSpan)OdfElement.findFirstChildNode(OdfTextSpan.class, (Node)element)) != null) {
                formerContent = span.getTextContent();
                element = span;
            }
        }
        if (stylename != null && stylename.length() > 0) {
            element.setStyleName(stylename);
        }
        element.setTextContent(null);
        textProcessor.append((Element)element, content);
    }

    public void setDoubleValue(Double value) {
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.FLOAT);
        this.mCellElement.setOfficeValueAttribute(value);
        this.setDisplayTextContent(value + "", null);
    }

    public Boolean getBooleanValue() {
        if (this.getTypeAttr() == OfficeValueTypeAttribute.Value.BOOLEAN) {
            return this.mCellElement.getOfficeBooleanValueAttribute();
        }
        throw new IllegalArgumentException();
    }

    public void setBooleanValue(Boolean value) {
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.BOOLEAN);
        this.mCellElement.setOfficeBooleanValueAttribute(value);
        this.setDisplayTextContent(value + "", null);
    }

    public Calendar getDateValue() {
        if (this.getTypeAttr() == OfficeValueTypeAttribute.Value.DATE) {
            String dateStr = this.mCellElement.getOfficeDateValueAttribute();
            if (dateStr == null) {
                return null;
            }
            Date date = this.parseString(dateStr, DEFAULT_DATE_FORMAT);
            Calendar calender = Calendar.getInstance();
            calender.setTime(date);
            return calender;
        }
        throw new IllegalArgumentException();
    }

    public void setDateValue(Calendar date) {
        if (date == null) {
            throw new IllegalArgumentException("date shouldn't be null.");
        }
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.DATE);
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        String svalue = simpleFormat.format(date.getTime());
        this.mCellElement.setOfficeDateValueAttribute(svalue);
        this.setDisplayTextContent(svalue, null);
    }

    public void setCellStyleName(String styleName) {
        this.mCellElement.setStyleName(styleName);
    }

    public String getCellStyleName() {
        return this.mCellElement.getStyleName();
    }

    public void setStringValue(String str) {
        if (str == null) {
            str = "";
        }
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.STRING);
        this.mCellElement.setOfficeStringValueAttribute(str);
        this.setDisplayTextContent(str, null);
    }

    void splitRepeatedCells() {
        int repeateNum;
        TableTableRowElement ownerRowElement;
        Table table = this.getTable();
        Row ownerRow = table.getRowInstance(ownerRowElement = this.getTableRowElement(), this.mnRepeatedRowIndex);
        if (ownerRow.getRowsRepeatedNumber() > 1) {
            ownerRow.splitRepeatedRows();
            ownerRowElement = ownerRow.maRowElement;
            this.mnRepeatedRowIndex = 0;
        }
        if ((repeateNum = this.getColumnsRepeatedNumber()) > 1) {
            int i;
            IdentityHashMap<TableTableCellElementBase, Vector<Cell>> cellRepository = table.mCellRepository;
            String tableNamespaceURI = OdfDocumentNamespace.TABLE.getUri();
            Vector oldList = null;
            if (cellRepository.containsKey(this.mCellElement)) {
                oldList = (Vector)cellRepository.remove(this.mCellElement);
            }
            int offetAfterCurrentCell = repeateNum - this.mnRepeatedColIndex - 1;
            TableTableCellElementBase currentCellElement = this.mCellElement;
            TableTableCellElementBase newBeforeCellElement = null;
            TableTableCellElementBase newAfterCellElement = null;
            if (this.mnRepeatedColIndex > 0) {
                newBeforeCellElement = (TableTableCellElementBase)this.mCellElement.cloneNode(true);
                if (this.mnRepeatedColIndex > 1) {
                    newBeforeCellElement.setTableNumberColumnsRepeatedAttribute(Integer.valueOf(this.mnRepeatedColIndex));
                } else {
                    newBeforeCellElement.removeAttributeNS(tableNamespaceURI, "number-columns-repeated");
                }
                ownerRowElement.insertBefore((Node)newBeforeCellElement, (Node)currentCellElement);
                if (oldList != null) {
                    Vector<Cell> newBeforeList = new Vector<Cell>(this.mnRepeatedColIndex);
                    for (i = 0; i < this.mnRepeatedColIndex && i < oldList.size(); ++i) {
                        Cell beforeCell = (Cell)oldList.get(i);
                        if (beforeCell == null) continue;
                        beforeCell.mCellElement = newBeforeCellElement;
                        newBeforeList.add(i, beforeCell);
                    }
                    cellRepository.put(newBeforeCellElement, newBeforeList);
                }
            }
            currentCellElement.removeAttributeNS(tableNamespaceURI, "number-columns-repeated");
            if (offetAfterCurrentCell > 0) {
                newAfterCellElement = (TableTableCellElementBase)currentCellElement.cloneNode(true);
                ownerRowElement.insertBefore((Node)newAfterCellElement, (Node)currentCellElement);
                currentCellElement = newAfterCellElement;
                newAfterCellElement = (TableTableCellElementBase)currentCellElement.getNextSibling();
                if (offetAfterCurrentCell > 1) {
                    newAfterCellElement.setTableNumberColumnsRepeatedAttribute(Integer.valueOf(offetAfterCurrentCell));
                }
                if (oldList != null) {
                    Vector<Cell> newAfterList = new Vector<Cell>(offetAfterCurrentCell);
                    for (i = this.mnRepeatedColIndex + 1; i < repeateNum && i < oldList.size(); ++i) {
                        Cell afterCell = (Cell)oldList.get(i);
                        if (afterCell == null) continue;
                        afterCell.mCellElement = newAfterCellElement;
                        afterCell.mnRepeatedColIndex = i - this.mnRepeatedColIndex - 1;
                        newAfterList.add(afterCell.mnRepeatedColIndex, afterCell);
                    }
                    cellRepository.put(newAfterCellElement, newAfterList);
                }
            }
            this.mnRepeatedColIndex = 0;
            this.mCellElement = currentCellElement;
            Vector<Cell> currentList = new Vector<Cell>(1);
            currentList.add(0, this);
            cellRepository.put(currentCellElement, currentList);
        }
    }

    public String getStringValue() {
        return this.getDisplayText();
    }

    public Calendar getTimeValue() {
        if (this.getTypeAttr() == OfficeValueTypeAttribute.Value.TIME) {
            String timeStr = this.mCellElement.getOfficeTimeValueAttribute();
            Date date = this.parseString(timeStr, DEFAULT_TIME_FORMAT);
            Calendar calender = Calendar.getInstance();
            calender.setTime(date);
            calender.clear(1);
            calender.clear(2);
            calender.clear(5);
            return calender;
        }
        throw new IllegalArgumentException();
    }

    public void setTimeValue(Calendar time) {
        if (time == null) {
            throw new IllegalArgumentException("time shouldn't be null.");
        }
        this.splitRepeatedCells();
        this.setTypeAttr(OfficeValueTypeAttribute.Value.TIME);
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DEFAULT_TIME_FORMAT);
        String svalue = simpleFormat.format(time.getTime());
        this.mCellElement.setOfficeTimeValueAttribute(svalue);
        this.setDisplayTextContent(svalue, null);
    }

    private Date parseString(String value, String format) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(format);
        Date simpleDate = null;
        try {
            simpleDate = simpleFormat.parse(value);
        }
        catch (ParseException e) {
            Logger.getLogger(Cell.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        return simpleDate;
    }

    public Color getCellBackgroundColor() {
        return this.getStyleHandler().getBackgroundColor();
    }

    @Deprecated
    public String getCellBackgroundColorString() {
        OdfStyleProperty bkColorProperty;
        String property;
        String color = DEFAULT_BACKGROUND_COLOR;
        OdfStyleBase styleElement = this.getStyleHandler().getCellStyleElementForRead();
        if (styleElement != null && Color.isValid((String)(property = styleElement.getProperty(bkColorProperty = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.TableCellProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.FO, (String)"background-color")))))) {
            color = property;
        }
        return color;
    }

    public void setCellBackgroundColor(Color cellBackgroundColor) {
        this.getStyleHandler().setBackgroundColor(cellBackgroundColor);
    }

    @Deprecated
    public void setCellBackgroundColor(String cellBackgroundColor) {
        if (!Color.isValid((String)cellBackgroundColor)) {
            Logger.getLogger(Cell.class.getName()).log(Level.WARNING, "Parameter is invalid for datatype Color, default background color #FFFFFF will be set.");
            cellBackgroundColor = DEFAULT_BACKGROUND_COLOR;
        }
        this.splitRepeatedCells();
        OdfStyle styleElement = this.getStyleHandler().getCellStyleElementForWrite();
        if (styleElement != null) {
            OdfStyleProperty bkColorProperty = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.TableCellProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.FO, (String)"background-color"));
            styleElement.setProperty(bkColorProperty, cellBackgroundColor);
        }
    }

    public int getColumnSpannedNumber() {
        if (this.mCellElement instanceof TableCoveredTableCellElement) {
            return 1;
        }
        Integer value = ((TableTableCellElement)this.mCellElement).getTableNumberColumnsSpannedAttribute();
        if (value != null) {
            return value;
        }
        return 1;
    }

    int getColumnsRepeatedNumber() {
        Integer value = this.mCellElement.getTableNumberColumnsRepeatedAttribute();
        if (value != null) {
            return value;
        }
        return 1;
    }

    public int getRowSpannedNumber() {
        if (this.mCellElement instanceof TableCoveredTableCellElement) {
            return 1;
        }
        Integer value = ((TableTableCellElement)this.mCellElement).getTableNumberRowsSpannedAttribute();
        if (value != null) {
            return value;
        }
        return 1;
    }

    void setColumnSpannedNumber(int spannedNum) {
        if (spannedNum < 1) {
            spannedNum = 1;
        }
        this.splitRepeatedCells();
        if (!(this.mCellElement instanceof TableTableCellElement)) {
            throw new IllegalArgumentException();
        }
        ((TableTableCellElement)this.mCellElement).setTableNumberColumnsSpannedAttribute(new Integer(spannedNum));
    }

    void setColumnsRepeatedNumber(int repeatedNum) {
        if (repeatedNum < 1) {
            repeatedNum = 1;
        }
        this.mCellElement.setTableNumberColumnsRepeatedAttribute(new Integer(repeatedNum));
    }

    void setRowSpannedNumber(int spannedNum) {
        if (spannedNum < 1) {
            spannedNum = 1;
        }
        this.splitRepeatedCells();
        if (!(this.mCellElement instanceof TableTableCellElement)) {
            throw new IllegalArgumentException();
        }
        ((TableTableCellElement)this.mCellElement).setTableNumberRowsSpannedAttribute(new Integer(spannedNum));
    }

    boolean isCoveredElement() {
        return this.mCellElement instanceof TableCoveredTableCellElement;
    }

    public String getStyleName() {
        OdfStyleBase style = this.getStyleHandler().getCellStyleElementForRead();
        if (style == null) {
            return "";
        }
        if (style instanceof OdfStyle) {
            return ((OdfStyle)style).getStyleNameAttribute();
        }
        return "";
    }

    public void setFormula(String formula) {
        if (formula == null) {
            throw new IllegalArgumentException("formula shouldn't be null.");
        }
        this.splitRepeatedCells();
        this.mCellElement.setTableFormulaAttribute(formula);
    }

    public String getFormula() {
        return this.mCellElement.getTableFormulaAttribute();
    }

    public void setCurrencyFormat(String currencySymbol, String format) {
        if (currencySymbol == null) {
            throw new IllegalArgumentException("currencySymbol shouldn't be null.");
        }
        if (format == null) {
            throw new IllegalArgumentException("format shouldn't be null.");
        }
        this.splitRepeatedCells();
        String type = this.mCellElement.getOfficeValueTypeAttribute();
        OfficeValueTypeAttribute.Value typeValue = null;
        this.msFormatString = format;
        if (type != null) {
            typeValue = OfficeValueTypeAttribute.Value.enumValueOf((String)type);
        }
        if (typeValue != OfficeValueTypeAttribute.Value.CURRENCY) {
            throw new IllegalArgumentException();
        }
        OdfNumberCurrencyStyle currencyStyle = new OdfNumberCurrencyStyle((OdfFileDom)this.mCellElement.getOwnerDocument(), currencySymbol, format, this.getUniqueCurrencyStyleName());
        this.mCellElement.getAutomaticStyles().appendChild((Node)currencyStyle);
        this.setDataDisplayStyleName(currencyStyle.getStyleNameAttribute());
        Double value = this.getCurrencyValue();
        if (value != null) {
            this.setDisplayTextContent(this.formatCurrency(currencyStyle, value), null);
        }
    }

    private String formatCurrency(OdfNumberCurrencyStyle currencyStyle, double value) {
        String valuestr = "";
        for (Node m : new DomNodeList(currencyStyle.getChildNodes())) {
            if (m instanceof NumberCurrencySymbolElement) {
                valuestr = valuestr + m.getTextContent();
                continue;
            }
            if (m instanceof NumberNumberElement) {
                String numberformat = currencyStyle.getNumberFormat();
                valuestr = valuestr + new DecimalFormat(numberformat).format(value);
                continue;
            }
            if (!(m instanceof NumberTextElement)) continue;
            String textcontent = m.getTextContent();
            if (textcontent == null || textcontent.length() == 0) {
                textcontent = " ";
            }
            valuestr = valuestr + textcontent;
        }
        return valuestr;
    }

    public void setFormatString(String formatStr) {
        if (formatStr == null) {
            throw new IllegalArgumentException("formatStr shouldn't be null.");
        }
        String type = this.getValueType();
        if (type == null) {
            if (formatStr.contains("%")) {
                this.setValueType("percentage");
            } else if (formatStr.contains("H") || formatStr.contains("k") || formatStr.contains("m") || formatStr.contains("s") || formatStr.contains("S")) {
                this.setValueType("time");
            } else if (formatStr.contains("y") || formatStr.contains("M") || formatStr.contains("w") || formatStr.contains("W") || formatStr.contains("D") || formatStr.contains("d") || formatStr.contains("F") || formatStr.contains("E") || formatStr.contains("K") || formatStr.contains("h")) {
                this.setValueType("date");
            } else if (formatStr.contains("#") || formatStr.contains("0")) {
                this.setValueType("float");
            } else {
                throw new UnsupportedOperationException("format string: " + formatStr + " can't be adapted to a possible value type.");
            }
            type = this.getValueType();
        }
        this.setCellFormatString(formatStr, type);
    }

    private void setCellFormatString(String formatStr, String type) {
        OfficeValueTypeAttribute.Value typeValue = null;
        this.msFormatString = formatStr;
        this.splitRepeatedCells();
        typeValue = OfficeValueTypeAttribute.Value.enumValueOf((String)type);
        if (typeValue == OfficeValueTypeAttribute.Value.FLOAT) {
            OdfNumberStyle numberStyle = new OdfNumberStyle((OdfFileDom)this.mCellElement.getOwnerDocument(), formatStr, this.getUniqueNumberStyleName());
            this.mCellElement.getAutomaticStyles().appendChild((Node)numberStyle);
            this.setDataDisplayStyleName(numberStyle.getStyleNameAttribute());
            Double value = this.getDoubleValue();
            if (value != null) {
                this.setDisplayTextContent(new DecimalFormat(formatStr).format(value), null);
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.DATE) {
            OdfNumberDateStyle dateStyle = new OdfNumberDateStyle((OdfFileDom)this.mCellElement.getOwnerDocument(), formatStr, this.getUniqueDateStyleName(), null);
            this.mCellElement.getAutomaticStyles().appendChild((Node)dateStyle);
            this.setDataDisplayStyleName(dateStyle.getStyleNameAttribute());
            String dateStr = this.mCellElement.getOfficeDateValueAttribute();
            if (dateStr != null) {
                Calendar date = this.getDateValue();
                this.setDisplayTextContent(new SimpleDateFormat(formatStr).format(date.getTime()), null);
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.TIME) {
            OdfNumberTimeStyle timeStyle = new OdfNumberTimeStyle((OdfFileDom)this.mCellElement.getOwnerDocument(), formatStr, this.getUniqueDateStyleName());
            this.mCellElement.getAutomaticStyles().appendChild((Node)timeStyle);
            this.setDataDisplayStyleName(timeStyle.getStyleNameAttribute());
            String timeStr = this.mCellElement.getOfficeTimeValueAttribute();
            if (timeStr != null) {
                Calendar time = this.getTimeValue();
                this.setDisplayTextContent(new SimpleDateFormat(formatStr).format(time.getTime()), null);
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.PERCENTAGE) {
            OdfNumberPercentageStyle dateStyle = new OdfNumberPercentageStyle((OdfFileDom)this.mCellElement.getOwnerDocument(), formatStr, this.getUniquePercentageStyleName());
            this.mCellElement.getAutomaticStyles().appendChild((Node)dateStyle);
            this.setDataDisplayStyleName(dateStyle.getStyleNameAttribute());
            Double value = this.getPercentageValue();
            if (value != null) {
                this.setDisplayTextContent(new DecimalFormat(formatStr).format(value), null);
            }
        } else {
            throw new IllegalArgumentException("This function doesn't support " + typeValue + " cell.");
        }
    }

    private void setDataDisplayStyleName(String name) {
        OdfStyle styleElement = this.getStyleHandler().getCellStyleElementForWrite();
        if (styleElement != null) {
            styleElement.setOdfAttributeValue(OdfName.newName((NamespaceName)OdfDocumentNamespace.STYLE, (String)"data-style-name"), name);
        }
    }

    private String getDataDisplayStyleName() {
        String datadisplayStylename = null;
        OdfStyleBase styleElement = this.getStyleHandler().getCellStyleElementForRead();
        if (styleElement != null) {
            datadisplayStylename = styleElement.getOdfAttributeValue(OdfName.newName((NamespaceName)OdfDocumentNamespace.STYLE, (String)"data-style-name"));
        }
        return datadisplayStylename;
    }

    private String getUniqueNumberStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.mCellElement.getAutomaticStyles();
        while (styles.getNumberStyle(unique_name = String.format("n%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    private String getUniqueDateStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.mCellElement.getAutomaticStyles();
        while (styles.getDateStyle(unique_name = String.format("d%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    private String getUniquePercentageStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.mCellElement.getAutomaticStyles();
        while (styles.getPercentageStyle(unique_name = String.format("p%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    private String getUniqueCurrencyStyleName() {
        String unique_name;
        OdfOfficeAutomaticStyles styles = this.mCellElement.getAutomaticStyles();
        while (styles.getCurrencyStyle(unique_name = String.format("c%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    public String getFormatString() {
        String type = this.mCellElement.getOfficeValueTypeAttribute();
        OfficeValueTypeAttribute.Value typeValue = null;
        if (type != null) {
            typeValue = OfficeValueTypeAttribute.Value.enumValueOf((String)type);
        }
        if (typeValue == OfficeValueTypeAttribute.Value.FLOAT) {
            String name = this.getDataDisplayStyleName();
            OdfNumberStyle style = this.mCellElement.getAutomaticStyles().getNumberStyle(name);
            if (style == null) {
                style = this.mDocument.getDocumentStyles().getNumberStyle(name);
            }
            if (style != null) {
                return style.getFormat();
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.DATE) {
            String name = this.getDataDisplayStyleName();
            OdfNumberDateStyle style = this.mCellElement.getAutomaticStyles().getDateStyle(name);
            if (style == null) {
                style = this.mDocument.getDocumentStyles().getDateStyle(name);
            }
            if (style != null) {
                return style.getFormat();
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.TIME) {
            String name = this.getDataDisplayStyleName();
            OdfNumberDateStyle style = this.mCellElement.getAutomaticStyles().getDateStyle(name);
            if (style == null) {
                style = this.mDocument.getDocumentStyles().getDateStyle(name);
            }
            if (style != null) {
                return style.getFormat();
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.CURRENCY) {
            String name = this.getCurrencyDisplayStyleName();
            OdfNumberCurrencyStyle dataStyle = this.mCellElement.getAutomaticStyles().getCurrencyStyle(name);
            if (dataStyle == null) {
                dataStyle = this.mDocument.getDocumentStyles().getCurrencyStyle(name);
            }
            if (dataStyle != null) {
                return dataStyle.getFormat();
            }
        } else if (typeValue == OfficeValueTypeAttribute.Value.PERCENTAGE) {
            String name = this.getDataDisplayStyleName();
            OdfNumberPercentageStyle style = this.mCellElement.getAutomaticStyles().getPercentageStyle(name);
            if (style == null) {
                style = this.mDocument.getDocumentStyles().getPercentageStyle(name);
            }
            if (style != null) {
                return style.getFormat();
            }
        }
        return null;
    }

    private String getCurrencyDisplayStyleName() {
        String name = this.getDataDisplayStyleName();
        OdfNumberCurrencyStyle dataStyle = this.mCellElement.getAutomaticStyles().getCurrencyStyle(name);
        if (dataStyle == null) {
            dataStyle = this.mDocument.getDocumentStyles().getCurrencyStyle(name);
        }
        if (dataStyle != null) {
            return dataStyle.getConditionStyleName(this.getCurrencyValue().doubleValue());
        }
        return null;
    }

    public void removeTextContent() {
        this.splitRepeatedCells();
        Node node = this.mCellElement.getFirstChild();
        while (node != null) {
            Node nextNode = node.getNextSibling();
            if (node instanceof TextPElement || node instanceof TextHElement || node instanceof TextListElement) {
                this.mCellElement.removeChild(node);
            }
            node = nextNode;
        }
    }

    public void removeContent() {
        this.splitRepeatedCells();
        Node node = this.mCellElement.getFirstChild();
        while (node != null) {
            Node nextNode = node.getNextSibling();
            this.mCellElement.removeChild(node);
            node = nextNode;
        }
    }

    void appendContentFrom(Cell fromCell) {
        this.splitRepeatedCells();
        TableTableCellElementBase cell = fromCell.getOdfElement();
        for (Node node = cell.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof OdfTextParagraph) {
                if (TextExtractor.getText((OdfElement)((OdfTextParagraph)node)).equals("")) continue;
                this.mCellElement.appendChild(node.cloneNode(true));
                continue;
            }
            this.mCellElement.appendChild(node.cloneNode(true));
        }
    }

    Cell getCoverCell() {
        int startRowi = this.getRowIndex();
        int startColumni = this.getColumnIndex();
        for (int i = startRowi; i >= 0; --i) {
            Row aRow = this.mOwnerTable.getRowByIndex(i);
            for (int j = startColumni; j >= 0; --j) {
                TableTableCellElement cellEle;
                Cell cell;
                if (i == startRowi && j == startColumni || !((cell = aRow.getCellByIndex(j)).getOdfElement() instanceof TableTableCellElement) || (cellEle = (TableTableCellElement)cell.getOdfElement()).getTableNumberColumnsSpannedAttribute() + j <= startColumni || cellEle.getTableNumberRowsSpannedAttribute() + i <= startRowi) continue;
                return this.mOwnerTable.getCellInstance((TableTableCellElementBase)cellEle, 0, 0);
            }
        }
        return null;
    }

    Cell getCoverCellInSameRow() {
        int startRowi = this.getRowIndex();
        int startColumni = this.getColumnIndex();
        for (int j = startColumni - 1; j >= 0; --j) {
            Cell cell = this.mOwnerTable.getCellByPosition(j, startRowi);
            if (cell.getOdfElement() instanceof TableCoveredTableCellElement) continue;
            int oldSpanN = cell.getColumnSpannedNumber();
            if (oldSpanN + j > startColumni) {
                return cell;
            }
            return null;
        }
        return null;
    }

    Cell getCoverCellInSameColumn() {
        int startRowi = this.getRowIndex();
        int startColumni = this.getColumnIndex();
        for (int i = startRowi - 1; i >= 0; --i) {
            Cell cell = this.mOwnerTable.getCellByPosition(startColumni, i);
            if (cell.getOdfElement() instanceof TableCoveredTableCellElement) continue;
            int oldSpanN = cell.getRowSpannedNumber();
            if (oldSpanN + i > startRowi) {
                return cell;
            }
            return null;
        }
        return null;
    }

    public Font getFont() {
        return this.getStyleHandler().getFont(Document.ScriptType.WESTERN);
    }

    public void setFont(Font font) {
        this.getStyleHandler().setFont(font);
    }

    public void setBorders(StyleTypeDefinitions.CellBordersType bordersType, Border border) {
        this.getStyleHandler().setBorders(border, bordersType);
    }

    public Border getBorder(StyleTypeDefinitions.CellBordersType type) {
        return this.getStyleHandler().getBorder(type);
    }

    public String getNoteText() {
        String noteString = null;
        OfficeAnnotationElement annotation = (OfficeAnnotationElement)OdfElement.findFirstChildNode(OfficeAnnotationElement.class, (Node)this.mCellElement);
        if (annotation != null) {
            noteString = "";
            Node n = annotation.getFirstChild();
            while (n != null) {
                Node m = n.getNextSibling();
                if (n instanceof TextPElement || n instanceof TextListElement) {
                    noteString = noteString + TextExtractor.getText((OdfElement)n);
                }
                n = m;
            }
        }
        return noteString;
    }

    public void setNoteText(String note) {
        TextPElement noteElement;
        this.splitRepeatedCells();
        OfficeAnnotationElement annotation = (OfficeAnnotationElement)OdfElement.findFirstChildNode(OfficeAnnotationElement.class, (Node)this.mCellElement);
        if (annotation == null) {
            OdfFileDom dom = (OdfFileDom)this.mCellElement.getOwnerDocument();
            annotation = (OfficeAnnotationElement)OdfXMLFactory.newOdfElement((OdfFileDom)dom, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.OFFICE, (String)"annotation"));
        }
        if ((noteElement = (TextPElement)OdfElement.findFirstChildNode(TextPElement.class, (Node)annotation)) == null) {
            noteElement = annotation.newTextPElement();
        }
        noteElement.setTextContent(note);
        DcCreatorElement dcCreatorElement = (DcCreatorElement)OdfElement.findFirstChildNode(DcCreatorElement.class, (Node)annotation);
        if (dcCreatorElement == null) {
            dcCreatorElement = annotation.newDcCreatorElement();
        }
        dcCreatorElement.setTextContent(System.getProperty("user.name"));
        String dcDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
        DcDateElement dcDateElement = (DcDateElement)OdfElement.findFirstChildNode(DcDateElement.class, (Node)annotation);
        if (dcDateElement == null) {
            dcDateElement = annotation.newDcDateElement();
        }
        dcDateElement.setTextContent(dcDate);
        this.mCellElement.appendChild((Node)annotation);
    }

    public CellStyleHandler getStyleHandler() {
        if (this.mStyleHandler == null) {
            this.mStyleHandler = new CellStyleHandler(this);
        }
        return this.mStyleHandler;
    }

    @Override
    public OdfElement getListContainerElement() {
        return this.listContainerImpl.getListContainerElement();
    }

    @Override
    public org.odftoolkit.simple.text.list.List addList() {
        Document ownerDocument = this.getTable().getOwnerDocument();
        if (ownerDocument instanceof SpreadsheetDocument) {
            throw new UnsupportedOperationException("Open Office and Symphony can't show a list in spreadsheet document cell.");
        }
        return this.listContainerImpl.addList();
    }

    @Override
    public org.odftoolkit.simple.text.list.List addList(ListDecorator decorator) {
        Document ownerDocument = this.getTable().getOwnerDocument();
        if (ownerDocument instanceof SpreadsheetDocument) {
            throw new UnsupportedOperationException("Open Office and Symphony can't show a list in spreadsheet document cell.");
        }
        return this.listContainerImpl.addList(decorator);
    }

    @Override
    public void clearList() {
        this.listContainerImpl.clearList();
    }

    @Override
    public Iterator<org.odftoolkit.simple.text.list.List> getListIterator() {
        return this.listContainerImpl.getListIterator();
    }

    @Override
    public boolean removeList(org.odftoolkit.simple.text.list.List list) {
        return this.listContainerImpl.removeList(list);
    }

    private class ListContainerImpl
    extends AbstractListContainer {
        private ListContainerImpl() {
        }

        public OdfElement getListContainerElement() {
            return Cell.this.mCellElement;
        }
    }
}

