/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.datetime;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.pojava.datetime.CalendarUnit;
import org.pojava.datetime.DateTimeConfig;
import org.pojava.datetime.DateTimeFormat;
import org.pojava.datetime.Duration;
import org.pojava.datetime.IDateTimeConfig;
import org.pojava.datetime.LocalConfig;
import org.pojava.datetime.Shift;
import org.pojava.datetime.Tm;

public class DateTime
implements Serializable,
Comparable<DateTime> {
    private static final long serialVersionUID = 300L;
    private static final int FEB = 1;
    private static final int APR = 3;
    private static final int JUN = 5;
    private static final int SEP = 8;
    private static final int NOV = 10;
    protected IDateTimeConfig config;
    protected Duration systemDur = null;
    private static final Pattern partsPattern = Pattern.compile("[^\\p{L}\\d]+");

    public DateTime() {
        this.config();
        this.systemDur = new Duration(this.config.systemTime());
    }

    public DateTime(IDateTimeConfig config) {
        this.config = config;
        this.systemDur = new Duration(config.systemTime());
    }

    public DateTime(long millis) {
        this.config();
        this.systemDur = new Duration(millis);
    }

    public DateTime(long millis, IDateTimeConfig config) {
        this.config = config;
        this.systemDur = new Duration(millis);
    }

    public DateTime(long millis, TimeZone tz) {
        this.config = LocalConfig.instanceOverridingOutputTimeZone(DateTimeConfig.getGlobalDefault(), tz);
        this.systemDur = new Duration(millis);
    }

    public DateTime(long millis, String tzId) {
        IDateTimeConfig globalConfig = DateTimeConfig.getGlobalDefault();
        TimeZone tz = globalConfig.lookupTimeZone(tzId);
        this.config = LocalConfig.instanceOverridingOutputTimeZone(globalConfig, tz);
        this.systemDur = new Duration(millis);
    }

    public DateTime(long seconds, int nanos) {
        this.config();
        this.systemDur = new Duration(seconds, nanos);
    }

    public DateTime(long seconds, int nanos, TimeZone tz) {
        this.config = LocalConfig.instanceOverridingOutputTimeZone(DateTimeConfig.getGlobalDefault(), tz);
        this.systemDur = new Duration(seconds, nanos);
    }

    public DateTime(long seconds, int nanos, String tzId) {
        IDateTimeConfig globalConfig = DateTimeConfig.getGlobalDefault();
        TimeZone tz = globalConfig.lookupTimeZone(tzId);
        this.config = LocalConfig.instanceOverridingOutputTimeZone(globalConfig, tz);
        this.systemDur = new Duration(seconds, nanos);
    }

    public DateTime(long seconds, int nanos, IDateTimeConfig config) {
        this.config = config;
        this.systemDur = new Duration(seconds, nanos);
    }

    public DateTime(String str) {
        this.config = DateTimeConfig.getGlobalDefault();
        DateTime dt = DateTime.parse(str, this.config);
        this.systemDur = dt.systemDur;
    }

    public DateTime(String str, IDateTimeConfig config) {
        this.config = config;
        DateTime dt = DateTime.parse(str, config);
        this.systemDur = dt.systemDur;
    }

    public DateTime(String str, TimeZone tz) {
        IDateTimeConfig globalConfig = DateTimeConfig.getGlobalDefault();
        this.config = LocalConfig.instanceOverridingTimeZones(globalConfig, tz, tz);
        DateTime dt = DateTime.parse(str, this.config);
        this.systemDur = dt.systemDur;
    }

    public DateTime(String str, TimeZone inputTz, TimeZone outputTz) {
        IDateTimeConfig globalConfig = DateTimeConfig.getGlobalDefault();
        this.config = LocalConfig.instanceOverridingTimeZones(globalConfig, inputTz, outputTz);
        DateTime dt = DateTime.parse(str, this.config);
        this.systemDur = dt.systemDur;
    }

    public DateTime(Timestamp ts) {
        this.config();
        this.systemDur = new Duration(ts.getTime() / 1000L, ts.getNanos());
    }

    private static String tzParse(String str) {
        int max;
        int idx;
        char[] chars = str.toCharArray();
        int min = 7;
        char c = '\u0000';
        for (idx = max = str.length() - 1; idx > min && ((c = chars[idx]) >= '0' && c <= '9' || c == ':'); --idx) {
        }
        if (idx >= min && (c == '+' || c == '-')) {
            return str.substring(idx);
        }
        while (idx >= min) {
            c = chars[idx];
            if (c >= 'A' && c <= 'Z' || c == '_' || c == '/' || c >= '0' && c <= '9') {
                --idx;
                continue;
            }
            ++idx;
            while (idx < max && chars[idx] >= '0' && chars[idx] <= '9' && ++idx != max) {
            }
            break block1;
        }
        if (idx < min || idx > max) {
            return null;
        }
        c = chars[idx];
        if (c >= 'A' && c <= 'Z') {
            return str.substring(idx);
        }
        return null;
    }

    @Override
    public int compareTo(DateTime other) {
        if (other == null) {
            throw new NullPointerException("Cannot compare DateTime to null.");
        }
        return this.systemDur.compareTo(other.systemDur);
    }

    public Timestamp toTimestamp() {
        Timestamp ts = new Timestamp(this.systemDur.toMillis());
        if (this.systemDur.getNanos() > 0) {
            ts.setNanos(this.systemDur.getNanos());
        }
        return ts;
    }

    public Date toDate() {
        return new Date(this.systemDur.toMillis());
    }

    public TimeZone timeZone() {
        return this.config().getOutputTimeZone();
    }

    public String toString() {
        return DateTimeFormat.format(this.config().getFormat(), this, this.config.getOutputTimeZone(), this.config.getLocale());
    }

    public String toString(String format) {
        return DateTimeFormat.format(format, this, this.config().getOutputTimeZone(), this.config().getLocale());
    }

    public String toString(String format, TimeZone tz) {
        return DateTimeFormat.format(format, this, tz, this.config().getLocale());
    }

    public String toString(String format, Locale locale) {
        return DateTimeFormat.format(format, this, this.timeZone(), locale);
    }

    public String toString(TimeZone tz) {
        return DateTimeFormat.format(this.config().getFormat(), this, tz, this.config().getLocale());
    }

    public String toString(String format, TimeZone tz, Locale locale) {
        return DateTimeFormat.format(format, this, tz, locale);
    }

    public DateTime add(Duration dur) {
        Duration calcDur = dur.add(this.getSeconds(), this.getNanos());
        return new DateTime(calcDur.getSeconds(), calcDur.getNanos(), this.config());
    }

    public DateTime add(long milliseconds) {
        Duration dur = this.systemDur.add(milliseconds);
        return new DateTime(dur.getSeconds(), dur.getNanos(), this.config());
    }

    public DateTime add(CalendarUnit calUnit, int qty) {
        return this.shift(calUnit, qty);
    }

    private DateTime shiftUsingRecalculatedOffset(long milliseconds) {
        long beginningOffset = this.config.getOutputTimeZone().getOffset(this.toMillis());
        long unadjustedShift = this.toMillis() + milliseconds;
        long endingOffset = this.config.getOutputTimeZone().getOffset(unadjustedShift);
        return this.add(milliseconds - beginningOffset + endingOffset);
    }

    public DateTime shift(CalendarUnit calUnit, int qty) {
        if (calUnit.compareTo(CalendarUnit.DAY) < 0) {
            if (calUnit == CalendarUnit.HOUR) {
                return this.shiftUsingRecalculatedOffset((long)qty * 3600000L);
            }
            if (calUnit == CalendarUnit.MINUTE) {
                return this.shiftUsingRecalculatedOffset((long)qty * 60000L);
            }
            if (calUnit == CalendarUnit.SECOND) {
                return this.shiftUsingRecalculatedOffset((long)qty * 1000L);
            }
            if (calUnit == CalendarUnit.MILLISECOND) {
                return this.shiftUsingRecalculatedOffset(qty);
            }
            if (calUnit == CalendarUnit.MICROSECOND) {
                long nanos = this.getNanos() + qty * 1000;
                long seconds = nanos / 1000000000L;
                int remainder = (int)(nanos - seconds * 1000000000L);
                return new DateTime(this.systemDur.getSeconds() + seconds, remainder, this.config);
            }
            if (calUnit == CalendarUnit.NANOSECOND) {
                long nanos = this.getNanos() + qty;
                long seconds = nanos / 1000000000L;
                int remainder = (int)(nanos - seconds * 1000000000L);
                return new DateTime(this.systemDur.getSeconds() + seconds, remainder, this.config);
            }
        }
        Calendar cal = Calendar.getInstance(this.config().getInputTimeZone(), this.config().getLocale());
        cal.setTimeInMillis(this.systemDur.millis);
        if (calUnit == CalendarUnit.DAY) {
            cal.add(5, qty);
        } else if (calUnit == CalendarUnit.WEEK) {
            cal.add(5, qty * 7);
        } else if (calUnit == CalendarUnit.MONTH) {
            cal.add(2, qty);
        } else if (calUnit == CalendarUnit.QUARTER) {
            cal.add(2, qty * 3);
        } else if (calUnit == CalendarUnit.YEAR) {
            cal.add(1, qty);
        } else if (calUnit == CalendarUnit.CENTURY) {
            cal.add(1, 100 * qty);
        }
        return new DateTime(cal.getTimeInMillis() / 1000L, this.systemDur.getNanos(), this.config);
    }

    public DateTime shift(Shift shift) {
        if (shift == null) {
            return this;
        }
        Calendar cal = Calendar.getInstance(this.config().getOutputTimeZone(), this.config().getLocale());
        cal.setTimeInMillis(this.systemDur.millis);
        if (shift.getYear() != 0) {
            cal.add(1, shift.getYear());
        }
        if (shift.getMonth() != 0) {
            cal.add(2, shift.getMonth());
        }
        if (shift.getWeek() != 0) {
            cal.add(5, shift.getWeek() * 7);
        }
        if (shift.getDay() != 0) {
            cal.add(5, shift.getDay());
        }
        if (shift.getHour() != 0) {
            cal.add(10, shift.getHour());
        }
        if (shift.getMinute() != 0) {
            cal.add(12, shift.getMinute());
        }
        if (shift.getSecond() != 0) {
            cal.add(13, shift.getSecond());
        }
        return new DateTime(cal.getTimeInMillis() / 1000L, this.systemDur.getNanos() + shift.getNanosec(), this.config);
    }

    public DateTime shift(String iso8601) {
        return this.shift(new Shift(iso8601));
    }

    public int weekday() {
        long offset = (long)this.config().getEpochDOW() * 86400000L + 62899200000000L;
        long leftover = offset + this.toMillis() + (long)this.config().getOutputTimeZone().getOffset(this.toMillis());
        leftover %= 604800000L;
        leftover /= 86400000L;
        return (int)(++leftover);
    }

    private static DateTime parseRelativeDate(String str, IDateTimeConfig config) {
        char firstChar = str.charAt(0);
        char lastChar = str.charAt(str.length() - 1);
        DateTime dt = new DateTime(config);
        if ((firstChar == '+' || firstChar == '-') && lastChar >= '0' && lastChar <= '9' && DateTime.onlyDigits(str.substring(1))) {
            int offset = new Integer(firstChar == '+' ? str.substring(1) : str);
            return dt.add(CalendarUnit.DAY, offset);
        }
        if (lastChar == 'D' || lastChar == 'Y' || lastChar == 'M') {
            CalendarUnit unit = lastChar == 'D' ? CalendarUnit.DAY : (lastChar == 'Y' ? CalendarUnit.YEAR : CalendarUnit.MONTH);
            String inner = str.substring(firstChar >= '0' && firstChar <= '9' ? 0 : 1, str.length() - 1);
            if (firstChar == '+' && DateTime.onlyDigits(inner)) {
                int offset = new Integer(inner);
                return dt.add(unit, offset);
            }
            if ((firstChar == '-' || firstChar >= '0' && firstChar <= '9') && DateTime.isInteger(inner)) {
                String offset = firstChar == '-' ? "-" + inner : inner;
                int innerVal = new Integer(offset);
                return dt.add(unit, innerVal);
            }
        }
        throw new IllegalArgumentException("Could not parse date from '" + str + "'");
    }

    public static DateTime parse(String str) {
        IDateTimeConfig config = DateTimeConfig.getGlobalDefault();
        return DateTime.parse(str, config);
    }

    public static void assignIntegersToRemainingSlots(IDateTimeConfig config, HasDatepart hasDatepart, DateState dateState) {
        for (int i = 0; i < dateState.parts.length; ++i) {
            if (!dateState.integers[i] || dateState.usedint[i]) continue;
            int part = DateTime.parseIntFragment(dateState.parts[i]);
            if (!hasDatepart.day && part < 32 && config.isDmyOrder() && !dateState.isYearFirst) {
                dateState.day = part;
                hasDatepart.day = true;
                dateState.usedint[i] = true;
                continue;
            }
            if (!hasDatepart.month) {
                if (part < 1 || part > 12) {
                    throw new IllegalArgumentException("Invalid month parsed from [" + part + "].");
                }
                dateState.month = part - 1;
                hasDatepart.month = true;
                dateState.usedint[i] = true;
                continue;
            }
            if (!hasDatepart.day) {
                if (part < 1 || part > 31) {
                    throw new IllegalArgumentException("Invalid day parsed from [" + part + "].");
                }
                dateState.day = part;
                hasDatepart.day = true;
                dateState.usedint[i] = true;
                continue;
            }
            if (!hasDatepart.year && part < 1000) {
                if (part > 99) {
                    dateState.year = 1900 + part;
                } else {
                    dateState.isTwoDigitYear = true;
                    dateState.year = dateState.centuryTurn + part - dateState.thisYear > 20 ? dateState.centuryTurn + part - 100 : dateState.centuryTurn + part;
                }
                hasDatepart.year = true;
                dateState.usedint[i] = true;
                continue;
            }
            if (!hasDatepart.day || !hasDatepart.year) {
                throw new IllegalArgumentException("Unable to determine valid placement for parsed value [" + part + "].");
            }
            if (!hasDatepart.hour) {
                if (part >= 24) {
                    throw new IllegalArgumentException("Invalid hour parsed from [" + part + "].");
                }
                dateState.hour = part;
                hasDatepart.hour = true;
                if (dateState.parts[i].indexOf(72) == -1) {
                    dateState.usedint[i] = true;
                    continue;
                }
                dateState.parts[i] = dateState.parts[i].substring(dateState.parts[i].indexOf(72) + 1);
                part = DateTime.parseIntFragment(dateState.parts[i]);
            }
            if (!hasDatepart.minute) {
                if (part >= 60) {
                    throw new IllegalArgumentException("Invalid minute parsed from [" + part + "].");
                }
                dateState.minute = part;
                hasDatepart.minute = true;
                if (dateState.parts[i].indexOf(77) == -1) {
                    dateState.usedint[i] = true;
                    continue;
                }
                dateState.parts[i] = dateState.parts[i].substring(dateState.parts[i].indexOf(77) + 1);
                part = DateTime.parseIntFragment(dateState.parts[i]);
            }
            if (!hasDatepart.second) {
                if (part < 60 || part == 60 && dateState.minute == 59 && dateState.hour == 23 && dateState.day >= 30 && (dateState.month == 11 || dateState.month == 5)) {
                    dateState.second = part;
                    hasDatepart.second = true;
                    dateState.usedint[i] = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid second parsed from [" + part + "].");
            }
            if (hasDatepart.nanosecond) continue;
            if (part >= 1000000000) {
                throw new IllegalArgumentException("Invalid nanosecond parsed from [" + part + "].");
            }
            dateState.nanosecond = Integer.parseInt((dateState.parts[i].split("[^0-9]+")[0] + "00000000").substring(0, 9));
            hasDatepart.nanosecond = true;
            dateState.usedint[i] = true;
        }
    }

    private static void scanForTextualMonth(IDateTimeConfig config, HasDatepart hasDatepart, DateState dateState) {
        for (int i = 0; i < dateState.parts.length; ++i) {
            Integer monthIndex;
            if (!dateState.integers[i] && dateState.parts[i].length() > 2 && (monthIndex = config.lookupMonthIndex(dateState.parts[i])) != null) {
                dateState.month = monthIndex;
                hasDatepart.month = true;
                break;
            }
            if (hasDatepart.month) break;
        }
    }

    private static void adjustHourBasedOnAMPM(DateState dateState) {
        for (String part : dateState.parts) {
            if (!part.endsWith("M")) continue;
            if (part.endsWith("PM") && dateState.hour > 0 && dateState.hour < 12) {
                dateState.hour += 12;
                continue;
            }
            if (!part.endsWith("AM") || dateState.hour != 12) continue;
            dateState.hour = 0;
        }
    }

    private static void scanForYYYYOrYYYYMMDD(IDateTimeConfig config, HasDatepart hasDatepart, DateState dateState) {
        for (int i = 0; i < dateState.parts.length; ++i) {
            char c;
            if (!dateState.integers[i] || dateState.usedint[i]) continue;
            if (!(hasDatepart.year || dateState.parts[i].length() != 4 && dateState.parts[i].length() != 5 || (c = dateState.parts[i].charAt(dateState.parts[i].length() - 1)) < '0' || c > '9')) {
                dateState.year = DateTime.parseIntFragment(dateState.parts[i]);
                hasDatepart.year = true;
                dateState.usedint[i] = true;
                boolean bl = dateState.isYearFirst = i == 0;
                if (config.isDmyOrder()) {
                    if (hasDatepart.month || i <= 0 || !dateState.integers[i - 1] || dateState.usedint[i - 1]) break;
                    dateState.month = DateTime.parseIntFragment(dateState.parts[i - 1]);
                    --dateState.month;
                    hasDatepart.month = true;
                    dateState.usedint[i - 1] = true;
                    break;
                }
                if (hasDatepart.day || i <= 0 || !dateState.integers[i - 1] || dateState.usedint[i - 1]) break;
                dateState.day = DateTime.parseIntFragment(dateState.parts[i - 1]);
                hasDatepart.day = true;
                dateState.usedint[i - 1] = true;
                break;
            }
            if (hasDatepart.year || hasDatepart.month || hasDatepart.day || dateState.parts[i].length() != 8) continue;
            dateState.year = Integer.parseInt(dateState.parts[i].substring(0, 4));
            dateState.month = Integer.parseInt(dateState.parts[i].substring(4, 6));
            --dateState.month;
            dateState.day = Integer.parseInt(dateState.parts[i].substring(6, 8));
            hasDatepart.year = true;
            hasDatepart.month = true;
            hasDatepart.day = true;
            dateState.usedint[i] = true;
        }
    }

    private static void validateParsedDate(String dateString, HasDatepart hasDatepart, DateState dateState) {
        if (!hasDatepart.year || !hasDatepart.month) {
            throw new IllegalArgumentException("Could not determine Year, Month, and Day from '" + dateString + "'");
        }
        if (dateState.month == 1) {
            if (dateState.day > 28 + (dateState.year % 4 == 0 ? 1 : 0)) {
                throw new IllegalArgumentException("February " + dateState.day + " does not exist in " + dateState.year);
            }
        } else if (dateState.month == 8 || dateState.month == 3 || dateState.month == 5 || dateState.month == 10) {
            if (dateState.day > 30) {
                throw new IllegalArgumentException("30 days hath Sep, Apr, Jun, and Nov... not " + dateState.day);
            }
        } else {
            if (dateState.month < 0 || dateState.month > 11) {
                throw new IllegalArgumentException("Could not determine a valid month");
            }
            if (dateState.day > 31) {
                throw new IllegalArgumentException("No month has " + dateState.day + " days in it.");
            }
        }
    }

    public static DateTime parse(String str, IDateTimeConfig config) {
        String masked;
        String tzString;
        HasDatepart hasDatepart = new HasDatepart();
        DateState dateState = new DateState();
        if (config == null) {
            config = DateTimeConfig.getGlobalDefault();
        }
        if (str == null) {
            return new DateTime(config.systemTime(), config);
        }
        if ((str = str.trim().toUpperCase(config.getLocale())).length() == 0) {
            throw new IllegalArgumentException("Cannot parse DateTime from empty string.");
        }
        if (str.indexOf(84) > 0) {
            str = str.replaceFirst("([0-9])T([0-9])", "$1 $2");
        }
        if (str.charAt(0) == '+' || str.charAt(0) == '-') {
            return DateTime.parseRelativeDate(str, config);
        }
        if (str.matches(".*([0-9][A-Z]|[A-Z][0-9]).*")) {
            str = str.replaceAll("([0-9])(Z|[A-Y]{2})", "$1 $2");
            str = str.replaceAll("([A-Z]{3})([0-9])", "$1 $2");
        }
        if ("AM".equals(tzString = DateTime.tzParse(str)) || "PM".equals(tzString)) {
            tzString = null;
        }
        if ("BC".equals(tzString) || "BCE".equals(tzString)) {
            tzString = null;
            dateState.isBC = true;
        }
        if (tzString != null && tzString.endsWith("0")) {
            if (tzString.matches("[+-][0-9]{2}:[0-9]{2}")) {
                tzString = "GMT" + tzString;
                str = str.substring(0, str.length() - 6);
            } else if (tzString.matches("[+-][0-9]{4}")) {
                tzString = "GMT" + tzString.substring(0, 3) + ":" + tzString.substring(3);
                str = str.substring(0, str.length() - 5);
            }
        }
        TimeZone tz = tzString == null ? config.getInputTimeZone() : config.lookupTimeZone(tzString);
        Tm tm = new Tm(config.systemTime(), tz);
        dateState.parts = partsPattern.split(str);
        dateState.thisYear = tm.getYear();
        dateState.centuryTurn = dateState.thisYear - dateState.thisYear % 100;
        dateState.integers = new boolean[dateState.parts.length];
        dateState.usedint = new boolean[dateState.parts.length];
        for (int i = 0; i < dateState.parts.length; ++i) {
            if (!DateTime.startsWithDigit(dateState.parts[i])) continue;
            dateState.integers[i] = true;
        }
        DateTime.scanForTextualMonth(config, hasDatepart, dateState);
        DateTime.scanForYYYYOrYYYYMMDD(config, hasDatepart, dateState);
        if (hasDatepart.year && dateState.year == 0) {
            throw new IllegalArgumentException("Invalid zero year parsed.");
        }
        if (!hasDatepart.year && str.endsWith("T " + dateState.parts[dateState.parts.length - 1])) {
            dateState.year = Integer.parseInt(dateState.parts[dateState.parts.length - 1]);
            hasDatepart.year = true;
            dateState.usedint[dateState.usedint.length - 1] = true;
        }
        if (!hasDatepart.year && (masked = str.replaceAll("[0-9]+:[0-9:]+|[a-zA-Z]+", "")).matches("^\\s*[0-9]+\\s*$")) {
            dateState.year = dateState.thisYear;
            hasDatepart.year = true;
        }
        DateTime.assignIntegersToRemainingSlots(config, hasDatepart, dateState);
        DateTime.adjustHourBasedOnAMPM(dateState);
        DateTime.validateParsedDate(str, hasDatepart, dateState);
        if (dateState.isBC && dateState.year >= 0) {
            dateState.year = -dateState.year + 1;
        }
        DateTime returnDt = new DateTime(Tm.calcTime(dateState.year, 1 + dateState.month, dateState.day, dateState.hour, dateState.minute, dateState.second, dateState.nanosecond / 1000000, tz), config);
        if (dateState.isTwoDigitYear && config.isUnspecifiedCenturyAlwaysInPast() && returnDt.getSeconds() * 1000L > config.systemTime()) {
            returnDt = returnDt.shift(CalendarUnit.CENTURY, -1);
        }
        returnDt.systemDur.nanos = dateState.nanosecond;
        return returnDt;
    }

    public DateTime truncate(CalendarUnit unit) {
        if (unit.compareTo(CalendarUnit.HOUR) < 0) {
            if (unit == CalendarUnit.MINUTE) {
                long trim = this.systemDur.millis % 60000L;
                if (trim < 0L) {
                    trim += 60000L;
                }
                return new DateTime(this.systemDur.millis - trim, this.config());
            }
            if (unit == CalendarUnit.SECOND) {
                long trim = this.systemDur.millis % 1000L;
                if (trim < 0L) {
                    trim += 1000L;
                }
                return new DateTime(this.systemDur.millis - trim, this.config.getOutputTimeZone());
            }
            if (unit == CalendarUnit.MILLISECOND) {
                return new DateTime(this.systemDur.millis, this.config.getOutputTimeZone());
            }
            if (unit == CalendarUnit.MICROSECOND) {
                int nanotrim = this.systemDur.nanos % 1000000;
                if (nanotrim < 0) {
                    nanotrim += 1000000;
                }
                return new DateTime(this.getSeconds(), this.systemDur.nanos - nanotrim, this.config);
            }
            return new DateTime(this.systemDur.millis, this.config);
        }
        long calcTime = this.systemDur.millis + (long)this.config().getOutputTimeZone().getOffset(this.systemDur.millis);
        if (unit == CalendarUnit.HOUR) {
            long trim = calcTime % 3600000L;
            if (trim < 0L) {
                trim += 3600000L;
            }
            calcTime -= trim;
            calcTime -= (long)this.config().getOutputTimeZone().getOffset(calcTime);
            return new DateTime(calcTime, this.config());
        }
        if (unit == CalendarUnit.DAY) {
            long trim = calcTime % 86400000L;
            if (trim < 0L) {
                trim += 86400000L;
            }
            calcTime -= trim;
            calcTime -= (long)this.config().getOutputTimeZone().getOffset(calcTime);
            return new DateTime(calcTime, this.config());
        }
        if (unit == CalendarUnit.WEEK) {
            long dow = (calcTime / 86400000L + (long)this.config().getEpochDOW()) % 7L;
            calcTime -= calcTime % 86400000L + 86400000L * dow;
            calcTime -= (long)this.config().getOutputTimeZone().getOffset(calcTime);
            return new DateTime(calcTime, this.config());
        }
        Tm tm = new Tm(this.systemDur.millis, this.config().getOutputTimeZone());
        if (unit == CalendarUnit.MONTH) {
            return new DateTime(Tm.calcTime(tm.getYear(), tm.getMonth(), 1, 0, 0, 0, 0, this.config.getOutputTimeZone()), this.config);
        }
        if (unit == CalendarUnit.QUARTER) {
            int monthOffset = (tm.getMonth() - 1) % 3;
            return new DateTime(Tm.calcTime(tm.getYear(), tm.getMonth() - monthOffset, 1, 0, 0, 0, 0, this.config.getOutputTimeZone()), this.config);
        }
        if (unit == CalendarUnit.YEAR) {
            return new DateTime(Tm.calcTime(tm.getYear(), 1, 1, 0, 0, 0, 0, this.config.getOutputTimeZone()), this.config);
        }
        if (unit == CalendarUnit.CENTURY) {
            return new DateTime(Tm.calcTime(tm.getYear() - tm.getYear() % 100, 1, 1, 0, 0, 0, 0, this.config.getOutputTimeZone()), this.config);
        }
        throw new IllegalArgumentException("That precision is still unsupported.  Sorry, my bad.");
    }

    public long getSeconds() {
        return this.systemDur.getSeconds();
    }

    public long toMillis() {
        return this.systemDur.toMillis();
    }

    public int getNanos() {
        int nanos = this.systemDur.getNanos();
        return nanos >= 0 ? nanos : 1000000000 + nanos;
    }

    public boolean equals(Object dateTime) {
        if (dateTime == null) {
            return false;
        }
        if (dateTime.getClass() == this.getClass()) {
            DateTime dt = (DateTime)dateTime;
            return this.systemDur.toMillis() == dt.toMillis() && this.systemDur.getNanos() == dt.getNanos();
        }
        return false;
    }

    public int hashCode() {
        return this.systemDur.hashCode();
    }

    public IDateTimeConfig config() {
        if (this.config == null) {
            this.config = DateTimeConfig.getGlobalDefault();
        }
        return this.config;
    }

    private static int parseIntFragment(String str) {
        if (str == null) {
            return 0;
        }
        int parsed = 0;
        boolean isNeg = false;
        char[] strip = str.toCharArray();
        char c = strip[0];
        if (c == '-') {
            isNeg = true;
        } else if (c >= '0' && c <= '9') {
            parsed = c - 48;
        } else {
            return 0;
        }
        for (int i = 1; i < strip.length && (c = strip[i]) >= '0' && c <= '9'; ++i) {
            parsed = 10 * parsed + c - 48;
        }
        return isNeg ? -parsed : parsed;
    }

    private static boolean startsWithDigit(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        return c >= '0' && c <= '9';
    }

    private static boolean onlyDigits(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isInteger(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        if (s.length() == 1) {
            return c >= '0' && c <= '9';
        }
        return (c == '-' || c >= '0' && c <= '9') && DateTime.onlyDigits(s.substring(1));
    }

    private static class DateState {
        boolean isYearFirst;
        boolean isTwoDigitYear;
        boolean isBC;
        int centuryTurn;
        int thisYear;
        int year;
        int month;
        int day = 1;
        int hour;
        int minute;
        int second;
        int nanosecond;
        String[] parts;
        boolean[] integers;
        boolean[] usedint;

        private DateState() {
        }
    }

    private static class HasDatepart {
        boolean year;
        boolean month;
        boolean day;
        boolean hour;
        boolean minute;
        boolean second;
        boolean nanosecond;

        private HasDatepart() {
        }
    }
}

