/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.datetime;

import java.text.DateFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.pojava.datetime.CalendarUnit;
import org.pojava.datetime.DateTime;
import org.pojava.datetime.Tm;

public class DateTimeFormat {
    private static final int[] dom = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static Map<Locale, DateFormatSymbols> symbols = new HashMap<Locale, DateFormatSymbols>();
    private final String template;

    public DateTimeFormat(String template) {
        this.template = template;
    }

    public String format(DateTime dt) {
        return DateTimeFormat.format(this.template, dt);
    }

    public String format(long millis) {
        return DateTimeFormat.format(this.template, new DateTime(millis));
    }

    public static String format(String template, long millis) {
        return DateTimeFormat.format(template, new DateTime(millis));
    }

    public static String format(String template, DateTime dt) {
        return DateTimeFormat.format(template, dt, dt.config().getOutputTimeZone());
    }

    public static String format(String template, DateTime dt, TimeZone tz) {
        return DateTimeFormat.format(template, dt, tz, dt.config().getLocale());
    }

    public static String format(String template, DateTime dt, TimeZone tz, Locale locale) {
        Tm tm = new Tm(dt, tz);
        StringBuilder sb = new StringBuilder();
        StringBuilder word = new StringBuilder();
        char[] fmt = template.toCharArray();
        char prior = fmt[0];
        if (prior != '\'') {
            word.append(prior);
        }
        if (!symbols.containsKey(locale)) {
            symbols.put(locale, new DateFormatSymbols(locale));
        }
        DateFormatSymbols dfs = symbols.get(locale);
        String bcPrefix = template.indexOf(103) < 0 && template.indexOf(71) < 0 ? dt.config().getBcPrefix() : "";
        boolean isLiteral = prior == '\'';
        for (int i = 1; i < fmt.length; ++i) {
            if (fmt[i] == '\'') {
                if (prior == '\'') {
                    sb.append('\'');
                } else {
                    DateTimeFormat.appendWord(sb, word, tm, dt, tz, locale, dfs, bcPrefix);
                }
                word.setLength(0);
                prior = prior == '\'' ? (char)' ' : '\'';
                isLiteral = !isLiteral;
                continue;
            }
            if (isLiteral) {
                sb.append(fmt[i]);
                prior = fmt[i];
                continue;
            }
            if (fmt[i] == prior) {
                word.append(prior);
                continue;
            }
            DateTimeFormat.appendWord(sb, word, tm, dt, tz, locale, dfs, bcPrefix);
            prior = fmt[i];
            word.setLength(0);
            word.append(prior);
        }
        DateTimeFormat.appendWord(sb, word, tm, dt, tz, locale, dfs, bcPrefix);
        return sb.toString();
    }

    private static void appendWord(StringBuilder sb, StringBuilder word, Tm tm, DateTime dt, TimeZone tz, Locale locale, DateFormatSymbols dfs, String appendBC) {
        if (word.length() == 0) {
            return;
        }
        char c = word.charAt(0);
        int len = word.length();
        switch (c) {
            case 'g': {
                sb.append(tm.getYear() < 0 ? "BCE" : "CE");
                break;
            }
            case 'G': {
                sb.append(tm.getYear() < 0 ? "BC" : "AD");
                break;
            }
            case 'y': {
                if (tm.getYear() < 0) {
                    sb.append(appendBC);
                }
                if (len < 3) {
                    sb.append(DateTimeFormat.zfill(tm.getYear() % 100, 2));
                    break;
                }
                if (len == 3) {
                    sb.append(DateTimeFormat.zfill(tm.getYear() % 1000, 3));
                    break;
                }
                sb.append(DateTimeFormat.zfill(tm.getYear(), len));
                break;
            }
            case 'M': {
                if (len > 3) {
                    sb.append(dfs.getMonths()[tm.getMonth() - 1]);
                    break;
                }
                if (len == 3) {
                    sb.append(dfs.getShortMonths()[tm.getMonth() - 1]);
                    break;
                }
                if (len == 2) {
                    sb.append(DateTimeFormat.zfill(tm.getMonth(), 2));
                    break;
                }
                sb.append(tm.getMonth());
                break;
            }
            case 'D': {
                if (len > 1) {
                    sb.append(DateTimeFormat.zfill(dom[tm.getMonth() - 1] + tm.getDay() + DateTimeFormat.leapDays(tm), len));
                    break;
                }
                sb.append(dom[tm.getMonth() - 1] + tm.getDay() + DateTimeFormat.leapDays(tm));
                break;
            }
            case 'd': {
                if (len > 1) {
                    sb.append(DateTimeFormat.zfill(tm.getDay(), len));
                    break;
                }
                sb.append(tm.getDay());
                break;
            }
            case 'E': {
                if (len > 3) {
                    sb.append(dfs.getWeekdays()[tm.getWeekday()]);
                    break;
                }
                sb.append(dfs.getShortWeekdays()[tm.getWeekday()]);
                break;
            }
            case 'a': {
                sb.append(dfs.getAmPmStrings()[tm.getHour() > 11 ? 1 : 0]);
                break;
            }
            case 'H': {
                if (len > 1) {
                    sb.append(DateTimeFormat.zfill(tm.getHour(), len));
                    break;
                }
                sb.append(tm.getHour());
                break;
            }
            case 'k': {
                int hr_k = tm.getHour() == 0 ? 24 : tm.getHour();
                sb.append(len > 1 ? DateTimeFormat.zfill(hr_k, len) : Integer.valueOf(hr_k));
                break;
            }
            case 'K': {
                int hr_K = tm.getHour() % 12;
                sb.append(len > 1 ? DateTimeFormat.zfill(hr_K, len) : Integer.valueOf(hr_K));
                break;
            }
            case 'h': {
                int hr_h = tm.getHour() % 12;
                if (hr_h == 0) {
                    hr_h = 12;
                }
                sb.append(len > 1 ? DateTimeFormat.zfill(hr_h, len) : Integer.valueOf(hr_h));
                break;
            }
            case 'm': {
                sb.append(len > 1 ? DateTimeFormat.zfill(tm.getMinute(), len) : Integer.valueOf(tm.getMinute()));
                break;
            }
            case 's': {
                sb.append(len > 1 ? DateTimeFormat.zfill(tm.getSecond(), len) : Integer.valueOf(tm.getSecond()));
                break;
            }
            case 'S': {
                sb.append(DateTimeFormat.zfill(tm.getNanosecond(), 9).substring(0, len));
                break;
            }
            case 'z': {
                if (len > 3) {
                    sb.append(dt.timeZone().getDisplayName(locale));
                    break;
                }
                sb.append(tz.getDisplayName(tz.inDaylightTime(dt.toDate()), 0, locale));
                break;
            }
            case 'Z': {
                int minutes = tz.getOffset(dt.toMillis()) / 60000;
                if (minutes < 0) {
                    sb.append('-');
                    minutes = -minutes;
                } else {
                    sb.append('+');
                }
                int hours = minutes / 60;
                minutes -= hours * 60;
                if (hours < 10) {
                    sb.append('0');
                }
                sb.append(hours);
                if (len > 1) {
                    sb.append(':');
                }
                if (minutes < 10) {
                    sb.append('0');
                }
                sb.append(minutes);
                break;
            }
            case 'F': {
                sb.append(DateTimeFormat.zfill(1 + (tm.getDay() - 1) / 7, len));
                break;
            }
            case 'w': {
                Tm thu_w = new Tm(dt.add(CalendarUnit.DAY, tm.getWeekday() == 1 ? -3 : 5 - tm.getWeekday()));
                int dayInYear = dom[thu_w.getMonth() - 1] + thu_w.getDay() + DateTimeFormat.leapDays(thu_w);
                sb.append(DateTimeFormat.zfill(1 + (dayInYear - 1) / 7, len));
                break;
            }
            case 'W': {
                Tm thu_W = new Tm(dt.add(CalendarUnit.DAY, tm.getWeekday() == 1 ? -3 : 5 - tm.getWeekday()));
                sb.append(DateTimeFormat.zfill(1 + (thu_W.getDay() - 1) / 7, len));
                break;
            }
            default: {
                sb.append((CharSequence)word);
            }
        }
    }

    private static String zfill(int value, int size) {
        if (value < 0) {
            value *= -1;
        }
        String str = Integer.toString(value);
        StringBuilder zeros = new StringBuilder("000000000000");
        if (str.length() > size) {
            return str;
        }
        while (zeros.length() + str.length() < size) {
            zeros.append(zeros.toString());
        }
        zeros.append(str);
        return zeros.substring(zeros.length() - Math.min(zeros.length(), size));
    }

    private static int leapDays(Tm tm) {
        if (tm.getMonth() < 3) {
            return 0;
        }
        int year = tm.getYear();
        return year % 4 == 0 && (year % 400 == 0 || year % 100 != 0) ? 1 : 0;
    }
}

