/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.datetime;

import java.text.DateFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MonthMap {
    private Map<String, Integer> monthMap = new HashMap<String, Integer>();

    public static MonthMap fromAllLocales() {
        Locale[] locales;
        MonthMap newMonthMap = new MonthMap();
        for (Locale locale : locales = DateFormatSymbols.getAvailableLocales()) {
            DateFormatSymbols dfs = DateFormatSymbols.getInstance(locale);
            String[] longMonths = dfs.getMonths();
            String[] shortMonths = dfs.getShortMonths();
            for (int i = 0; i < 12; ++i) {
                String shortMonth = shortMonths[i].toUpperCase();
                String shortMonth4 = shortMonths[i].toUpperCase().substring(0, Math.min(4, shortMonths[i].length()));
                String longMonth = longMonths[i].toUpperCase();
                if (longMonth.startsWith(shortMonth4) || shortMonth4.endsWith(".")) {
                    newMonthMap.addMonth(shortMonth4, i);
                    if (shortMonth4.length() != 4 || locale.toString().startsWith("fi")) continue;
                    newMonthMap.addMonth(shortMonth.substring(0, 3), i);
                    continue;
                }
                newMonthMap.addMonth(shortMonth, i);
                newMonthMap.addMonth(longMonth, i);
            }
        }
        return newMonthMap;
    }

    public Integer monthIndex(String candidateMonth) {
        if (candidateMonth == null) {
            return null;
        }
        Integer monthIndex = this.monthMap.get(candidateMonth = candidateMonth.toUpperCase());
        if (monthIndex == null && candidateMonth.length() > 4) {
            monthIndex = this.monthMap.get(candidateMonth.substring(0, 4));
        }
        if (monthIndex == null && candidateMonth.length() > 3) {
            monthIndex = this.monthMap.get(candidateMonth.substring(0, 3));
        }
        return monthIndex;
    }

    public void addMonth(String abbrev, Integer monthNumber) {
        if (!this.monthMap.containsKey(abbrev = abbrev.toUpperCase())) {
            this.monthMap.put(abbrev, monthNumber);
        }
    }

    public boolean isEmpty() {
        return this.monthMap == null || this.monthMap.isEmpty();
    }
}

