/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedFrustum;
import javax.media.j3d.J3dHash;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class BoundingSphere
extends Bounds {
    final Point3d center;
    double radius;

    public BoundingSphere(Point3d center, double radius) {
        this.boundId = 2;
        this.center = new Point3d(center);
        this.radius = radius;
        this.updateBoundsStates();
    }

    public BoundingSphere() {
        this.boundId = 2;
        this.center = new Point3d();
        this.radius = 1.0;
    }

    public BoundingSphere(Bounds boundsObject) {
        this.boundId = 2;
        this.center = new Point3d();
        if (boundsObject == null || boundsObject.boundsIsEmpty) {
            this.setEmptyBounds();
            return;
        }
        if (boundsObject.boundsIsInfinite) {
            this.setInfiniteBounds();
            return;
        }
        if (boundsObject.boundId == 1) {
            BoundingBox box = (BoundingBox)boundsObject;
            this.center.x = (box.upper.x + box.lower.x) / 2.0;
            this.center.y = (box.upper.y + box.lower.y) / 2.0;
            this.center.z = (box.upper.z + box.lower.z) / 2.0;
            this.radius = 0.5 * Math.sqrt((box.upper.x - box.lower.x) * (box.upper.x - box.lower.x) + (box.upper.y - box.lower.y) * (box.upper.y - box.lower.y) + (box.upper.z - box.lower.z) * (box.upper.z - box.lower.z));
        } else if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            this.center.set((Tuple3d)sphere.center);
            this.radius = sphere.radius;
        } else if (boundsObject.boundId == 4) {
            BoundingPolytope polytope = (BoundingPolytope)boundsObject;
            this.center.x = polytope.centroid.x;
            this.center.y = polytope.centroid.y;
            this.center.z = polytope.centroid.z;
            this.radius = Math.sqrt((polytope.verts[0].x - this.center.x) * (polytope.verts[0].x - this.center.x) + (polytope.verts[0].y - this.center.y) * (polytope.verts[0].y - this.center.y) + (polytope.verts[0].z - this.center.z) * (polytope.verts[0].z - this.center.z));
            for (int i = 1; i < polytope.nVerts; ++i) {
                double dis_sq = (polytope.verts[i].x - this.center.x) * (polytope.verts[i].x - this.center.x) + (polytope.verts[i].y - this.center.y) * (polytope.verts[i].y - this.center.y) + (polytope.verts[i].z - this.center.z) * (polytope.verts[i].z - this.center.z);
                double rad_sq = this.radius * this.radius;
                if (!(dis_sq > rad_sq)) continue;
                double dis = Math.sqrt(dis_sq);
                this.radius = (this.radius + dis) * 0.5;
                double oldc_to_new_c = dis - this.radius;
                double t = oldc_to_new_c / dis;
                this.center.x += (polytope.verts[i].x - this.center.x) * t;
                this.center.y += (polytope.verts[i].y - this.center.y) * t;
                this.center.z += (polytope.verts[i].z - this.center.z) * t;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere0"));
        }
        this.updateBoundsStates();
    }

    public BoundingSphere(Bounds[] boundsObjects) {
        int i;
        this.boundId = 2;
        this.center = new Point3d();
        if (boundsObjects == null || boundsObjects.length <= 0) {
            this.setEmptyBounds();
            return;
        }
        for (i = 0; boundsObjects[i] == null && i < boundsObjects.length; ++i) {
        }
        if (i >= boundsObjects.length) {
            this.setEmptyBounds();
            return;
        }
        this.set(boundsObjects[i++]);
        if (this.boundsIsInfinite) {
            return;
        }
        Point3d[] boxVerts = null;
        while (i < boundsObjects.length) {
            if (boundsObjects[i] != null && !boundsObjects[i].boundsIsEmpty) {
                if (boundsObjects[i].boundsIsInfinite) {
                    this.setInfiniteBounds();
                    return;
                }
                if (boundsObjects[i].boundId == 1) {
                    BoundingBox b = (BoundingBox)boundsObjects[i];
                    if (boxVerts == null) {
                        boxVerts = new Point3d[8];
                        for (int j = 0; j < 8; ++j) {
                            boxVerts[j] = new Point3d();
                        }
                    }
                    boxVerts[0].set(b.lower.x, b.lower.y, b.lower.z);
                    boxVerts[1].set(b.lower.x, b.upper.y, b.lower.z);
                    boxVerts[2].set(b.upper.x, b.lower.y, b.lower.z);
                    boxVerts[3].set(b.upper.x, b.upper.y, b.lower.z);
                    boxVerts[4].set(b.lower.x, b.lower.y, b.upper.z);
                    boxVerts[5].set(b.lower.x, b.upper.y, b.upper.z);
                    boxVerts[6].set(b.upper.x, b.lower.y, b.upper.z);
                    boxVerts[7].set(b.upper.x, b.upper.y, b.upper.z);
                    this.combine(boxVerts);
                } else if (boundsObjects[i].boundId == 2) {
                    double t;
                    double d1;
                    BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
                    double dis = Math.sqrt((this.center.x - sphere.center.x) * (this.center.x - sphere.center.x) + (this.center.y - sphere.center.y) * (this.center.y - sphere.center.y) + (this.center.z - sphere.center.z) * (this.center.z - sphere.center.z));
                    if (this.radius > sphere.radius) {
                        if (dis + sphere.radius > this.radius) {
                            d1 = 0.5 * (this.radius - sphere.radius + dis);
                            t = d1 / dis;
                            this.radius = d1 + sphere.radius;
                            this.center.x = sphere.center.x + (this.center.x - sphere.center.x) * t;
                            this.center.y = sphere.center.y + (this.center.y - sphere.center.y) * t;
                            this.center.z = sphere.center.z + (this.center.z - sphere.center.z) * t;
                        }
                    } else if (dis + this.radius <= sphere.radius) {
                        this.center.x = sphere.center.x;
                        this.center.y = sphere.center.y;
                        this.center.z = sphere.center.z;
                        this.radius = sphere.radius;
                    } else {
                        d1 = 0.5 * (sphere.radius - this.radius + dis);
                        t = d1 / dis;
                        this.radius = d1 + this.radius;
                        this.center.x += (sphere.center.x - this.center.x) * t;
                        this.center.y += (sphere.center.y - this.center.y) * t;
                        this.center.z += (sphere.center.z - this.center.z) * t;
                    }
                } else if (boundsObjects[i].boundId == 4) {
                    BoundingPolytope polytope = (BoundingPolytope)boundsObjects[i];
                    this.combine(polytope.verts);
                } else if (boundsObjects[i] != null) {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere0"));
                }
            }
            ++i;
        }
        this.updateBoundsStates();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double r) {
        this.radius = r;
        this.updateBoundsStates();
    }

    @Override
    public void getCenter(Point3d center) {
        center.set((Tuple3d)this.center);
    }

    public void setCenter(Point3d center) {
        this.center.set((Tuple3d)center);
        this.updateBoundsStates();
    }

    @Override
    public void set(Bounds boundsObject) {
        if (boundsObject == null || boundsObject.boundsIsEmpty) {
            this.setEmptyBounds();
            return;
        }
        if (boundsObject.boundsIsInfinite) {
            this.setInfiniteBounds();
            return;
        }
        if (boundsObject.boundId == 1) {
            BoundingBox box = (BoundingBox)boundsObject;
            this.center.x = (box.upper.x + box.lower.x) / 2.0;
            this.center.y = (box.upper.y + box.lower.y) / 2.0;
            this.center.z = (box.upper.z + box.lower.z) / 2.0;
            this.radius = 0.5 * Math.sqrt((box.upper.x - box.lower.x) * (box.upper.x - box.lower.x) + (box.upper.y - box.lower.y) * (box.upper.y - box.lower.y) + (box.upper.z - box.lower.z) * (box.upper.z - box.lower.z));
        } else if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            this.radius = sphere.radius;
            this.center.x = sphere.center.x;
            this.center.y = sphere.center.y;
            this.center.z = sphere.center.z;
        } else if (boundsObject.boundId == 4) {
            BoundingPolytope polytope = (BoundingPolytope)boundsObject;
            this.center.x = polytope.centroid.x;
            this.center.y = polytope.centroid.y;
            this.center.z = polytope.centroid.z;
            this.radius = Math.sqrt((polytope.verts[0].x - this.center.x) * (polytope.verts[0].x - this.center.x) + (polytope.verts[0].y - this.center.y) * (polytope.verts[0].y - this.center.y) + (polytope.verts[0].z - this.center.z) * (polytope.verts[0].z - this.center.z));
            for (int i = 1; i < polytope.nVerts; ++i) {
                double dis_sq = (polytope.verts[i].x - this.center.x) * (polytope.verts[i].x - this.center.x) + (polytope.verts[i].y - this.center.y) * (polytope.verts[i].y - this.center.y) + (polytope.verts[i].z - this.center.z) * (polytope.verts[i].z - this.center.z);
                double rad_sq = this.radius * this.radius;
                if (!(dis_sq > rad_sq)) continue;
                double dis = Math.sqrt(dis_sq);
                this.radius = (this.radius + dis) * 0.5;
                double oldc_to_new_c = dis - this.radius;
                double t = oldc_to_new_c / dis;
                this.center.x += (polytope.verts[i].x - this.center.x) * t;
                this.center.y += (polytope.verts[i].y - this.center.y) * t;
                this.center.z += (polytope.verts[i].z - this.center.z) * t;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere2"));
        }
        this.updateBoundsStates();
    }

    @Override
    public Object clone() {
        return new BoundingSphere(this.center, this.radius);
    }

    @Override
    public boolean equals(Object bounds) {
        try {
            BoundingSphere sphere = (BoundingSphere)bounds;
            return this.center.equals((Tuple3d)sphere.center) && this.radius == sphere.radius;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        long bits = 1L;
        bits = J3dHash.mixDoubleBits(bits, this.radius);
        bits = J3dHash.mixDoubleBits(bits, this.center.x);
        bits = J3dHash.mixDoubleBits(bits, this.center.y);
        bits = J3dHash.mixDoubleBits(bits, this.center.z);
        return J3dHash.finish(bits);
    }

    @Override
    public void combine(Bounds boundsObject) {
        if (boundsObject == null || boundsObject.boundsIsEmpty || this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty || boundsObject.boundsIsInfinite) {
            this.set(boundsObject);
            return;
        }
        if (boundsObject.boundId == 1) {
            double z;
            BoundingBox b = (BoundingBox)boundsObject;
            double u = b.upper.x - this.center.x;
            double l = b.lower.x - this.center.x;
            double x = u * u > l * l ? b.upper.x : b.lower.x;
            u = b.upper.y - this.center.y;
            l = b.lower.y - this.center.y;
            double y = u * u > l * l ? b.upper.y : b.lower.y;
            double dis = Math.sqrt((x - this.center.x) * (x - this.center.x) + (y - this.center.y) * (y - this.center.y) + ((z = (u = b.upper.z - this.center.z) * u > (l = b.lower.z - this.center.z) * l ? b.upper.z : b.lower.z) - this.center.z) * (z - this.center.z));
            if (dis > this.radius) {
                this.radius = (dis + this.radius) * 0.5;
                double oldc_to_new_c = dis - this.radius;
                this.center.x = (this.radius * this.center.x + oldc_to_new_c * x) / dis;
                this.center.y = (this.radius * this.center.y + oldc_to_new_c * y) / dis;
                this.center.z = (this.radius * this.center.z + oldc_to_new_c * z) / dis;
                this.combinePoint(b.upper.x, b.upper.y, b.upper.z);
                this.combinePoint(b.upper.x, b.upper.y, b.lower.z);
                this.combinePoint(b.upper.x, b.lower.y, b.upper.z);
                this.combinePoint(b.upper.x, b.lower.y, b.lower.z);
                this.combinePoint(b.lower.x, b.upper.y, b.upper.z);
                this.combinePoint(b.lower.x, b.upper.y, b.lower.z);
                this.combinePoint(b.lower.x, b.lower.y, b.upper.z);
                this.combinePoint(b.lower.x, b.lower.y, b.lower.z);
            }
        } else if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            double dis = Math.sqrt((this.center.x - sphere.center.x) * (this.center.x - sphere.center.x) + (this.center.y - sphere.center.y) * (this.center.y - sphere.center.y) + (this.center.z - sphere.center.z) * (this.center.z - sphere.center.z));
            if (this.radius > sphere.radius) {
                if (dis + sphere.radius > this.radius) {
                    double d1 = 0.5 * (this.radius - sphere.radius + dis);
                    double t = d1 / dis;
                    this.radius = d1 + sphere.radius;
                    this.center.x = sphere.center.x + (this.center.x - sphere.center.x) * t;
                    this.center.y = sphere.center.y + (this.center.y - sphere.center.y) * t;
                    this.center.z = sphere.center.z + (this.center.z - sphere.center.z) * t;
                }
            } else if (dis + this.radius <= sphere.radius) {
                this.center.x = sphere.center.x;
                this.center.y = sphere.center.y;
                this.center.z = sphere.center.z;
                this.radius = sphere.radius;
            } else {
                double d1 = 0.5 * (sphere.radius - this.radius + dis);
                double t = d1 / dis;
                this.radius = d1 + this.radius;
                this.center.x += (sphere.center.x - this.center.x) * t;
                this.center.y += (sphere.center.y - this.center.y) * t;
                this.center.z += (sphere.center.z - this.center.z) * t;
            }
        } else if (boundsObject.boundId == 4) {
            BoundingPolytope polytope = (BoundingPolytope)boundsObject;
            this.combine(polytope.verts);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere3"));
        }
        this.updateBoundsStates();
    }

    private void combinePoint(double x, double y, double z) {
        double dis = Math.sqrt((x - this.center.x) * (x - this.center.x) + (y - this.center.y) * (y - this.center.y) + (z - this.center.z) * (z - this.center.z));
        if (dis > this.radius) {
            this.radius = (dis + this.radius) * 0.5;
            double oldc_to_new_c = dis - this.radius;
            this.center.x = (this.radius * this.center.x + oldc_to_new_c * x) / dis;
            this.center.y = (this.radius * this.center.y + oldc_to_new_c * y) / dis;
            this.center.z = (this.radius * this.center.z + oldc_to_new_c * z) / dis;
        }
    }

    @Override
    public void combine(Bounds[] boundsObjects) {
        int i;
        if (boundsObjects == null || boundsObjects.length <= 0 || this.boundsIsInfinite) {
            return;
        }
        for (i = 0; i < boundsObjects.length && (boundsObjects[i] == null || boundsObjects[i].boundsIsEmpty); ++i) {
        }
        if (i >= boundsObjects.length) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(boundsObjects[i++]);
        }
        if (this.boundsIsInfinite) {
            return;
        }
        while (i < boundsObjects.length) {
            if (boundsObjects[i] != null && !boundsObjects[i].boundsIsEmpty) {
                double dis;
                if (boundsObjects[i].boundsIsInfinite) {
                    this.setInfiniteBounds();
                    return;
                }
                if (boundsObjects[i].boundId == 1) {
                    double z;
                    BoundingBox b = (BoundingBox)boundsObjects[i];
                    double u = b.upper.x - this.center.x;
                    double l = b.lower.x - this.center.x;
                    double x = u * u > l * l ? b.upper.x : b.lower.x;
                    u = b.upper.y - this.center.y;
                    l = b.lower.y - this.center.y;
                    double y = u * u > l * l ? b.upper.y : b.lower.y;
                    dis = Math.sqrt((x - this.center.x) * (x - this.center.x) + (y - this.center.y) * (y - this.center.y) + ((z = (u = b.upper.z - this.center.z) * u > (l = b.lower.z - this.center.z) * l ? b.upper.z : b.lower.z) - this.center.z) * (z - this.center.z));
                    if (dis > this.radius) {
                        this.radius = (dis + this.radius) * 0.5;
                        double oldc_to_new_c = dis - this.radius;
                        this.center.x = (this.radius * this.center.x + oldc_to_new_c * x) / dis;
                        this.center.y = (this.radius * this.center.y + oldc_to_new_c * y) / dis;
                        this.center.z = (this.radius * this.center.z + oldc_to_new_c * z) / dis;
                        this.combinePoint(b.upper.x, b.upper.y, b.upper.z);
                        this.combinePoint(b.upper.x, b.upper.y, b.lower.z);
                        this.combinePoint(b.upper.x, b.lower.y, b.upper.z);
                        this.combinePoint(b.upper.x, b.lower.y, b.lower.z);
                        this.combinePoint(b.lower.x, b.upper.y, b.upper.z);
                        this.combinePoint(b.lower.x, b.upper.y, b.lower.z);
                        this.combinePoint(b.lower.x, b.lower.y, b.upper.z);
                        this.combinePoint(b.lower.x, b.lower.y, b.lower.z);
                    }
                } else if (boundsObjects[i].boundId == 2) {
                    double t;
                    double d1;
                    BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
                    dis = Math.sqrt((this.center.x - sphere.center.x) * (this.center.x - sphere.center.x) + (this.center.y - sphere.center.y) * (this.center.y - sphere.center.y) + (this.center.z - sphere.center.z) * (this.center.z - sphere.center.z));
                    if (this.radius > sphere.radius) {
                        if (dis + sphere.radius > this.radius) {
                            d1 = 0.5 * (this.radius - sphere.radius + dis);
                            t = d1 / dis;
                            this.radius = d1 + sphere.radius;
                            this.center.x = sphere.center.x + (this.center.x - sphere.center.x) * t;
                            this.center.y = sphere.center.y + (this.center.y - sphere.center.y) * t;
                            this.center.z = sphere.center.z + (this.center.z - sphere.center.z) * t;
                        }
                    } else if (dis + this.radius <= sphere.radius) {
                        this.center.x = sphere.center.x;
                        this.center.y = sphere.center.y;
                        this.center.z = sphere.center.z;
                        this.radius = sphere.radius;
                    } else {
                        d1 = 0.5 * (sphere.radius - this.radius + dis);
                        t = d1 / dis;
                        this.radius = d1 + this.radius;
                        this.center.x += (sphere.center.x - this.center.x) * t;
                        this.center.y += (sphere.center.y - this.center.y) * t;
                        this.center.z += (sphere.center.z - this.center.z) * t;
                    }
                } else if (boundsObjects[i].boundId == 4) {
                    BoundingPolytope polytope = (BoundingPolytope)boundsObjects[i];
                    this.combine(polytope.verts);
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere4"));
                }
            }
            ++i;
        }
        this.updateBoundsStates();
    }

    @Override
    public void combine(Point3d point) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.radius = 0.0;
            this.center.x = point.x;
            this.center.y = point.y;
            this.center.z = point.z;
        } else {
            double dis = Math.sqrt((point.x - this.center.x) * (point.x - this.center.x) + (point.y - this.center.y) * (point.y - this.center.y) + (point.z - this.center.z) * (point.z - this.center.z));
            if (dis > this.radius) {
                this.radius = (dis + this.radius) * 0.5;
                double oldc_to_new_c = dis - this.radius;
                this.center.x = (this.radius * this.center.x + oldc_to_new_c * point.x) / dis;
                this.center.y = (this.radius * this.center.y + oldc_to_new_c * point.y) / dis;
                this.center.z = (this.radius * this.center.z + oldc_to_new_c * point.z) / dis;
            }
        }
        this.updateBoundsStates();
    }

    @Override
    public void combine(Point3d[] points) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.center.x = points[0].x;
            this.center.y = points[0].y;
            this.center.z = points[0].z;
            this.radius = 0.0;
        }
        for (int i = 0; i < points.length; ++i) {
            double dis_sq = (points[i].x - this.center.x) * (points[i].x - this.center.x) + (points[i].y - this.center.y) * (points[i].y - this.center.y) + (points[i].z - this.center.z) * (points[i].z - this.center.z);
            double rad_sq = this.radius * this.radius;
            if (!(dis_sq > rad_sq)) continue;
            double dis = Math.sqrt(dis_sq);
            this.radius = (this.radius + dis) * 0.5;
            double oldc_to_new_c = dis - this.radius;
            this.center.x = (this.radius * this.center.x + oldc_to_new_c * points[i].x) / dis;
            this.center.y = (this.radius * this.center.y + oldc_to_new_c * points[i].y) / dis;
            this.center.z = (this.radius * this.center.z + oldc_to_new_c * points[i].z) / dis;
        }
        this.updateBoundsStates();
    }

    @Override
    public void transform(Bounds boundsObject, Transform3D matrix) {
        if (boundsObject == null || boundsObject.boundsIsEmpty) {
            this.setEmptyBounds();
            return;
        }
        if (boundsObject.boundsIsInfinite) {
            this.setInfiniteBounds();
            return;
        }
        if (boundsObject.boundId == 1) {
            BoundingBox tmpBox = new BoundingBox(boundsObject);
            tmpBox.transform(matrix);
            this.set(tmpBox);
        } else if (boundsObject.boundId == 2) {
            this.set(boundsObject);
            this.transform(matrix);
        } else if (boundsObject.boundId == 4) {
            BoundingPolytope tmpPolytope = new BoundingPolytope(boundsObject);
            tmpPolytope.transform(matrix);
            this.set(tmpPolytope);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere5"));
        }
    }

    @Override
    public void transform(Transform3D trans) {
        if (this.boundsIsInfinite) {
            return;
        }
        trans.transform(this.center);
        double scale = trans.getDistanceScale();
        this.radius *= scale;
        if (Double.isNaN(this.radius)) {
            this.setEmptyBounds();
            return;
        }
    }

    @Override
    boolean intersect(Point3d origin, Vector3d direction, Point4d position) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            position.x = origin.x;
            position.y = origin.y;
            position.z = origin.z;
            position.w = 0.0;
            return true;
        }
        Vector3d dir = new Vector3d();
        Point3d oc = new Point3d();
        oc.x = this.center.x - origin.x;
        oc.y = this.center.y - origin.y;
        oc.z = this.center.z - origin.z;
        double l2oc = oc.x * oc.x + oc.y * oc.y + oc.z * oc.z;
        double rad2 = this.radius * this.radius;
        if (l2oc < rad2) {
            return true;
        }
        double invMag = 1.0 / Math.sqrt(direction.x * direction.x + direction.y * direction.y + direction.z * direction.z);
        dir.x = direction.x * invMag;
        dir.y = direction.y * invMag;
        dir.z = direction.z * invMag;
        double tca = oc.x * dir.x + oc.y * dir.y + oc.z * dir.z;
        if (tca <= 0.0) {
            return false;
        }
        double t2hc = rad2 - l2oc + tca * tca;
        if (t2hc > 0.0) {
            double t = tca - Math.sqrt(t2hc);
            position.x = origin.x + dir.x * t;
            position.y = origin.y + dir.y * t;
            position.z = origin.z + dir.z * t;
            position.w = t;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d point, Point4d position) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            position.x = point.x;
            position.y = point.y;
            position.z = point.z;
            position.w = 0.0;
            return true;
        }
        double x = point.x - this.center.x;
        double y = point.y - this.center.y;
        double z = point.z - this.center.z;
        double dist = x * x + y * y + z * z;
        if (dist > this.radius * this.radius) {
            return false;
        }
        position.x = point.x;
        position.y = point.y;
        position.z = point.z;
        position.w = Math.sqrt(dist);
        return true;
    }

    @Override
    boolean intersect(Point3d start, Point3d end, Point4d position) {
        double t;
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            position.x = start.x;
            position.y = start.y;
            position.z = start.z;
            position.w = 0.0;
            return true;
        }
        Vector3d dir = new Vector3d();
        Point3d oc = new Point3d();
        Vector3d direction = new Vector3d();
        oc.x = this.center.x - start.x;
        oc.y = this.center.y - start.y;
        oc.z = this.center.z - start.z;
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        double invMag = 1.0 / Math.sqrt(direction.x * direction.x + direction.y * direction.y + direction.z * direction.z);
        dir.x = direction.x * invMag;
        dir.y = direction.y * invMag;
        dir.z = direction.z * invMag;
        double l2oc = oc.x * oc.x + oc.y * oc.y + oc.z * oc.z;
        double rad2 = this.radius * this.radius;
        if (l2oc < rad2) {
            return true;
        }
        double tca = oc.x * dir.x + oc.y * dir.y + oc.z * dir.z;
        if (tca <= 0.0) {
            return false;
        }
        double t2hc = rad2 - l2oc + tca * tca;
        if (t2hc > 0.0 && (t = tca - Math.sqrt(t2hc)) * t <= (end.x - start.x) * (end.x - start.x) + (end.y - start.y) * (end.y - start.y) + (end.z - start.z) * (end.z - start.z)) {
            position.x = start.x + dir.x * t;
            position.y = start.y + dir.x * t;
            position.z = start.z + dir.x * t;
            position.w = t;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersect(Point3d origin, Vector3d direction) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        Vector3d dir = new Vector3d();
        Point3d oc = new Point3d();
        oc.x = this.center.x - origin.x;
        oc.y = this.center.y - origin.y;
        oc.z = this.center.z - origin.z;
        double l2oc = oc.x * oc.x + oc.y * oc.y + oc.z * oc.z;
        double rad2 = this.radius * this.radius;
        if (l2oc < rad2) {
            return true;
        }
        double mag = Math.sqrt(direction.x * direction.x + direction.y * direction.y + direction.z * direction.z);
        dir.x = direction.x / mag;
        dir.y = direction.y / mag;
        dir.z = direction.z / mag;
        double tca = oc.x * dir.x + oc.y * dir.y + oc.z * dir.z;
        if (tca <= 0.0) {
            return false;
        }
        double t2hc = rad2 - l2oc + tca * tca;
        return t2hc > 0.0;
    }

    boolean intersect(Point3d origin, Vector3d direction, Point3d intersectPoint) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            intersectPoint.x = origin.x;
            intersectPoint.y = origin.y;
            intersectPoint.z = origin.z;
            return true;
        }
        Point3d dir = new Point3d();
        Point3d oc = new Point3d();
        oc.x = this.center.x - origin.x;
        oc.y = this.center.y - origin.y;
        oc.z = this.center.z - origin.z;
        double l2oc = oc.x * oc.x + oc.y * oc.y + oc.z * oc.z;
        double rad2 = this.radius * this.radius;
        if (l2oc < rad2) {
            return true;
        }
        double mag = Math.sqrt(direction.x * direction.x + direction.y * direction.y + direction.z * direction.z);
        dir.x = direction.x / mag;
        dir.y = direction.y / mag;
        dir.z = direction.z / mag;
        double tca = oc.x * dir.x + oc.y * dir.y + oc.z * dir.z;
        if (tca <= 0.0) {
            return false;
        }
        double t2hc = rad2 - l2oc + tca * tca;
        if (t2hc > 0.0) {
            double t = tca - Math.sqrt(t2hc);
            intersectPoint.x = origin.x + direction.x * t;
            intersectPoint.y = origin.y + direction.y * t;
            intersectPoint.z = origin.z + direction.z * t;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersect(Point3d point) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        double x = point.x - this.center.x;
        double y = point.y - this.center.y;
        double z = point.z - this.center.z;
        double dist = x * x + y * y + z * z;
        return !(dist > this.radius * this.radius);
    }

    @Override
    public boolean isEmpty() {
        return this.boundsIsEmpty;
    }

    @Override
    boolean intersect(Bounds boundsObject, Point4d position) {
        return this.intersect(boundsObject);
    }

    @Override
    public boolean intersect(Bounds boundsObject) {
        if (boundsObject == null) {
            return false;
        }
        if (this.boundsIsEmpty || boundsObject.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite || boundsObject.boundsIsInfinite) {
            return true;
        }
        if (boundsObject.boundId == 1) {
            BoundingBox box = (BoundingBox)boundsObject;
            double dis = 0.0;
            double rad_sq = this.radius * this.radius;
            if (this.center.x < box.lower.x) {
                dis = (this.center.x - box.lower.x) * (this.center.x - box.lower.x);
            } else if (this.center.x > box.upper.x) {
                dis = (this.center.x - box.upper.x) * (this.center.x - box.upper.x);
            }
            if (this.center.y < box.lower.y) {
                dis += (this.center.y - box.lower.y) * (this.center.y - box.lower.y);
            } else if (this.center.y > box.upper.y) {
                dis += (this.center.y - box.upper.y) * (this.center.y - box.upper.y);
            }
            if (this.center.z < box.lower.z) {
                dis += (this.center.z - box.lower.z) * (this.center.z - box.lower.z);
            } else if (this.center.z > box.upper.z) {
                dis += (this.center.z - box.upper.z) * (this.center.z - box.upper.z);
            }
            return dis <= rad_sq;
        }
        if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            double radsq = this.radius + sphere.radius;
            radsq *= radsq;
            double distsq = this.center.distanceSquared(sphere.center);
            return distsq <= radsq;
        }
        if (boundsObject.boundId == 4) {
            return this.intersect_ptope_sphere((BoundingPolytope)boundsObject, this);
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere6"));
    }

    @Override
    public boolean intersect(Bounds[] boundsObjects) {
        if (boundsObjects == null || boundsObjects.length <= 0) {
            return false;
        }
        if (this.boundsIsEmpty) {
            return false;
        }
        for (int i = 0; i < boundsObjects.length; ++i) {
            if (boundsObjects[i] == null || boundsObjects[i].boundsIsEmpty) continue;
            if (this.boundsIsInfinite || boundsObjects[i].boundsIsInfinite) {
                return true;
            }
            if (boundsObjects[i].boundId == 1) {
                if (!this.intersect(boundsObjects[i])) continue;
                return true;
            }
            if (boundsObjects[i].boundId == 2) {
                BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
                double radsq = this.radius + sphere.radius;
                radsq *= radsq;
                double distsq = this.center.distanceSquared(sphere.center);
                if (!(distsq <= radsq)) continue;
                return true;
            }
            if (boundsObjects[i].boundId == 4) {
                if (!this.intersect(boundsObjects[i])) continue;
                return true;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere7"));
        }
        return false;
    }

    public boolean intersect(Bounds boundsObject, BoundingSphere newBoundSphere) {
        if (boundsObject == null || this.boundsIsEmpty || boundsObject.boundsIsEmpty) {
            newBoundSphere.set(null);
            return false;
        }
        if (this.boundsIsInfinite && !boundsObject.boundsIsInfinite) {
            newBoundSphere.set(boundsObject);
            return true;
        }
        if (boundsObject.boundsIsInfinite) {
            newBoundSphere.set(this);
            return true;
        }
        if (boundsObject.boundId == 1) {
            BoundingBox tbox = new BoundingBox();
            BoundingBox box = (BoundingBox)boundsObject;
            if (this.intersect(box)) {
                BoundingBox sbox = new BoundingBox(this);
                sbox.intersect((Bounds)box, tbox);
                newBoundSphere.set(tbox);
                return true;
            }
            newBoundSphere.set(null);
            return false;
        }
        if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            double dis = Math.sqrt((this.center.x - sphere.center.x) * (this.center.x - sphere.center.x) + (this.center.y - sphere.center.y) * (this.center.y - sphere.center.y) + (this.center.z - sphere.center.z) * (this.center.z - sphere.center.z));
            if (dis > this.radius + sphere.radius) {
                newBoundSphere.set(null);
                return false;
            }
            if (dis + this.radius <= sphere.radius) {
                newBoundSphere.center.x = this.center.x;
                newBoundSphere.center.y = this.center.y;
                newBoundSphere.center.z = this.center.z;
                newBoundSphere.radius = this.radius;
            } else if (dis + sphere.radius <= this.radius) {
                newBoundSphere.center.x = sphere.center.x;
                newBoundSphere.center.y = sphere.center.y;
                newBoundSphere.center.z = sphere.center.z;
                newBoundSphere.radius = sphere.radius;
            } else {
                double d2 = (dis * dis + this.radius * this.radius - sphere.radius * sphere.radius) / (2.0 * dis);
                newBoundSphere.radius = Math.sqrt(this.radius * this.radius - d2 * d2);
                double t = d2 / dis;
                newBoundSphere.center.x = this.center.x + (sphere.center.x - this.center.x) * t;
                newBoundSphere.center.y = this.center.y + (sphere.center.y - this.center.y) * t;
                newBoundSphere.center.z = this.center.z + (sphere.center.z - this.center.z) * t;
            }
            newBoundSphere.updateBoundsStates();
            return true;
        }
        if (boundsObject.boundId == 4) {
            BoundingBox tbox = new BoundingBox();
            BoundingPolytope polytope = (BoundingPolytope)boundsObject;
            if (this.intersect(polytope)) {
                BoundingBox sbox = new BoundingBox(this);
                BoundingBox pbox = new BoundingBox(polytope);
                sbox.intersect((Bounds)pbox, tbox);
                newBoundSphere.set(tbox);
                return true;
            }
            newBoundSphere.set(null);
            return false;
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere8"));
    }

    public boolean intersect(Bounds[] boundsObjects, BoundingSphere newBoundSphere) {
        int i;
        if (boundsObjects == null || boundsObjects.length <= 0 || this.boundsIsEmpty) {
            newBoundSphere.set(null);
            return false;
        }
        for (i = 0; boundsObjects[i] == null && i < boundsObjects.length; ++i) {
        }
        if (i >= boundsObjects.length) {
            newBoundSphere.set(null);
            return false;
        }
        boolean status = false;
        Point3d newCenter = new Point3d();
        BoundingBox tbox = new BoundingBox();
        for (i = 0; i < boundsObjects.length; ++i) {
            BoundingBox sbox;
            if (boundsObjects[i] == null || boundsObjects[i].boundsIsEmpty) continue;
            if (boundsObjects[i].boundId == 1) {
                BoundingBox box = (BoundingBox)boundsObjects[i];
                if (!this.intersect(box)) continue;
                sbox = new BoundingBox(this);
                sbox.intersect((Bounds)box, tbox);
                if (status) {
                    newBoundSphere.combine(tbox);
                    continue;
                }
                newBoundSphere.set(tbox);
                status = true;
                continue;
            }
            if (boundsObjects[i].boundId == 2) {
                BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
                double dis = Math.sqrt((this.center.x - sphere.center.x) * (this.center.x - sphere.center.x) + (this.center.y - sphere.center.y) * (this.center.y - sphere.center.y) + (this.center.z - sphere.center.z) * (this.center.z - sphere.center.z));
                if (dis > this.radius + sphere.radius) continue;
                if (dis + this.radius <= sphere.radius) {
                    if (status) {
                        newBoundSphere.combine(this);
                        continue;
                    }
                    newBoundSphere.center.x = this.center.x;
                    newBoundSphere.center.y = this.center.y;
                    newBoundSphere.center.z = this.center.z;
                    newBoundSphere.radius = this.radius;
                    status = true;
                    newBoundSphere.updateBoundsStates();
                    continue;
                }
                if (dis + sphere.radius <= this.radius) {
                    if (status) {
                        newBoundSphere.combine(sphere);
                        continue;
                    }
                    newBoundSphere.center.x = this.center.x;
                    newBoundSphere.center.y = this.center.y;
                    newBoundSphere.center.z = this.center.z;
                    newBoundSphere.radius = sphere.radius;
                    status = true;
                    newBoundSphere.updateBoundsStates();
                    continue;
                }
                double d2 = (dis * dis + this.radius * this.radius - sphere.radius * sphere.radius) / (2.0 * dis);
                double newRadius = Math.sqrt(this.radius * this.radius - d2 * d2);
                double t = d2 / dis;
                newCenter.x = this.center.x + (sphere.center.x - this.center.x) * t;
                newCenter.y = this.center.y + (sphere.center.y - this.center.y) * t;
                newCenter.z = this.center.z + (sphere.center.z - this.center.z) * t;
                if (status) {
                    BoundingSphere newSphere = new BoundingSphere(newCenter, newRadius);
                    newBoundSphere.combine(newSphere);
                    continue;
                }
                newBoundSphere.setRadius(newRadius);
                newBoundSphere.setCenter(newCenter);
                status = true;
                continue;
            }
            if (boundsObjects[i].boundId == 4) {
                BoundingPolytope polytope = (BoundingPolytope)boundsObjects[i];
                if (!this.intersect(polytope)) continue;
                sbox = new BoundingBox(this);
                BoundingBox pbox = new BoundingBox(polytope);
                sbox.intersect((Bounds)pbox, tbox);
                if (status) {
                    newBoundSphere.combine(tbox);
                    continue;
                }
                newBoundSphere.set(tbox);
                status = true;
                continue;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere9"));
        }
        if (!status) {
            newBoundSphere.set(null);
        }
        return status;
    }

    @Override
    public Bounds closestIntersection(Bounds[] boundsObjects) {
        if (boundsObjects == null || boundsObjects.length <= 0) {
            return null;
        }
        if (this.boundsIsEmpty) {
            return null;
        }
        double cenX = 0.0;
        double cenY = 0.0;
        double cenZ = 0.0;
        boolean contains = false;
        boolean intersect = false;
        double smallest_distance = Double.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < boundsObjects.length; ++i) {
            double dis;
            if (boundsObjects[i] == null || !this.intersect(boundsObjects[i])) continue;
            intersect = true;
            if (boundsObjects[i].boundId == 1) {
                BoundingBox box = (BoundingBox)boundsObjects[i];
                cenX = (box.upper.x + box.lower.x) / 2.0;
                cenY = (box.upper.y + box.lower.y) / 2.0;
                cenZ = (box.upper.z + box.lower.z) / 2.0;
                dis = Math.sqrt((this.center.x - cenX) * (this.center.x - cenX) + (this.center.y - cenY) * (this.center.y - cenY) + (this.center.z - cenZ) * (this.center.z - cenZ));
                double far_dis = (this.center.x - box.lower.x) * (this.center.x - box.lower.x) > (this.center.x - box.upper.x) * (this.center.x - box.upper.x) ? (this.center.x - box.lower.x) * (this.center.x - box.lower.x) : (this.center.x - box.upper.x) * (this.center.x - box.upper.x);
                far_dis = (this.center.y - box.lower.y) * (this.center.y - box.lower.y) > (this.center.y - box.upper.y) * (this.center.y - box.upper.y) ? (far_dis += (this.center.y - box.lower.y) * (this.center.y - box.lower.y)) : (far_dis += (this.center.y - box.upper.y) * (this.center.y - box.upper.y));
                far_dis = (this.center.z - box.lower.z) * (this.center.z - box.lower.z) > (this.center.z - box.upper.z) * (this.center.z - box.upper.z) ? (far_dis += (this.center.z - box.lower.z) * (this.center.z - box.lower.z)) : (far_dis += (this.center.z - box.upper.z) * (this.center.z - box.upper.z));
                double rad_sq = this.radius * this.radius;
                if (far_dis <= rad_sq) {
                    if (!contains) {
                        index = i;
                        smallest_distance = dis;
                        contains = true;
                        continue;
                    }
                    if (!(dis < smallest_distance)) continue;
                    index = i;
                    smallest_distance = dis;
                    continue;
                }
                if (contains || !(dis < smallest_distance)) continue;
                index = i;
                smallest_distance = dis;
                continue;
            }
            if (boundsObjects[i].boundId == 2) {
                BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
                dis = Math.sqrt((this.center.x - sphere.center.x) * (this.center.x - sphere.center.x) + (this.center.y - sphere.center.y) * (this.center.y - sphere.center.y) + (this.center.z - sphere.center.z) * (this.center.z - sphere.center.z));
                if (dis + sphere.radius <= this.radius) {
                    if (!contains) {
                        index = i;
                        smallest_distance = dis;
                        contains = true;
                        continue;
                    }
                    if (!(dis < smallest_distance)) continue;
                    index = i;
                    smallest_distance = dis;
                    continue;
                }
                if (contains || !(dis < smallest_distance)) continue;
                index = i;
                smallest_distance = dis;
                continue;
            }
            if (boundsObjects[i].boundId == 4) {
                BoundingPolytope polytope = (BoundingPolytope)boundsObjects[i];
                dis = Math.sqrt((this.center.x - polytope.centroid.x) * (this.center.x - polytope.centroid.x) + (this.center.y - polytope.centroid.y) * (this.center.y - polytope.centroid.y) + (this.center.z - polytope.centroid.z) * (this.center.z - polytope.centroid.z));
                boolean inside = true;
                for (int j = 0; j < polytope.nVerts; ++j) {
                    double x = polytope.verts[j].x - this.center.x;
                    double y = polytope.verts[j].y - this.center.y;
                    double z = polytope.verts[j].z - this.center.z;
                    double pdist = x * x + y * y + z * z;
                    if (!(pdist > this.radius * this.radius)) continue;
                    inside = false;
                }
                if (inside) {
                    if (!contains) {
                        index = i;
                        smallest_distance = dis;
                        contains = true;
                        continue;
                    }
                    if (!(dis < smallest_distance)) continue;
                    index = i;
                    smallest_distance = dis;
                    continue;
                }
                if (contains || !(dis < smallest_distance)) continue;
                index = i;
                smallest_distance = dis;
                continue;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingSphere10"));
        }
        if (intersect) {
            return boundsObjects[index];
        }
        return null;
    }

    boolean intersect(CachedFrustum frustum) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            double dist = frustum.clipPlanes[i].x * this.center.x + frustum.clipPlanes[i].y * this.center.y + frustum.clipPlanes[i].z * this.center.z + frustum.clipPlanes[i].w;
            if (!(dist < 0.0) || !(dist + this.radius < 0.0)) continue;
            return false;
        }
        return true;
    }

    boolean intersect(Vector4d[] planes) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            double dist = planes[i].x * this.center.x + planes[i].y * this.center.y + planes[i].z * this.center.z + planes[i].w;
            if (!(dist < 0.0) || !(dist + this.radius < 0.0)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new String("Center=" + this.center + "  Radius=" + this.radius);
    }

    private void setEmptyBounds() {
        this.center.set(0.0, 0.0, 0.0);
        this.radius = -1.0;
        this.boundsIsInfinite = false;
        this.boundsIsEmpty = true;
    }

    private void setInfiniteBounds() {
        this.center.set(0.0, 0.0, 0.0);
        this.radius = Double.POSITIVE_INFINITY;
        this.boundsIsEmpty = false;
        this.boundsIsInfinite = true;
    }

    private void updateBoundsStates() {
        if (Double.isNaN(this.radius + this.center.x + this.center.y + this.center.z)) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            return;
        }
        if (this.radius == Double.POSITIVE_INFINITY) {
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = true;
        } else {
            this.boundsIsInfinite = false;
            this.boundsIsEmpty = this.radius < 0.0;
        }
    }

    @Override
    Point3d getCenter() {
        return this.center;
    }

    @Override
    Bounds copy(Bounds r) {
        if (r != null && this.boundId == r.boundId) {
            BoundingSphere region = (BoundingSphere)r;
            region.radius = this.radius;
            region.center.x = this.center.x;
            region.center.y = this.center.y;
            region.center.z = this.center.z;
            region.boundsIsEmpty = this.boundsIsEmpty;
            region.boundsIsInfinite = this.boundsIsInfinite;
            return region;
        }
        return (Bounds)this.clone();
    }

    @Override
    int getPickType() {
        return 7;
    }
}

