/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;

class CachedTargets {
    static String[] typeString = new String[]{"GEO_TARGETS", "ENV_TARGETS", "BEH_TARGETS", "SND_TARGETS", "VPF_TARGETS", "BLN_TARGETS", "GRP_TARGETS"};
    static int[] updateTargetThreads = new int[]{8384, 4224, 256, 514, 898, 4992, 8256};
    NnuId[][] targetArr = new NnuId[7][];

    CachedTargets() {
    }

    int computeTargetThreads() {
        int targetThreads = 0;
        for (int i = 0; i < 7; ++i) {
            if (this.targetArr[i] == null) continue;
            targetThreads |= updateTargetThreads[i];
        }
        return targetThreads;
    }

    void copy(CachedTargets ct) {
        for (int i = 0; i < 7; ++i) {
            this.targetArr[i] = ct.targetArr[i];
        }
    }

    void replace(NnuId oldObj, NnuId newObj, int type) {
        NnuId[] newArr = new NnuId[this.targetArr[type].length];
        System.arraycopy(this.targetArr[type], 0, newArr, 0, this.targetArr[type].length);
        this.targetArr[type] = newArr;
        NnuIdManager.replace(oldObj, newObj, this.targetArr[type]);
    }

    void dump() {
        for (int i = 0; i < 7; ++i) {
            if (this.targetArr[i] == null) continue;
            System.err.println("  " + typeString[i]);
            for (int j = 0; j < this.targetArr[i].length; ++j) {
                System.err.println("  " + this.targetArr[i][j]);
            }
        }
    }
}

