/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ConeSoundRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Node;
import javax.media.j3d.PointSound;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class ConeSound
extends PointSound {
    public static final int ALLOW_DIRECTION_READ = 36;
    public static final int ALLOW_DIRECTION_WRITE = 37;
    public static final int ALLOW_ANGULAR_ATTENUATION_READ = 38;
    public static final int ALLOW_ANGULAR_ATTENUATION_WRITE = 39;
    private static final int[] readCapabilities = new int[]{36, 38};

    public ConeSound() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public ConeSound(MediaContainer soundData, float initialGain, Point3f position, Vector3f direction) {
        super(soundData, initialGain, position);
        this.setDefaultReadCapabilities(readCapabilities);
        ((ConeSoundRetained)this.retained).setDirection(direction);
    }

    public ConeSound(MediaContainer soundData, float initialGain, float posX, float posY, float posZ, float dirX, float dirY, float dirZ) {
        super(soundData, initialGain, posX, posY, posZ);
        this.setDefaultReadCapabilities(readCapabilities);
        ((ConeSoundRetained)this.retained).setDirection(dirX, dirY, dirZ);
    }

    public ConeSound(MediaContainer soundData, float initialGain, int loopCount, boolean release, boolean continuous, boolean enable, Bounds region, float priority, Point3f position, Point2f[] frontDistanceAttenuation, Point2f[] backDistanceAttenuation, Vector3f direction) {
        super(soundData, initialGain, loopCount, release, continuous, enable, region, priority, position, frontDistanceAttenuation);
        this.setDefaultReadCapabilities(readCapabilities);
        ((ConeSoundRetained)this.retained).setBackDistanceGain(backDistanceAttenuation);
        ((ConeSoundRetained)this.retained).setDirection(direction);
    }

    public ConeSound(MediaContainer soundData, float initialGain, int loopCount, boolean release, boolean continuous, boolean enable, Bounds region, float priority, float posX, float posY, float posZ, float[] frontDistance, float[] frontDistanceGain, float[] backDistance, float[] backDistanceGain, float dirX, float dirY, float dirZ) {
        super(soundData, initialGain, loopCount, release, continuous, enable, region, priority, posX, posY, posZ, frontDistance, frontDistanceGain);
        this.setDefaultReadCapabilities(readCapabilities);
        ((ConeSoundRetained)this.retained).setDirection(dirX, dirY, dirZ);
        ((ConeSoundRetained)this.retained).setBackDistanceGain(backDistance, backDistanceGain);
    }

    public ConeSound(MediaContainer soundData, float initialGain, int loopCount, boolean release, boolean continuous, boolean enable, Bounds region, float priority, Point3f position, Point2f[] distanceAttenuation, Vector3f direction, Point3f[] angularAttenuation) {
        super(soundData, initialGain, loopCount, release, continuous, enable, region, priority, position, distanceAttenuation);
        this.setDefaultReadCapabilities(readCapabilities);
        ((ConeSoundRetained)this.retained).setDirection(direction);
        ((ConeSoundRetained)this.retained).setAngularAttenuation(angularAttenuation);
    }

    public ConeSound(MediaContainer soundData, float initialGain, int loopCount, boolean release, boolean continuous, boolean enable, Bounds region, float priority, float posX, float posY, float posZ, float[] distance, float[] distanceGain, float dirX, float dirY, float dirZ, float[] angle, float[] angularGain, float[] frequencyCutoff) {
        super(soundData, initialGain, loopCount, release, continuous, enable, region, priority, posX, posY, posZ, distance, distanceGain);
        this.setDefaultReadCapabilities(readCapabilities);
        ((ConeSoundRetained)this.retained).setDirection(dirX, dirY, dirZ);
        ((ConeSoundRetained)this.retained).setAngularAttenuation(angle, angularGain, frequencyCutoff);
    }

    public ConeSound(MediaContainer soundData, float initialGain, int loopCount, boolean release, boolean continuous, boolean enable, Bounds region, float priority, Point3f position, Point2f[] frontDistanceAttenuation, Point2f[] backDistanceAttenuation, Vector3f direction, Point3f[] angularAttenuation) {
        super(soundData, initialGain, loopCount, release, continuous, enable, region, priority, position, frontDistanceAttenuation);
        this.setDefaultReadCapabilities(readCapabilities);
        ((ConeSoundRetained)this.retained).setBackDistanceGain(backDistanceAttenuation);
        ((ConeSoundRetained)this.retained).setDirection(direction);
        ((ConeSoundRetained)this.retained).setAngularAttenuation(angularAttenuation);
    }

    public ConeSound(MediaContainer soundData, float initialGain, int loopCount, boolean release, boolean continuous, boolean enable, Bounds region, float priority, float posX, float posY, float posZ, float[] frontDistance, float[] frontDistanceGain, float[] backDistance, float[] backDistanceGain, float dirX, float dirY, float dirZ, float[] angle, float[] angularGain, float[] frequencyCutoff) {
        super(soundData, initialGain, loopCount, release, continuous, enable, region, priority, posX, posY, posZ, frontDistance, frontDistanceGain);
        this.setDefaultReadCapabilities(readCapabilities);
        ((ConeSoundRetained)this.retained).setBackDistanceGain(backDistance, backDistanceGain);
        ((ConeSoundRetained)this.retained).setDirection(dirX, dirY, dirZ);
        ((ConeSoundRetained)this.retained).setAngularAttenuation(angle, angularGain, frequencyCutoff);
    }

    @Override
    void createRetained() {
        this.retained = new ConeSoundRetained();
        this.retained.setSource(this);
    }

    public void setDistanceGain(Point2f[] frontAttenuation, Point2f[] backAttenuation) {
        if (this.isLiveOrCompiled() && !this.getCapability(35)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound0"));
        }
        ((ConeSoundRetained)this.retained).setDistanceGain(frontAttenuation, backAttenuation);
    }

    public void setDistanceGain(float[] frontDistance, float[] frontGain, float[] backDistance, float[] backGain) {
        if (this.isLiveOrCompiled() && !this.getCapability(35)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound0"));
        }
        ((ConeSoundRetained)this.retained).setDistanceGain(frontDistance, frontGain, backDistance, backGain);
    }

    public void setBackDistanceGain(Point2f[] attenuation) {
        if (this.isLiveOrCompiled() && !this.getCapability(35)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound0"));
        }
        ((ConeSoundRetained)this.retained).setBackDistanceGain(attenuation);
    }

    public void setBackDistanceGain(float[] distance, float[] gain) {
        if (this.isLiveOrCompiled() && !this.getCapability(35)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound0"));
        }
        ((ConeSoundRetained)this.retained).setBackDistanceGain(distance, gain);
    }

    public void getDistanceGain(Point2f[] frontAttenuation, Point2f[] backAttenuation) {
        if (this.isLiveOrCompiled() && !this.getCapability(34)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound2"));
        }
        ((ConeSoundRetained)this.retained).getDistanceGain(frontAttenuation, backAttenuation);
    }

    public void getDistanceGain(float[] frontDistance, float[] frontGain, float[] backDistance, float[] backGain) {
        if (this.isLiveOrCompiled() && !this.getCapability(34)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound10"));
        }
        ((ConeSoundRetained)this.retained).getDistanceGain(frontDistance, frontGain, backDistance, backGain);
    }

    public void setDirection(Vector3f direction) {
        if (this.isLiveOrCompiled() && !this.getCapability(37)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound3"));
        }
        ((ConeSoundRetained)this.retained).setDirection(direction);
    }

    public void setDirection(float x, float y, float z) {
        if (this.isLiveOrCompiled() && !this.getCapability(37)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound3"));
        }
        ((ConeSoundRetained)this.retained).setDirection(x, y, z);
    }

    public void getDirection(Vector3f direction) {
        if (this.isLiveOrCompiled() && !this.getCapability(36)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound5"));
        }
        ((ConeSoundRetained)this.retained).getDirection(direction);
    }

    public void setAngularAttenuation(Point2f[] attenuation) {
        if (this.isLiveOrCompiled() && !this.getCapability(39)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound6"));
        }
        ((ConeSoundRetained)this.retained).setAngularAttenuation(attenuation);
    }

    public void setAngularAttenuation(Point3f[] attenuation) {
        if (this.isLiveOrCompiled() && !this.getCapability(39)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound6"));
        }
        ((ConeSoundRetained)this.retained).setAngularAttenuation(attenuation);
    }

    public void setAngularAttenuation(float[] distance, float[] gain, float[] filter) {
        if (this.isLiveOrCompiled() && !this.getCapability(39)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound6"));
        }
        ((ConeSoundRetained)this.retained).setAngularAttenuation(distance, gain, filter);
    }

    public int getAngularAttenuationLength() {
        if (this.isLiveOrCompiled() && !this.getCapability(38)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound9"));
        }
        return ((ConeSoundRetained)this.retained).getAngularAttenuationLength();
    }

    public void getAngularAttenuation(Point3f[] attenuation) {
        if (this.isLiveOrCompiled() && !this.getCapability(38)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound9"));
        }
        ((ConeSoundRetained)this.retained).getAngularAttenuation(attenuation);
    }

    public void getAngularAttenuation(float[] distance, float[] gain, float[] filter) {
        if (this.isLiveOrCompiled() && !this.getCapability(39)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ConeSound9"));
        }
        ((ConeSoundRetained)this.retained).getAngularAttenuation(distance, gain, filter);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        ConeSound c = new ConeSound();
        c.duplicateNode(this, forceDuplicate);
        return c;
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        this.checkDuplicateNode(originalNode, forceDuplicate);
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        ConeSoundRetained orgRetained = (ConeSoundRetained)originalNode.retained;
        ConeSoundRetained thisRetained = (ConeSoundRetained)this.retained;
        int len = orgRetained.getDistanceGainLength();
        float[] distance = new float[len];
        float[] gain = new float[len];
        orgRetained.getDistanceGain(null, null, distance, gain);
        thisRetained.setBackDistanceGain(distance, gain);
        Vector3f v = new Vector3f();
        orgRetained.getDirection(v);
        thisRetained.setDirection(v);
        len = orgRetained.getAngularAttenuationLength();
        gain = null;
        distance = null;
        float[] angle = new float[len];
        float[] angularGain = new float[len];
        float[] frequencyCutoff = new float[len];
        orgRetained.getAngularAttenuation(angle, angularGain, frequencyCutoff);
        thisRetained.setAngularAttenuation(angle, angularGain, frequencyCutoff);
    }
}

