/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.DepthComponentFloatRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;

public class DepthComponentFloat
extends DepthComponent {
    DepthComponentFloat() {
    }

    public DepthComponentFloat(int width, int height) {
        ((DepthComponentFloatRetained)this.retained).initialize(width, height);
    }

    public void setDepthData(float[] depthData) {
        this.checkForLiveOrCompiled();
        ((DepthComponentFloatRetained)this.retained).setDepthData(depthData);
    }

    public void getDepthData(float[] depthData) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("DepthComponentFloat0"));
        }
        ((DepthComponentFloatRetained)this.retained).getDepthData(depthData);
    }

    @Override
    void createRetained() {
        this.retained = new DepthComponentFloatRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        DepthComponentFloatRetained rt = (DepthComponentFloatRetained)this.retained;
        DepthComponentFloat d = new DepthComponentFloat(rt.width, rt.height);
        d.duplicateNodeComponent(this);
        return d;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        int len = this.getWidth() * this.getHeight();
        float[] f = new float[len];
        ((DepthComponentFloatRetained)originalNodeComponent.retained).getDepthData(f);
        ((DepthComponentFloatRetained)this.retained).setDepthData(f);
    }
}

