/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dThreadData;
import javax.media.j3d.StructureUpdateThread;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;

abstract class J3dStructure {
    UnorderList messageList = new UnorderList(5, J3dMessage.class);
    StructureUpdateThread updateThread = null;
    int threadType = -1;
    VirtualUniverse universe = null;
    J3dThreadData threadData = new J3dThreadData();
    int nMessage = 0;
    J3dMessage[] msgList = new J3dMessage[5];

    J3dStructure(VirtualUniverse u, int type) {
        this.universe = u;
        this.threadType = type;
        this.threadData.threadType = type;
    }

    final J3dThreadData getUpdateThreadData() {
        return this.threadData;
    }

    final void addMessage(J3dMessage message) {
        if (this.threadData != null) {
            this.threadData.lastUpdateTime = message.time;
        } else {
            message.time = -1L;
        }
        message.incRefcount();
        this.messageList.add(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final J3dMessage[] getMessages(long referenceTime) {
        int n = 0;
        UnorderList unorderList = this.messageList;
        synchronized (unorderList) {
            int sz = this.messageList.size();
            if (sz > 0) {
                J3dMessage[] mess = (J3dMessage[])this.messageList.toArray(false);
                for (n = 0; n < sz && mess[n].time <= referenceTime; ++n) {
                }
                if (n > 0) {
                    if (this.msgList.length < n) {
                        this.msgList = new J3dMessage[n];
                    }
                    this.messageList.shift(this.msgList, n);
                }
            }
        }
        this.nMessage = n;
        return this.msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void clearMessages() {
        UnorderList unorderList = this.messageList;
        synchronized (unorderList) {
            int nmessage = this.messageList.size();
            if (nmessage > 0) {
                J3dMessage[] mess = (J3dMessage[])this.messageList.toArray(false);
                for (int i = nmessage - 1; i >= 0; --i) {
                    mess[i].decRefcount();
                }
                this.messageList.clear();
            }
            this.nMessage = 0;
            this.msgList = new J3dMessage[5];
        }
    }

    int getNumMessage() {
        return this.nMessage;
    }

    abstract void processMessages(long var1);

    abstract void removeNodes(J3dMessage var1);

    abstract void cleanup();
}

