/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.GeometryArray;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineArrayRetained;
import javax.media.j3d.NodeComponent;

public class LineArray
extends GeometryArray {
    LineArray() {
    }

    public LineArray(int vertexCount, int vertexFormat) {
        super(vertexCount, vertexFormat);
        if (vertexCount < 2 || vertexCount % 2 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("LineArray0"));
        }
    }

    public LineArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap);
        if (vertexCount < 2 || vertexCount % 2 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("LineArray0"));
        }
    }

    public LineArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes);
        if (vertexCount < 2 || vertexCount % 2 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("LineArray0"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new LineArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        LineArrayRetained rt = (LineArrayRetained)this.retained;
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        LineArray l = new LineArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes);
        l.duplicateNodeComponent(this);
        return l;
    }
}

