/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.MasterControl;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrderedBin;
import javax.media.j3d.OrderedPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.VirtualUniverse;

class OrderedGroupRetained
extends GroupRetained {
    int[] orderedChildIdTable;
    private int orderedChildIdCount = 0;
    private ArrayList orderedChildIdFreeList = new ArrayList();
    private final Object lockObj = new Object();
    private OrderedBin[] orderedBin = new OrderedBin[0];
    int childCount = 0;
    ArrayList<ArrayList<OrderedPath>> childrenOrderedPaths = new ArrayList(1);
    int[] userChildIndexOrder = null;
    int[] childIndexOrder = null;

    OrderedGroupRetained() {
        this.nodeType = 20;
    }

    void setChildIndexOrder(int[] cIOArr) {
        if (cIOArr != null) {
            if (this.userChildIndexOrder == null || this.userChildIndexOrder.length != cIOArr.length) {
                this.userChildIndexOrder = new int[cIOArr.length];
            }
            System.arraycopy(cIOArr, 0, this.userChildIndexOrder, 0, this.userChildIndexOrder.length);
        } else {
            this.userChildIndexOrder = null;
        }
        if (this.source.isLive()) {
            int[] newArr = new int[cIOArr.length];
            System.arraycopy(cIOArr, 0, newArr, 0, newArr.length);
            J3dMessage m = new J3dMessage();
            m.threads = 128;
            m.type = 59;
            m.universe = this.universe;
            m.args[3] = this;
            m.args[4] = newArr;
            VirtualUniverse.mc.processMessage(m);
        }
    }

    int[] getChildIndexOrder() {
        if (this.userChildIndexOrder == null) {
            return null;
        }
        int[] newArr = new int[this.userChildIndexOrder.length];
        System.arraycopy(this.userChildIndexOrder, 0, newArr, 0, this.userChildIndexOrder.length);
        return newArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getOrderedChildId() {
        Integer orderedChildId;
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            if (this.orderedChildIdFreeList.size() == 0) {
                orderedChildId = new Integer(this.orderedChildIdCount);
                ++this.orderedChildIdCount;
            } else {
                orderedChildId = (Integer)this.orderedChildIdFreeList.remove(0);
            }
        }
        return orderedChildId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeOrderedChildId(int id) {
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            this.orderedChildIdFreeList.add(new Integer(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOrderedChildCount() {
        int count;
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            count = this.orderedChildIdCount;
        }
        return count;
    }

    @Override
    void addChild(Node child) {
        if (this.userChildIndexOrder != null) {
            this.doAddChildIndexEntry();
        }
        super.addChild(child);
    }

    void addChild(Node child, int[] cIOArr) {
        if (cIOArr != null) {
            this.userChildIndexOrder = new int[cIOArr.length];
            System.arraycopy(cIOArr, 0, this.userChildIndexOrder, 0, this.userChildIndexOrder.length);
        } else {
            this.userChildIndexOrder = null;
        }
        super.addChild(child);
    }

    @Override
    void moveTo(BranchGroup bg) {
        if (this.userChildIndexOrder != null) {
            this.doAddChildIndexEntry();
        }
        super.moveTo(bg);
    }

    void doRemoveChildIndexEntry(int index) {
        int[] newArr = new int[this.userChildIndexOrder.length - 1];
        int j = 0;
        for (int i = 0; i < this.userChildIndexOrder.length; ++i) {
            if (this.userChildIndexOrder[i] > index) {
                newArr[j] = this.userChildIndexOrder[i] - 1;
                ++j;
                continue;
            }
            if (this.userChildIndexOrder[i] >= index) continue;
            newArr[j] = this.userChildIndexOrder[i];
            ++j;
        }
        this.userChildIndexOrder = newArr;
    }

    void doAddChildIndexEntry() {
        int[] newArr = new int[this.userChildIndexOrder.length + 1];
        System.arraycopy(this.userChildIndexOrder, 0, newArr, 0, this.userChildIndexOrder.length);
        newArr[this.userChildIndexOrder.length] = this.userChildIndexOrder.length;
        this.userChildIndexOrder = newArr;
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        this.mergeFlag = 0;
        if (J3dDebug.debug) {
            ++compState.numOrderedGroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOrderedBin(OrderedBin ob, int index) {
        Object object = this.lockObj;
        synchronized (object) {
            if (index < this.orderedBin.length) {
                this.orderedBin[index] = ob;
                return;
            }
            if (ob == null) {
                return;
            }
            OrderedBin[] newList = new OrderedBin[index + 1];
            System.arraycopy(this.orderedBin, 0, newList, 0, this.orderedBin.length);
            this.orderedBin = newList;
            this.orderedBin[index] = ob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OrderedBin getOrderedBin(int index) {
        Object object = this.lockObj;
        synchronized (object) {
            if (index >= this.orderedBin.length) {
                return null;
            }
            return this.orderedBin[index];
        }
    }

    void updateChildIdTableInserted(int childId, int orderedId) {
        int i;
        int size = 0;
        if (this.orderedChildIdTable != null) {
            size = this.orderedChildIdTable.length;
            for (i = 0; i < size; ++i) {
                if (this.orderedChildIdTable[i] == -1 || this.orderedChildIdTable[i] < childId) continue;
                int n = i;
                this.orderedChildIdTable[n] = this.orderedChildIdTable[n] + 1;
            }
        }
        if (orderedId >= size) {
            int[] newTable = new int[orderedId + 1];
            if (size > 0) {
                System.arraycopy(this.orderedChildIdTable, 0, newTable, 0, this.orderedChildIdTable.length);
            } else {
                for (i = 0; i < newTable.length; ++i) {
                    newTable[i] = -1;
                }
            }
            this.orderedChildIdTable = newTable;
        }
        this.orderedChildIdTable[orderedId] = childId;
    }

    void updateChildIdTableRemoved(int childId) {
        if (this.orderedChildIdTable == null) {
            return;
        }
        for (int i = 0; i < this.orderedChildIdTable.length; ++i) {
            if (this.orderedChildIdTable[i] == -1) continue;
            if (this.orderedChildIdTable[i] > childId) {
                int n = i;
                this.orderedChildIdTable[n] = this.orderedChildIdTable[n] - 1;
                continue;
            }
            if (this.orderedChildIdTable[i] != childId) continue;
            this.orderedChildIdTable[i] = -1;
            this.freeOrderedChildId(i);
        }
    }

    @Override
    void setAuxData(SetLiveState s, int index, int hkIndex) {
        OrderedPath setLiveStateOrderedPath = s.orderedPaths.get(hkIndex);
        for (int i = 0; i < this.children.size(); ++i) {
            NodeRetained child = (NodeRetained)this.children.get(i);
            if (this.refCount == s.refCount) {
                child.orderedId = this.getOrderedChildId();
            }
            OrderedPath newOrderedPath = setLiveStateOrderedPath.clonePath();
            newOrderedPath.addElementToPath(this, child.orderedId);
            this.childrenOrderedPaths.get(i).add(hkIndex, newOrderedPath);
        }
    }

    @Override
    void setLive(SetLiveState s) {
        super.setLive(s);
        s.orderedPaths = this.orderedPaths;
        if (this.userChildIndexOrder != null && this.refCount == 1) {
            int[] newArr = new int[this.userChildIndexOrder.length];
            System.arraycopy(this.userChildIndexOrder, 0, newArr, 0, this.userChildIndexOrder.length);
            this.childIndexOrder = newArr;
        }
    }

    @Override
    void clearLive(SetLiveState s) {
        super.clearLive(s);
        if (this.refCount == 0) {
            s.notifyThreads |= 0x1000;
            s.nodeList.add(this);
            s.ogCIOList.add(this);
            s.ogCIOTableList.add(null);
            this.userChildIndexOrder = null;
        }
        s.orderedPaths = this.orderedPaths;
    }

    @Override
    void setNodeData(SetLiveState s) {
        super.setNodeData(s);
        if (!this.inSharedGroup) {
            this.setAuxData(s, 0, 0);
        } else {
            for (int j = 0; j < s.keys.length; ++j) {
                int hkIndex = s.keys[j].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (hkIndex >= 0) {
                    this.setAuxData(s, j, hkIndex);
                    continue;
                }
                MasterControl.getCoreLogger().severe("Can't Find matching hashKey in setNodeData.");
            }
        }
    }

    @Override
    void removeNodeData(SetLiveState s) {
        if (this.inSharedGroup && s.keys.length != this.localToVworld.length) {
            for (int i = s.keys.length - 1; i >= 0; --i) {
                int index = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (index < 0) continue;
                for (int j = 0; j < this.children.size(); ++j) {
                    ArrayList<OrderedPath> childOrderedPaths = this.childrenOrderedPaths.get(j);
                    childOrderedPaths.remove(index);
                }
            }
        }
        super.removeNodeData(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearDerivedDataStructures() {
        int i;
        Object object = this.lockObj;
        synchronized (object) {
            for (i = 0; i < this.orderedBin.length; ++i) {
                if (this.orderedBin[i] == null) continue;
                this.orderedBin[i].source = null;
                this.orderedBin[i] = null;
            }
        }
        if (this.orderedChildIdTable != null) {
            for (i = 0; i < this.orderedChildIdTable.length; ++i) {
                if (this.orderedChildIdTable[i] == -1) continue;
                this.orderedChildIdTable[i] = -1;
                this.freeOrderedChildId(i);
            }
            this.orderedChildIdTable = null;
        }
    }

    void incrChildCount() {
        ++this.childCount;
    }

    void decrChildCount() {
        --this.childCount;
    }

    void printTable(int[] table) {
        for (int i = 0; i < table.length; ++i) {
            System.err.print(" " + table[i]);
        }
        System.err.println("");
    }

    @Override
    void insertChildrenData(int index) {
        this.childrenOrderedPaths.add(index, new ArrayList(1));
    }

    @Override
    void appendChildrenData() {
        this.childrenOrderedPaths.add(new ArrayList(1));
    }

    @Override
    void doRemoveChild(int index, J3dMessage[] messages, int messageIndex) {
        if (this.userChildIndexOrder != null) {
            this.doRemoveChildIndexEntry(index);
        }
        super.doRemoveChild(index, messages, messageIndex);
    }

    @Override
    void removeChildrenData(int index) {
        this.childrenOrderedPaths.remove(index);
    }

    @Override
    void childDoSetLive(NodeRetained child, int childIndex, SetLiveState s) {
        if (this.refCount == s.refCount) {
            s.ogList.add(this);
            s.ogChildIdList.add(new Integer(childIndex));
            s.ogOrderedIdList.add(child.orderedId);
        }
        s.orderedPaths = this.childrenOrderedPaths.get(childIndex);
        if (child != null) {
            child.setLive(s);
        }
    }

    @Override
    void childCheckSetLive(NodeRetained child, int childIndex, SetLiveState s, NodeRetained linkNode) {
        ArrayList<OrderedPath> childOrderedPaths;
        if (linkNode != null) {
            int ci = this.children.indexOf(linkNode);
            childOrderedPaths = this.childrenOrderedPaths.get(ci);
        } else {
            child.orderedId = this.getOrderedChildId();
            s.ogList.add(this);
            s.ogChildIdList.add(new Integer(childIndex));
            s.ogOrderedIdList.add(child.orderedId);
            if (this.userChildIndexOrder != null) {
                s.ogCIOList.add(this);
                int[] newArr = new int[this.userChildIndexOrder.length];
                System.arraycopy(this.userChildIndexOrder, 0, newArr, 0, this.userChildIndexOrder.length);
                s.ogCIOTableList.add(newArr);
            }
            childOrderedPaths = this.childrenOrderedPaths.get(childIndex);
            for (int i = 0; i < this.orderedPaths.size(); ++i) {
                OrderedPath childOrderedPath = ((OrderedPath)this.orderedPaths.get(i)).clonePath();
                childOrderedPath.addElementToPath(this, child.orderedId);
                childOrderedPaths.add(childOrderedPath);
            }
        }
        s.orderedPaths = childOrderedPaths;
        child.setLive(s);
    }
}

