/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PhysicalBody {
    private static final double HALF_IPD = 0.033;
    private static final double EAR_X = 0.08;
    private static final double EAR_Y = -0.03;
    private static final double EAR_Z = 0.095;
    Point3d leftEyePosition = new Point3d(-0.033, 0.0, 0.0);
    Point3d rightEyePosition = new Point3d(0.033, 0.0, 0.0);
    Point3d leftEarPosition = new Point3d(-0.08, -0.03, 0.095);
    Point3d rightEarPosition = new Point3d(0.08, -0.03, 0.095);
    double nominalEyeHeightFromGround = 1.68;
    double nominalEyeOffsetFromNominalScreen = 0.4572;
    Transform3D headToHeadTracker = new Transform3D();
    ArrayList<View> users = new ArrayList();
    int pbDirtyMask = 0xF000000;

    public PhysicalBody() {
        this.initHeadToHeadTracker();
    }

    synchronized void removeUser(View view) {
        this.users.remove(view);
    }

    synchronized void addUser(View view) {
        if (!this.users.contains(view)) {
            this.users.add(view);
        }
    }

    synchronized void notifyUsers() {
        for (int i = this.users.size() - 1; i >= 0; --i) {
            View view = this.users.get(i);
            if (view.soundScheduler != null) {
                view.soundScheduler.setListenerFlag(3);
            }
            view.repaint();
        }
    }

    public PhysicalBody(Point3d leftEyePosition, Point3d rightEyePosition) {
        this.leftEyePosition.set((Tuple3d)leftEyePosition);
        this.rightEyePosition.set((Tuple3d)rightEyePosition);
        this.initHeadToHeadTracker();
    }

    public PhysicalBody(Point3d leftEyePosition, Point3d rightEyePosition, Point3d leftEarPosition, Point3d rightEarPosition) {
        this.leftEyePosition.set((Tuple3d)leftEyePosition);
        this.rightEyePosition.set((Tuple3d)rightEyePosition);
        this.leftEarPosition.set((Tuple3d)leftEarPosition);
        this.rightEarPosition.set((Tuple3d)rightEarPosition);
        this.initHeadToHeadTracker();
    }

    public String toString() {
        return "eyePosition = (" + this.leftEyePosition + ", " + this.rightEyePosition + ")\n" + "earPosition = (" + this.leftEarPosition + ", " + this.rightEarPosition + ")";
    }

    public void getLeftEyePosition(Point3d position) {
        position.set((Tuple3d)this.leftEyePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftEyePosition(Point3d position) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.leftEyePosition.set((Tuple3d)position);
            this.pbDirtyMask |= 0x1000000;
        }
        this.notifyUsers();
    }

    public void getRightEyePosition(Point3d position) {
        position.set((Tuple3d)this.rightEyePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightEyePosition(Point3d position) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.rightEyePosition.set((Tuple3d)position);
            this.pbDirtyMask |= 0x1000000;
        }
        this.notifyUsers();
    }

    public void getLeftEarPosition(Point3d position) {
        position.set((Tuple3d)this.leftEarPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeftEarPosition(Point3d position) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.leftEarPosition.set((Tuple3d)position);
            this.pbDirtyMask |= 0x2000000;
        }
        this.notifyUsers();
    }

    public void getRightEarPosition(Point3d position) {
        position.set((Tuple3d)this.rightEarPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRightEarPosition(Point3d position) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.rightEarPosition.set((Tuple3d)position);
            this.pbDirtyMask |= 0x2000000;
        }
        this.notifyUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNominalEyeHeightFromGround(double height) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.nominalEyeHeightFromGround = height;
            this.pbDirtyMask |= 0x4000000;
        }
        this.notifyUsers();
    }

    public double getNominalEyeHeightFromGround() {
        return this.nominalEyeHeightFromGround;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNominalEyeOffsetFromNominalScreen(double offset) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.nominalEyeOffsetFromNominalScreen = offset;
            this.pbDirtyMask |= 0x8000000;
        }
        this.notifyUsers();
    }

    public double getNominalEyeOffsetFromNominalScreen() {
        return this.nominalEyeOffsetFromNominalScreen;
    }

    public void setHeadToHeadTracker(Transform3D t) {
        if (!t.isRigid()) {
            throw new BadTransformException(J3dI18N.getString("PhysicalBody0"));
        }
        this.headToHeadTracker.setWithLock(t);
        this.notifyUsers();
    }

    public void getHeadToHeadTracker(Transform3D t) {
        t.set(this.headToHeadTracker);
    }

    private void initHeadToHeadTracker() {
        Vector3d v = new Vector3d(0.0, 0.02, 0.035);
        this.headToHeadTracker.set(v);
    }
}

