/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class PolygonAttributesRetained
extends NodeComponentRetained {
    static final int POLYGON_MODE_CHANGED = 1;
    static final int POLYGON_CULL_CHANGED = 2;
    static final int POLYGON_OFFSET_CHANGED = 4;
    static final int POLYGON_BACKFACENORMALFLIP_CHANGED = 8;
    static final int POLYGON_OFFSETFACTOR_CHANGED = 16;
    int polygonMode = 2;
    int cullFace = 1;
    boolean backFaceNormalFlip = false;
    float polygonOffset;
    float polygonOffsetFactor;

    PolygonAttributesRetained() {
    }

    final void initCullFace(int cullFace) {
        this.cullFace = cullFace;
    }

    final void setCullFace(int cullFace) {
        this.initCullFace(cullFace);
        this.sendMessage(2, new Integer(cullFace));
    }

    final int getCullFace() {
        return this.cullFace;
    }

    final void initBackFaceNormalFlip(boolean backFaceNormalFlip) {
        this.backFaceNormalFlip = backFaceNormalFlip;
    }

    final void setBackFaceNormalFlip(boolean backFaceNormalFlip) {
        this.initBackFaceNormalFlip(backFaceNormalFlip);
        this.sendMessage(8, backFaceNormalFlip ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getBackFaceNormalFlip() {
        return this.backFaceNormalFlip;
    }

    final void initPolygonMode(int polygonMode) {
        this.polygonMode = polygonMode;
    }

    final void setPolygonMode(int polygonMode) {
        this.initPolygonMode(polygonMode);
        this.sendMessage(1, new Integer(polygonMode));
    }

    final int getPolygonMode() {
        return this.polygonMode;
    }

    final void initPolygonOffset(float polygonOffset) {
        this.polygonOffset = polygonOffset;
    }

    final void setPolygonOffset(float polygonOffset) {
        this.initPolygonOffset(polygonOffset);
        this.sendMessage(4, new Float(polygonOffset));
    }

    final float getPolygonOffset() {
        return this.polygonOffset;
    }

    final void initPolygonOffsetFactor(float polygonOffsetFactor) {
        this.polygonOffsetFactor = polygonOffsetFactor;
    }

    final void setPolygonOffsetFactor(float polygonOffsetFactor) {
        this.initPolygonOffsetFactor(polygonOffsetFactor);
        this.sendMessage(16, new Float(polygonOffsetFactor));
    }

    final float getPolygonOffsetFactor() {
        return this.polygonOffsetFactor;
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                PolygonAttributesRetained mirrorPa = new PolygonAttributesRetained();
                mirrorPa.set(this);
                mirrorPa.source = this.source;
                this.mirror = mirrorPa;
            }
        } else {
            ((PolygonAttributesRetained)this.mirror).set(this);
        }
    }

    void updateNative(Context ctx) {
        Pipeline.getPipeline().updatePolygonAttributes(ctx, this.polygonMode, this.cullFace, this.backFaceNormalFlip, this.polygonOffset, this.polygonOffsetFactor);
    }

    @Override
    synchronized void initMirrorObject() {
        ((PolygonAttributesRetained)this.mirror).set(this);
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        PolygonAttributesRetained mirrorPa = (PolygonAttributesRetained)this.mirror;
        if ((component & 1) != 0) {
            mirrorPa.polygonMode = (Integer)value;
        } else if ((component & 2) != 0) {
            mirrorPa.cullFace = (Integer)value;
        } else if ((component & 8) != 0) {
            mirrorPa.backFaceNormalFlip = (Boolean)value;
        } else if ((component & 4) != 0) {
            mirrorPa.polygonOffset = ((Float)value).floatValue();
        } else if ((component & 0x10) != 0) {
            mirrorPa.polygonOffsetFactor = ((Float)value).floatValue();
        }
    }

    boolean equivalent(PolygonAttributesRetained pr) {
        return pr != null && pr.cullFace == this.cullFace && pr.backFaceNormalFlip == this.backFaceNormalFlip && pr.polygonOffset == this.polygonOffset && pr.polygonMode == this.polygonMode && pr.polygonOffsetFactor == this.polygonOffsetFactor;
    }

    protected void set(PolygonAttributesRetained pr) {
        super.set(pr);
        this.cullFace = pr.cullFace;
        this.backFaceNormalFlip = pr.backFaceNormalFlip;
        this.polygonMode = pr.polygonMode;
        this.polygonOffset = pr.polygonOffset;
        this.polygonOffsetFactor = pr.polygonOffsetFactor;
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 9;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i = 0; i < univList.size(); ++i) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 9;
            createMessage.universe = univList.get(i);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        if (bit == 1 || bit == 7 || bit == 3 || bit == 5) {
            this.setFrequencyChangeMask(bit, 1);
        }
    }
}

