/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.RenderingAttributesRetained;

public class RenderingAttributes
extends NodeComponent {
    public static final int ALLOW_ALPHA_TEST_VALUE_READ = 0;
    public static final int ALLOW_ALPHA_TEST_VALUE_WRITE = 1;
    public static final int ALLOW_ALPHA_TEST_FUNCTION_READ = 2;
    public static final int ALLOW_ALPHA_TEST_FUNCTION_WRITE = 3;
    public static final int ALLOW_DEPTH_TEST_FUNCTION_READ = 12;
    public static final int ALLOW_DEPTH_TEST_FUNCTION_WRITE = 13;
    public static final int ALLOW_DEPTH_ENABLE_READ = 4;
    public static final int ALLOW_DEPTH_ENABLE_WRITE = 11;
    public static final int ALLOW_VISIBLE_READ = 5;
    public static final int ALLOW_VISIBLE_WRITE = 6;
    public static final int ALLOW_IGNORE_VERTEX_COLORS_READ = 9;
    public static final int ALLOW_IGNORE_VERTEX_COLORS_WRITE = 10;
    public static final int ALLOW_RASTER_OP_READ = 7;
    public static final int ALLOW_RASTER_OP_WRITE = 8;
    public static final int ALLOW_STENCIL_ATTRIBUTES_READ = 14;
    public static final int ALLOW_STENCIL_ATTRIBUTES_WRITE = 15;
    public static final int ALWAYS = 0;
    public static final int NEVER = 1;
    public static final int EQUAL = 2;
    public static final int NOT_EQUAL = 3;
    public static final int LESS = 4;
    public static final int LESS_OR_EQUAL = 5;
    public static final int GREATER = 6;
    public static final int GREATER_OR_EQUAL = 7;
    public static final int ROP_CLEAR = 0;
    public static final int ROP_AND = 1;
    public static final int ROP_AND_REVERSE = 2;
    public static final int ROP_COPY = 3;
    public static final int ROP_AND_INVERTED = 4;
    public static final int ROP_NOOP = 5;
    public static final int ROP_XOR = 6;
    public static final int ROP_OR = 7;
    public static final int ROP_NOR = 8;
    public static final int ROP_EQUIV = 9;
    public static final int ROP_INVERT = 10;
    public static final int ROP_OR_REVERSE = 11;
    public static final int ROP_COPY_INVERTED = 12;
    public static final int ROP_OR_INVERTED = 13;
    public static final int ROP_NAND = 14;
    public static final int ROP_SET = 15;
    public static final int STENCIL_KEEP = 1;
    public static final int STENCIL_ZERO = 2;
    public static final int STENCIL_REPLACE = 3;
    public static final int STENCIL_INCR = 4;
    public static final int STENCIL_DECR = 5;
    public static final int STENCIL_INVERT = 6;
    private static final int[] readCapabilities = new int[]{2, 0, 4, 12, 9, 7, 14, 5};

    public RenderingAttributes() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public RenderingAttributes(boolean depthBufferEnable, boolean depthBufferWriteEnable, float alphaTestValue, int alphaTestFunction) {
        this(depthBufferEnable, depthBufferWriteEnable, alphaTestValue, alphaTestFunction, true, false, false, 3);
    }

    public RenderingAttributes(boolean depthBufferEnable, boolean depthBufferWriteEnable, float alphaTestValue, int alphaTestFunction, boolean visible, boolean ignoreVertexColors, boolean rasterOpEnable, int rasterOp) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((RenderingAttributesRetained)this.retained).initDepthBufferEnable(depthBufferEnable);
        ((RenderingAttributesRetained)this.retained).initDepthBufferWriteEnable(depthBufferWriteEnable);
        ((RenderingAttributesRetained)this.retained).initAlphaTestValue(alphaTestValue);
        ((RenderingAttributesRetained)this.retained).initAlphaTestFunction(alphaTestFunction);
        ((RenderingAttributesRetained)this.retained).initVisible(visible);
        ((RenderingAttributesRetained)this.retained).initIgnoreVertexColors(ignoreVertexColors);
        ((RenderingAttributesRetained)this.retained).initRasterOpEnable(rasterOpEnable);
        ((RenderingAttributesRetained)this.retained).initRasterOp(rasterOp);
    }

    public void setDepthBufferEnable(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes0"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setDepthBufferEnable(state);
        } else {
            ((RenderingAttributesRetained)this.retained).initDepthBufferEnable(state);
        }
    }

    public boolean getDepthBufferEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes1"));
        }
        return ((RenderingAttributesRetained)this.retained).getDepthBufferEnable();
    }

    public void setDepthBufferWriteEnable(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes2"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setDepthBufferWriteEnable(state);
        } else {
            ((RenderingAttributesRetained)this.retained).initDepthBufferWriteEnable(state);
        }
    }

    public boolean getDepthBufferWriteEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes3"));
        }
        return ((RenderingAttributesRetained)this.retained).getDepthBufferWriteEnable();
    }

    public void setAlphaTestValue(float value) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes4"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setAlphaTestValue(value);
        } else {
            ((RenderingAttributesRetained)this.retained).initAlphaTestValue(value);
        }
    }

    public float getAlphaTestValue() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes5"));
        }
        return ((RenderingAttributesRetained)this.retained).getAlphaTestValue();
    }

    public void setAlphaTestFunction(int function) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes6"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setAlphaTestFunction(function);
        } else {
            ((RenderingAttributesRetained)this.retained).initAlphaTestFunction(function);
        }
    }

    public int getAlphaTestFunction() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes7"));
        }
        return ((RenderingAttributesRetained)this.retained).getAlphaTestFunction();
    }

    public void setVisible(boolean visible) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes8"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setVisible(visible);
        } else {
            ((RenderingAttributesRetained)this.retained).initVisible(visible);
        }
    }

    public boolean getVisible() {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes9"));
        }
        return ((RenderingAttributesRetained)this.retained).getVisible();
    }

    public void setIgnoreVertexColors(boolean ignoreVertexColors) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes12"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setIgnoreVertexColors(ignoreVertexColors);
        } else {
            ((RenderingAttributesRetained)this.retained).initIgnoreVertexColors(ignoreVertexColors);
        }
    }

    public boolean getIgnoreVertexColors() {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes13"));
        }
        return ((RenderingAttributesRetained)this.retained).getIgnoreVertexColors();
    }

    public void setRasterOpEnable(boolean rasterOpEnable) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes10"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setRasterOpEnable(rasterOpEnable);
        } else {
            ((RenderingAttributesRetained)this.retained).initRasterOpEnable(rasterOpEnable);
        }
    }

    public boolean getRasterOpEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes11"));
        }
        return ((RenderingAttributesRetained)this.retained).getRasterOpEnable();
    }

    public void setRasterOp(int rasterOp) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes10"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setRasterOp(rasterOp);
        } else {
            ((RenderingAttributesRetained)this.retained).initRasterOp(rasterOp);
        }
    }

    public int getRasterOp() {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes11"));
        }
        return ((RenderingAttributesRetained)this.retained).getRasterOp();
    }

    @Override
    void createRetained() {
        this.retained = new RenderingAttributesRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        RenderingAttributes ra = new RenderingAttributes();
        ra.duplicateNodeComponent(this);
        return ra;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        RenderingAttributesRetained attr = (RenderingAttributesRetained)originalNodeComponent.retained;
        RenderingAttributesRetained rt = (RenderingAttributesRetained)this.retained;
        rt.initDepthBufferEnable(attr.getDepthBufferEnable());
        rt.initDepthBufferWriteEnable(attr.getDepthBufferWriteEnable());
        rt.initDepthTestFunction(attr.getDepthTestFunction());
        rt.initAlphaTestValue(attr.getAlphaTestValue());
        rt.initAlphaTestFunction(attr.getAlphaTestFunction());
        rt.initVisible(attr.getVisible());
        rt.initIgnoreVertexColors(attr.getIgnoreVertexColors());
        rt.initRasterOpEnable(attr.getRasterOpEnable());
        rt.initRasterOp(attr.getRasterOp());
        rt.initStencilEnable(attr.getStencilEnable());
        int[] ops = new int[3];
        attr.getStencilOp(ops);
        rt.initStencilOp(ops[0], ops[1], ops[2]);
        attr.getStencilFunction(ops);
        rt.initStencilFunction(ops[0], ops[1], ops[2]);
        rt.initStencilWriteMask(attr.getStencilWriteMask());
    }

    public void setDepthTestFunction(int function) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes14"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setDepthTestFunction(function);
        } else {
            ((RenderingAttributesRetained)this.retained).initDepthTestFunction(function);
        }
    }

    public int getDepthTestFunction() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes15"));
        }
        return ((RenderingAttributesRetained)this.retained).getDepthTestFunction();
    }

    public void setStencilEnable(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes16"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setStencilEnable(state);
        } else {
            ((RenderingAttributesRetained)this.retained).initStencilEnable(state);
        }
    }

    public boolean getStencilEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes17"));
        }
        return ((RenderingAttributesRetained)this.retained).getStencilEnable();
    }

    public void setStencilOp(int failOp, int zFailOp, int zPassOp) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes16"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setStencilOp(failOp, zFailOp, zPassOp);
        } else {
            ((RenderingAttributesRetained)this.retained).initStencilOp(failOp, zFailOp, zPassOp);
        }
    }

    public void setStencilOp(int[] stencilOps) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes16"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setStencilOp(stencilOps[0], stencilOps[1], stencilOps[2]);
        } else {
            ((RenderingAttributesRetained)this.retained).initStencilOp(stencilOps[0], stencilOps[1], stencilOps[2]);
        }
    }

    public void getStencilOp(int[] stencilOps) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes17"));
        }
        ((RenderingAttributesRetained)this.retained).getStencilOp(stencilOps);
    }

    public void setStencilFunction(int function, int refValue, int compareMask) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes16"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setStencilFunction(function, refValue, compareMask);
        } else {
            ((RenderingAttributesRetained)this.retained).initStencilFunction(function, refValue, compareMask);
        }
    }

    public void setStencilFunction(int[] params) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes16"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setStencilFunction(params[0], params[1], params[2]);
        } else {
            ((RenderingAttributesRetained)this.retained).initStencilFunction(params[0], params[1], params[2]);
        }
    }

    public void getStencilFunction(int[] params) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes17"));
        }
        ((RenderingAttributesRetained)this.retained).getStencilFunction(params);
    }

    public void setStencilWriteMask(int mask) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes16"));
        }
        if (this.isLive()) {
            ((RenderingAttributesRetained)this.retained).setStencilWriteMask(mask);
        } else {
            ((RenderingAttributesRetained)this.retained).initStencilWriteMask(mask);
        }
    }

    public int getStencilWriteMask() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("RenderingAttributes17"));
        }
        return ((RenderingAttributesRetained)this.retained).getStencilWriteMask();
    }
}

