/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.SpotLightRetained;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class SpotLight
extends PointLight {
    public static final int ALLOW_SPREAD_ANGLE_WRITE = 22;
    public static final int ALLOW_SPREAD_ANGLE_READ = 23;
    public static final int ALLOW_CONCENTRATION_WRITE = 24;
    public static final int ALLOW_CONCENTRATION_READ = 25;
    public static final int ALLOW_DIRECTION_WRITE = 26;
    public static final int ALLOW_DIRECTION_READ = 27;
    private static final int[] readCapabilities = new int[]{23, 25, 27};

    public SpotLight() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public SpotLight(Color3f color, Point3f position, Point3f attenuation, Vector3f direction, float spreadAngle, float concentration) {
        super(color, position, attenuation);
        this.setDefaultReadCapabilities(readCapabilities);
        ((SpotLightRetained)this.retained).initDirection(direction);
        ((SpotLightRetained)this.retained).initSpreadAngle(spreadAngle);
        ((SpotLightRetained)this.retained).initConcentration(concentration);
    }

    public SpotLight(boolean lightOn, Color3f color, Point3f position, Point3f attenuation, Vector3f direction, float spreadAngle, float concentration) {
        super(lightOn, color, position, attenuation);
        this.setDefaultReadCapabilities(readCapabilities);
        ((SpotLightRetained)this.retained).initDirection(direction);
        ((SpotLightRetained)this.retained).initSpreadAngle(spreadAngle);
        ((SpotLightRetained)this.retained).initConcentration(concentration);
    }

    @Override
    void createRetained() {
        this.retained = new SpotLightRetained();
        this.retained.setSource(this);
    }

    public void setSpreadAngle(float spreadAngle) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight0"));
        }
        if (this.isLive()) {
            ((SpotLightRetained)this.retained).setSpreadAngle(spreadAngle);
        } else {
            ((SpotLightRetained)this.retained).initSpreadAngle(spreadAngle);
        }
    }

    public float getSpreadAngle() {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight1"));
        }
        return ((SpotLightRetained)this.retained).getSpreadAngle();
    }

    public void setConcentration(float concentration) {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight2"));
        }
        if (this.isLive()) {
            ((SpotLightRetained)this.retained).setConcentration(concentration);
        } else {
            ((SpotLightRetained)this.retained).initConcentration(concentration);
        }
    }

    public float getConcentration() {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight3"));
        }
        return ((SpotLightRetained)this.retained).getConcentration();
    }

    public void setDirection(float x, float y, float z) {
        if (this.isLiveOrCompiled() && !this.getCapability(26)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight4"));
        }
        if (this.isLive()) {
            ((SpotLightRetained)this.retained).setDirection(x, y, z);
        } else {
            ((SpotLightRetained)this.retained).initDirection(x, y, z);
        }
    }

    public void setDirection(Vector3f direction) {
        if (this.isLiveOrCompiled() && !this.getCapability(26)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight4"));
        }
        if (this.isLive()) {
            ((SpotLightRetained)this.retained).setDirection(direction);
        } else {
            ((SpotLightRetained)this.retained).initDirection(direction);
        }
    }

    public void getDirection(Vector3f direction) {
        if (this.isLiveOrCompiled() && !this.getCapability(27)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight6"));
        }
        ((SpotLightRetained)this.retained).getDirection(direction);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        SpotLight s = new SpotLight();
        s.duplicateNode(this, forceDuplicate);
        return s;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        SpotLightRetained attr = (SpotLightRetained)originalNode.retained;
        SpotLightRetained rt = (SpotLightRetained)this.retained;
        rt.initSpreadAngle(attr.getSpreadAngle());
        rt.initConcentration(attr.getConcentration());
        Vector3f v = new Vector3f();
        attr.getDirection(v);
        rt.initDirection(v);
    }
}

