/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCondition;

class WakeupIndexedList
implements Cloneable,
Serializable {
    static final boolean debug = false;
    transient WakeupCondition[] elementData;
    transient Object[] cloneData;
    transient int cloneSize;
    transient boolean isDirty = true;
    Class componentType;
    int size;
    int listType;
    VirtualUniverse univ;

    WakeupIndexedList(int initialCapacity, Class componentType, int listType, VirtualUniverse univ) {
        this.componentType = componentType;
        this.elementData = (WakeupCondition[])Array.newInstance(componentType, initialCapacity);
        this.listType = listType;
        this.univ = univ;
    }

    WakeupIndexedList(Class componentType, int listType, VirtualUniverse univ) {
        this(10, componentType, listType, univ);
    }

    WakeupIndexedList(int initialCapacity, int listType, VirtualUniverse univ) {
        this(initialCapacity, WakeupCondition.class, listType, univ);
    }

    WakeupIndexedList(int listType, VirtualUniverse univ) {
        this(10, WakeupCondition.class, listType, univ);
    }

    static final void init(WakeupCondition obj, int len) {
        obj.listIdx = new int[2][len];
        for (int i = 0; i < len; ++i) {
            obj.listIdx[0][i] = -1;
            obj.listIdx[1][i] = -1;
        }
    }

    final int size() {
        return this.size;
    }

    final int arraySize() {
        return this.cloneSize;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final synchronized boolean contains(WakeupCondition o) {
        return o.listIdx[o.behav.getIdxUsed(this.univ)][this.listType] >= 0;
    }

    final synchronized int indexOf(WakeupCondition o) {
        return o.listIdx[o.behav.getIdxUsed(this.univ)][this.listType];
    }

    protected final synchronized Object clone() {
        try {
            WakeupIndexedList v = (WakeupIndexedList)super.clone();
            v.elementData = (WakeupCondition[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.size);
            this.isDirty = true;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    final synchronized Object[] toArray(boolean copy) {
        if (copy) {
            if (this.isDirty) {
                if (this.cloneData == null || this.cloneData.length < this.size) {
                    this.cloneData = (Object[])Array.newInstance(this.componentType, this.size);
                }
                System.arraycopy(this.elementData, 0, this.cloneData, 0, this.size);
                this.cloneSize = this.size;
                this.isDirty = false;
            }
            return this.cloneData;
        }
        this.cloneSize = this.size;
        return this.elementData;
    }

    final synchronized Object[] toArray() {
        return this.toArray(true);
    }

    final synchronized Object[] toArray(WakeupCondition startElement) {
        int idx = this.indexOf(startElement);
        if (idx < 0) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        int s = this.size - idx;
        Object[] data = (Object[])Array.newInstance(this.componentType, s);
        System.arraycopy(this.elementData, idx, data, 0, s);
        return data;
    }

    final synchronized void trimToSize() {
        if (this.elementData.length > this.size) {
            WakeupCondition[] oldData = this.elementData;
            this.elementData = (WakeupCondition[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    final synchronized Object get(int index) {
        return this.elementData[index];
    }

    final synchronized void set(int index, WakeupCondition o) {
        WakeupCondition oldElm = this.elementData[index];
        if (oldElm != null) {
            oldElm.listIdx[oldElm.behav.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = -1;
        }
        this.elementData[index] = o;
        int univIdx = o.behav.getIdxUsed(this.univ);
        o.listIdx[univIdx][this.listType] = index;
        this.isDirty = true;
    }

    final synchronized void add(WakeupCondition o) {
        if (this.elementData.length == this.size) {
            WakeupCondition[] oldData = this.elementData;
            this.elementData = (WakeupCondition[])Array.newInstance(this.componentType, this.size << 1);
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
        int univIdx = o.behav.getIdxUsed(this.univ);
        int idx = this.size++;
        this.elementData[idx] = o;
        o.listIdx[univIdx][this.listType] = idx;
        this.isDirty = true;
    }

    final synchronized void remove(int index) {
        WakeupCondition elm = this.elementData[index];
        int univIdx = elm.behav.getIdxUsed(this.univ);
        elm.listIdx[univIdx][this.listType] = -1;
        --this.size;
        if (index != this.size) {
            elm = this.elementData[this.size];
            elm.listIdx[univIdx][this.listType] = index;
            this.elementData[index] = elm;
        }
        this.elementData[this.size] = null;
        this.isDirty = true;
    }

    final synchronized Object removeLastElement() {
        WakeupCondition elm = this.elementData[--this.size];
        this.elementData[this.size] = null;
        elm.listIdx[elm.behav.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = -1;
        this.isDirty = true;
        return elm;
    }

    final synchronized boolean remove(WakeupCondition o) {
        int univIdx = o.behav.getIdxUsed(this.univ);
        int idx = o.listIdx[univIdx][this.listType];
        if (idx >= 0) {
            --this.size;
            if (idx != this.size) {
                WakeupCondition elm;
                this.elementData[idx] = elm = this.elementData[this.size];
                elm.listIdx[elm.behav.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = idx;
            }
            this.elementData[this.size] = null;
            o.listIdx[univIdx][this.listType] = -1;
            this.isDirty = true;
            return true;
        }
        return false;
    }

    final synchronized void clear() {
        for (int i = this.size - 1; i >= 0; --i) {
            WakeupCondition o = this.elementData[i];
            o.listIdx[o.behav.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = -1;
            this.elementData[i] = null;
        }
        this.size = 0;
        this.isDirty = true;
    }

    final synchronized void clearMirror() {
        if (this.cloneData != null) {
            for (int i = this.cloneData.length - 1; i >= 0; --i) {
                this.cloneData[i] = null;
            }
        }
        this.cloneSize = 0;
        this.isDirty = true;
    }

    final Class getComponentType() {
        return this.componentType;
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer(this.hashCode() + " Size = " + this.size + "[");
        int len = this.size - 1;
        for (int i = 0; i < this.size; ++i) {
            WakeupCondition obj = this.elementData[i];
            if (obj != null) {
                sb.append(this.elementData[i].toString());
            } else {
                sb.append("NULL");
            }
            if (i == len) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.elementData[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elementData = (WakeupCondition[])Array.newInstance(this.componentType, arrayLength);
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = (WakeupCondition)s.readObject();
        }
    }
}

