/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupIndexedList;
import javax.media.j3d.WakeupOnCollisionEntry;

public final class WakeupOnCollisionMovement
extends WakeupCriterion {
    static final int COND_IN_GS_LIST = 0;
    static final int COLLIDEMOVE_IN_BS_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    public static final int USE_GEOMETRY = 10;
    public static final int USE_BOUNDS = 11;
    int accuracyMode;
    NodeRetained armingNode;
    Bounds vwcBounds;
    Bounds localBounds = null;
    Bounds lastSrcBounds = null;
    Bounds lastDstBounds = null;
    boolean duplicateEvent = false;
    BoundingLeafRetained boundingLeaf = null;
    UnorderList geometryAtoms = null;
    int nodeType;
    SceneGraphPath armingPath = null;
    Bounds armingBounds = null;
    SceneGraphPath collidingPath = null;
    Bounds collidingBounds = null;

    public WakeupOnCollisionMovement(SceneGraphPath armingPath) {
        this(armingPath, 11);
    }

    public WakeupOnCollisionMovement(SceneGraphPath armingPath, int speedHint) {
        this(new SceneGraphPath(armingPath), speedHint, null);
    }

    public WakeupOnCollisionMovement(Node armingNode) {
        this(armingNode, 11);
    }

    public WakeupOnCollisionMovement(Node armingNode, int speedHint) {
        this(new SceneGraphPath(null, armingNode), speedHint, null);
    }

    public WakeupOnCollisionMovement(Bounds armingBounds) {
        this(null, 11, (Bounds)armingBounds.clone());
    }

    WakeupOnCollisionMovement(SceneGraphPath armingPath, int speedHint, Bounds armingBounds) {
        if (armingPath != null) {
            this.armingNode = (NodeRetained)armingPath.getObject().retained;
            this.nodeType = WakeupOnCollisionEntry.getNodeType(this.armingNode, armingPath, "WakeupOnCollisionMovement");
            this.armingPath = armingPath;
            WakeupOnCollisionEntry.validateSpeedHint(speedHint, "WakeupOnCollisionMovement4");
        } else {
            this.armingBounds = armingBounds;
            this.nodeType = 0;
        }
        this.accuracyMode = speedHint;
        WakeupIndexedList.init(this, 2);
    }

    public SceneGraphPath getArmingPath() {
        return this.armingPath != null ? new SceneGraphPath(this.armingPath) : null;
    }

    public Bounds getArmingBounds() {
        return this.armingBounds != null ? (Bounds)this.armingBounds.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SceneGraphPath getTriggeringPath() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionMovement5"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionMovement5"));
            }
        }
        return this.collidingPath != null ? new SceneGraphPath(this.collidingPath) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bounds getTriggeringBounds() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionMovement6"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionMovement6"));
            }
        }
        return this.collidingBounds != null ? (Bounds)this.collidingBounds.clone() : null;
    }

    @Override
    void addBehaviorCondition(BehaviorStructure bs) {
        switch (this.nodeType) {
            case 11: 
            case 28: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                Shape3DRetained shape = (Shape3DRetained)this.armingNode;
                this.geometryAtoms.add(Shape3DRetained.getGeomAtom(shape.getMirrorShape(this.armingPath)));
                break;
            }
            case 10: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                MorphRetained morph = (MorphRetained)this.armingNode;
                this.geometryAtoms.add(Shape3DRetained.getGeomAtom(morph.getMirrorShape(this.armingPath)));
                break;
            }
            case 25: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                this.boundingLeaf = ((BoundingLeafRetained)this.armingNode).mirrorBoundingLeaf;
                break;
            }
            case 0: {
                this.vwcBounds = (Bounds)this.armingBounds.clone();
                this.armingNode = this.behav;
                break;
            }
            case 23: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.accuracyMode != 10) break;
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                ((GroupRetained)this.armingNode).searchGeometryAtoms(this.geometryAtoms);
            }
        }
        this.behav.universe.geometryStructure.addWakeupOnCollision(this);
    }

    @Override
    void removeBehaviorCondition(BehaviorStructure bs) {
        this.vwcBounds = null;
        if (this.geometryAtoms != null) {
            this.geometryAtoms.clear();
        }
        this.boundingLeaf = null;
        this.behav.universe.geometryStructure.removeWakeupOnCollision(this);
    }

    void setTarget(BHLeafInterface leaf) {
        Bounds bound;
        SceneGraphPath path;
        if (leaf instanceof GeometryAtom) {
            GeometryAtom geomAtom = (GeometryAtom)leaf;
            Shape3DRetained shape = geomAtom.source;
            path = WakeupOnCollisionEntry.getSceneGraphPath(shape.sourceNode, shape.key, shape.getCurrentLocalToVworld(0));
            bound = WakeupOnCollisionEntry.getTriggeringBounds(shape);
        } else {
            GroupRetained group = (GroupRetained)leaf;
            path = WakeupOnCollisionEntry.getSceneGraphPath(group);
            bound = WakeupOnCollisionEntry.getTriggeringBounds(group);
        }
        if (path != null) {
            this.collidingPath = path;
            this.collidingBounds = bound;
        }
    }

    void updateCollisionBounds(boolean reEvaluateGAs) {
        if (this.nodeType == 23) {
            GroupRetained group = (GroupRetained)this.armingNode;
            this.vwcBounds = group.collisionBound != null ? (Bounds)group.collisionBound.clone() : group.getEffectiveBounds();
            group.transformBounds(this.armingPath, this.vwcBounds);
        } else if (this.nodeType == 0) {
            this.vwcBounds.transform(this.armingBounds, this.behav.getCurrentLocalToVworld());
        }
        if (reEvaluateGAs && this.nodeType == 23 && this.accuracyMode == 10) {
            this.geometryAtoms.clear();
            ((GroupRetained)this.armingNode).searchGeometryAtoms(this.geometryAtoms);
        }
    }

    @Override
    void setTriggered() {
        if (this.collidingPath != null) {
            super.setTriggered();
        }
    }

    @Override
    void resetBehaviorCondition(BehaviorStructure bs) {
    }
}

