/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks;

import com.carrotsearch.junitbenchmarks.IResultsConsumer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AutocloseConsumer
implements IResultsConsumer {
    private static List<Closeable> autoclose = new ArrayList<Closeable>();
    private static Thread shutdownAgent;

    protected AutocloseConsumer() {
        AutocloseConsumer.initShutdownAgent();
    }

    protected static synchronized void addAutoclose(Closeable c) {
        autoclose.add(c);
    }

    protected static synchronized void removeAutoclose(Closeable c) {
        try {
            while (autoclose.remove(c)) {
            }
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static synchronized void initShutdownAgent() {
        if (shutdownAgent == null) {
            shutdownAgent = new Thread(){

                @Override
                public void run() {
                    for (Closeable w : new ArrayList(autoclose)) {
                        try {
                            w.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(shutdownAgent);
        }
    }
}

