/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module;

import java.util.List;
import java.util.concurrent.Callable;
import org.scijava.AbstractContextual;
import org.scijava.Cancelable;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.event.ModuleCanceledEvent;
import org.scijava.module.event.ModuleExecutedEvent;
import org.scijava.module.event.ModuleExecutingEvent;
import org.scijava.module.event.ModuleFinishedEvent;
import org.scijava.module.event.ModulePostprocessEvent;
import org.scijava.module.event.ModulePreprocessEvent;
import org.scijava.module.event.ModuleStartedEvent;
import org.scijava.module.process.ModulePostprocessor;
import org.scijava.module.process.ModulePreprocessor;
import org.scijava.plugin.Parameter;

public class ModuleRunner
extends AbstractContextual
implements Callable<Module>,
Runnable {
    private final Module module;
    private final List<? extends ModulePreprocessor> pre;
    private final List<? extends ModulePostprocessor> post;
    @Parameter(required=false)
    private EventService es;
    @Parameter(required=false)
    private StatusService ss;
    @Parameter(required=false)
    private LogService log;

    public ModuleRunner(Context context, Module module, List<? extends ModulePreprocessor> pre, List<? extends ModulePostprocessor> post) {
        this.setContext(context);
        this.module = module;
        this.pre = pre;
        this.post = post;
    }

    public ModulePreprocessor preProcess() {
        if (this.pre == null) {
            return null;
        }
        for (ModulePreprocessor modulePreprocessor : this.pre) {
            modulePreprocessor.process(this.module);
            if (this.es != null) {
                this.es.publish(new ModulePreprocessEvent(this.module, modulePreprocessor));
            }
            if (!modulePreprocessor.isCanceled()) continue;
            return modulePreprocessor;
        }
        return null;
    }

    public void postProcess() {
        if (this.post == null) {
            return;
        }
        for (ModulePostprocessor modulePostprocessor : this.post) {
            modulePostprocessor.process(this.module);
            if (this.es == null) continue;
            this.es.publish(new ModulePostprocessEvent(this.module, modulePostprocessor));
        }
    }

    @Override
    public Module call() {
        try {
            this.run();
        }
        catch (RuntimeException exc) {
            if (this.log != null) {
                this.log.error("Module threw exception", exc);
            }
            throw exc;
        }
        catch (Error err) {
            if (this.log != null) {
                this.log.error("Module threw error", err);
            }
            throw err;
        }
        return this.module;
    }

    @Override
    public void run() {
        Cancelable cancelable;
        ModulePreprocessor canceler;
        if (this.module == null) {
            return;
        }
        String title = this.module.getInfo().getTitle();
        if (this.ss != null) {
            this.ss.showStatus("Running command: " + title);
        }
        if (this.es != null) {
            this.es.publish(new ModuleStartedEvent(this.module));
        }
        if ((canceler = this.preProcess()) != null) {
            this.cancel(title, canceler.getCancelReason());
            return;
        }
        if (this.es != null) {
            this.es.publish(new ModuleExecutingEvent(this.module));
        }
        this.module.run();
        if (this.module instanceof Cancelable && (cancelable = (Cancelable)((Object)this.module)).isCanceled()) {
            this.cancel(title, cancelable.getCancelReason());
            return;
        }
        if (this.es != null) {
            this.es.publish(new ModuleExecutedEvent(this.module));
        }
        this.postProcess();
        if (this.es != null) {
            this.es.publish(new ModuleFinishedEvent(this.module));
        }
        if (this.ss != null) {
            this.ss.showStatus("Command finished: " + title);
        }
    }

    private void cancel(String title, String reason) {
        if (this.ss != null) {
            this.ss.showStatus("Canceling command: " + title);
        }
        this.module.cancel();
        if (this.es != null) {
            this.es.publish(new ModuleCanceledEvent(this.module, reason));
        }
        if (this.ss != null) {
            this.ss.showStatus("Command canceled: " + title);
            if (reason != null) {
                this.ss.warn(reason);
            }
        }
    }
}

