/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui;

import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.ui.UIService;
import org.scijava.widget.AbstractInputHarvester;

public abstract class AbstractInputHarvesterPlugin<P, W>
extends AbstractInputHarvester<P, W>
implements PreprocessorPlugin {
    @Parameter(required=false)
    private UIService uiService;
    private String cancelReason;

    @Override
    public void process(Module module) {
        if (this.uiService == null) {
            return;
        }
        if (!this.uiService.isVisible(this.getUI())) {
            return;
        }
        try {
            this.harvest(module);
        }
        catch (ModuleException e) {
            this.cancel(e.getMessage());
        }
    }

    @Override
    public boolean isCanceled() {
        return this.cancelReason != null;
    }

    @Override
    public void cancel(String reason) {
        this.cancelReason = reason;
    }

    @Override
    public String getCancelReason() {
        return this.cancelReason;
    }

    protected abstract String getUI();
}

