/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.scijava.util.ClassUtils;
import org.scijava.util.FileUtils;

public class TestUtils {
    public static File createTemporaryDirectory(String prefix) throws IOException {
        return TestUtils.createTemporaryDirectory(prefix, TestUtils.getCallingClass(null));
    }

    public static File createTemporaryDirectory(String prefix, Class<?> forClass) throws IOException {
        File baseDirectory;
        File file;
        String path;
        URL directory = ClassUtils.getLocation(forClass);
        if (directory != null && "file".equals(directory.getProtocol()) && (path = directory.getPath()) != null && path.endsWith("/target/test-classes/") && (file = File.createTempFile(prefix, "", baseDirectory = new File(path.substring(0, path.length() - 13)))).delete() && file.mkdir()) {
            return file;
        }
        return FileUtils.createTemporaryDirectory((String)prefix, (String)"");
    }

    public static Class<?> getCallingClass(Class<?> excluding) {
        String thisClassName = TestUtils.class.getName();
        String thisClassName2 = excluding == null ? null : excluding.getName();
        Thread currentThread = Thread.currentThread();
        for (StackTraceElement element : currentThread.getStackTrace()) {
            String thatClassName = element.getClassName();
            if (thatClassName == null || thatClassName.equals(thisClassName) || thatClassName.equals(thisClassName2) || thatClassName.startsWith("java.lang.")) continue;
            ClassLoader loader = currentThread.getContextClassLoader();
            try {
                return loader.loadClass(element.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Could not load " + element.getClassName() + " with the current context class loader (" + loader + ")!");
            }
        }
        throw new UnsupportedOperationException("No calling class outside " + thisClassName + " found!");
    }
}

