/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.scijava.annotations.DirectoryIndexer;
import org.scijava.util.FileUtils;

public class EclipseHelper
extends DirectoryIndexer {
    private static final String FORCE_ANNOTATION_INDEX_PROPERTY = "force.annotation.index";
    static Set<URL> indexed = new HashSet<URL>();
    private boolean bannerShown;
    private static boolean debug = "debug".equals(System.getProperty("scijava.log.level"));
    private boolean autoDetectEclipse = true;

    private static void debug(String message) {
        if (debug) {
            System.err.println(message);
        }
    }

    public static void updateAnnotationIndex(ClassLoader loader) {
        EclipseHelper.debug("Checking class loader: " + loader);
        if (loader == null || !(loader instanceof URLClassLoader)) {
            EclipseHelper.debug("Not an URLClassLoader: " + loader);
            return;
        }
        EclipseHelper helper = new EclipseHelper();
        if (Boolean.getBoolean(FORCE_ANNOTATION_INDEX_PROPERTY)) {
            helper.autoDetectEclipse = false;
        }
        boolean first = true;
        for (URL url : ((URLClassLoader)loader).getURLs()) {
            EclipseHelper.debug("Checking URL: " + url);
            if (helper.autoDetectEclipse && first) {
                if (!"file".equals(url.getProtocol()) || !url.getPath().endsWith("/") && !url.getPath().contains("surefire")) {
                    EclipseHelper.debug("Not Eclipse because first entry is: " + url);
                    return;
                }
                first = false;
            }
            if (url.toString().endsWith("/./")) break;
            helper.maybeIndex(url, loader);
        }
        EclipseHelper.updateAnnotationIndex(loader.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeIndex(URL url, ClassLoader loader) {
        Set<URL> set = indexed;
        synchronized (set) {
            if (indexed.contains(url)) {
                return;
            }
            indexed.add(url);
        }
        if (!"file".equals(url.getProtocol())) {
            EclipseHelper.debug("Not a file URL: " + url);
            return;
        }
        String path = url.getFile();
        if (!path.startsWith("/")) {
            EclipseHelper.debug("Not an absolute file URL: " + url);
            return;
        }
        if (path.endsWith(".jar")) {
            if (!this.autoDetectEclipse || path.matches(".*/target/surefire/surefirebooter[0-9]*\\.jar")) {
                try {
                    String classPath;
                    JarFile jar = new JarFile(path);
                    Manifest manifest = jar.getManifest();
                    if (manifest != null && (classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
                        for (String element : classPath.split(" +")) {
                            try {
                                this.maybeIndex(new URL(url, element), loader);
                            }
                            catch (MalformedURLException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Warning: could not index annotations due to ");
                    e.printStackTrace();
                }
            }
            return;
        }
        File directory = FileUtils.urlToFile(url);
        if (!directory.isDirectory()) {
            return;
        }
        this.index(directory, loader);
    }

    private void index(File directory, ClassLoader loader) {
        EclipseHelper.debug("Directory: " + directory);
        if (!directory.canWrite() || this.upToDate(directory) || this.isIJ1(directory)) {
            EclipseHelper.debug("can write: " + directory.canWrite() + ", up-to-date: " + this.upToDate(directory) + ", : is IJ1: " + this.isIJ1(directory));
            return;
        }
        File jsonDirectory = new File(directory, "META-INF/json/");
        try {
            this.discoverAnnotations(directory, "", loader);
            if (!jsonDirectory.exists() && !this.foundAnnotations()) {
                return;
            }
            if (!this.bannerShown) {
                System.err.println("[ECLIPSE HELPER] Indexing annotations...");
                this.bannerShown = true;
            }
            this.write(directory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (jsonDirectory.isDirectory()) {
            jsonDirectory.setLastModified(System.currentTimeMillis());
        } else {
            jsonDirectory.mkdirs();
        }
    }

    private boolean isIJ1(File directory) {
        return new File(directory, "IJ_Props.txt").exists();
    }

    private boolean upToDate(File directory) {
        File jsonDirectory = new File(directory, "META-INF/json/");
        if (!jsonDirectory.isDirectory()) {
            return false;
        }
        return this.upToDate(directory, jsonDirectory.lastModified());
    }

    private boolean upToDate(File directory, long lastModified) {
        if (directory.lastModified() > lastModified) {
            return false;
        }
        File[] list = directory.listFiles();
        if (list != null) {
            for (File file : list) {
                if (!(file.isFile() ? file.lastModified() > lastModified : file.isDirectory() && !this.upToDate(file, lastModified))) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String ... args) {
        System.setProperty(FORCE_ANNOTATION_INDEX_PROPERTY, "true");
        EclipseHelper.updateAnnotationIndex(Thread.currentThread().getContextClassLoader());
    }
}

