/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public final class Prefs {
    private Prefs() {
    }

    public static String get(String name) {
        return Prefs.get((Class)null, name);
    }

    public static String get(String name, String defaultValue) {
        return Prefs.get(null, name, defaultValue);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        return Prefs.getBoolean(null, name, defaultValue);
    }

    public static double getDouble(String name, double defaultValue) {
        return Prefs.getDouble(null, name, defaultValue);
    }

    public static float getFloat(String name, float defaultValue) {
        return Prefs.getFloat(null, name, defaultValue);
    }

    public static int getInt(String name, int defaultValue) {
        return Prefs.getInt(null, name, defaultValue);
    }

    public static long getLong(String name, long defaultValue) {
        return Prefs.getLong(null, name, defaultValue);
    }

    public static void put(String name, String value) {
        Prefs.put(null, name, value);
    }

    public static void put(String name, boolean value) {
        Prefs.put(null, name, value);
    }

    public static void put(String name, double value) {
        Prefs.put(null, name, value);
    }

    public static void put(String name, float value) {
        Prefs.put(null, name, value);
    }

    public static void put(String name, int value) {
        Prefs.put(null, name, value);
    }

    public static void put(String name, long value) {
        Prefs.put(null, name, value);
    }

    public static String get(Class<?> c, String name) {
        return Prefs.get(c, name, null);
    }

    public static String get(Class<?> c, String name, String defaultValue) {
        return Prefs.prefs(c).get(Prefs.key(c, name), defaultValue);
    }

    public static boolean getBoolean(Class<?> c, String name, boolean defaultValue) {
        return Prefs.prefs(c).getBoolean(Prefs.key(c, name), defaultValue);
    }

    public static double getDouble(Class<?> c, String name, double defaultValue) {
        return Prefs.prefs(c).getDouble(Prefs.key(c, name), defaultValue);
    }

    public static float getFloat(Class<?> c, String name, float defaultValue) {
        return Prefs.prefs(c).getFloat(Prefs.key(c, name), defaultValue);
    }

    public static int getInt(Class<?> c, String name, int defaultValue) {
        return Prefs.prefs(c).getInt(Prefs.key(c, name), defaultValue);
    }

    public static long getLong(Class<?> c, String name, long defaultValue) {
        return Prefs.prefs(c).getLong(Prefs.key(c, name), defaultValue);
    }

    public static void put(Class<?> c, String name, String value) {
        Prefs.prefs(c).put(Prefs.key(c, name), value);
    }

    public static void put(Class<?> c, String name, boolean value) {
        Prefs.prefs(c).putBoolean(Prefs.key(c, name), value);
    }

    public static void put(Class<?> c, String name, double value) {
        Prefs.prefs(c).putDouble(Prefs.key(c, name), value);
    }

    public static void put(Class<?> c, String name, float value) {
        Prefs.prefs(c).putFloat(Prefs.key(c, name), value);
    }

    public static void put(Class<?> c, String name, int value) {
        Prefs.prefs(c).putInt(Prefs.key(c, name), value);
    }

    public static void put(Class<?> c, String name, long value) {
        Prefs.prefs(c).putLong(Prefs.key(c, name), value);
    }

    public static void clear(Class<?> c) {
        try {
            Prefs.prefs(c).clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void clearAll() {
        try {
            String[] childNames;
            for (String name : childNames = Preferences.userRoot().childrenNames()) {
                Preferences.userRoot().node(name).removeNode();
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void clear(String key) {
        Prefs.clear(Prefs.prefs(null), key);
    }

    public static void clear(Preferences preferences, String key) {
        try {
            if (preferences.nodeExists(key)) {
                preferences.node(key).clear();
            }
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    public static void remove(Preferences preferences, String key) {
        try {
            if (preferences.nodeExists(key)) {
                preferences.node(key).removeNode();
            }
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    public static void putMap(Map<String, String> map, String key) {
        Prefs.putMap(Prefs.prefs(null), map, key);
    }

    public static void putMap(Preferences preferences, Map<String, String> map, String key) {
        Prefs.putMap(preferences.node(key), map);
    }

    public static void putMap(Preferences preferences, Map<String, String> map) {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences not set.");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue();
            preferences.put(entry.getKey().toString(), value == null ? null : value.toString());
        }
    }

    public static Map<String, String> getMap(String key) {
        return Prefs.getMap(Prefs.prefs(null), key);
    }

    public static Map<String, String> getMap(Preferences preferences, String key) {
        return Prefs.getMap(preferences.node(key));
    }

    public static Map<String, String> getMap(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences not set.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String[] keys = preferences.keys();
            for (int index = 0; index < keys.length; ++index) {
                map.put(keys[index], preferences.get(keys[index], null));
            }
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
        return map;
    }

    public static void putList(List<String> list, String key) {
        Prefs.putList(Prefs.prefs(null), list, key);
    }

    public static void putList(Preferences preferences, List<String> list, String key) {
        Prefs.putList(preferences.node(key), list);
    }

    public static void putList(Preferences preferences, List<String> list) {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences not set.");
        }
        for (int index = 0; list != null && index < list.size(); ++index) {
            String value = list.get(index);
            preferences.put("" + index, value == null ? null : value.toString());
        }
    }

    public static List<String> getList(String key) {
        return Prefs.getList(Prefs.prefs(null), key);
    }

    public static List<String> getList(Preferences preferences, String key) {
        return Prefs.getList(preferences.node(key));
    }

    public static List<String> getList(Preferences preferences) {
        String value;
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences not set.");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int index = 0; index < 1000 && (value = preferences.get("" + index, null)) != null; ++index) {
            list.add(value);
        }
        return list;
    }

    private static Preferences prefs(Class<?> c) {
        return Preferences.userNodeForPackage(c == null ? Prefs.class : c);
    }

    private static String key(Class<?> c, String name) {
        return c == null ? name : c.getSimpleName() + "." + name;
    }
}

