/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.welcome;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.scijava.app.AppService;
import org.scijava.command.CommandService;
import org.scijava.display.DisplayService;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.text.TextService;
import org.scijava.ui.event.UIShownEvent;
import org.scijava.util.Prefs;
import org.scijava.welcome.WelcomeService;
import org.scijava.welcome.event.WelcomeEvent;

@Plugin(type=Service.class)
public class DefaultWelcomeService
extends AbstractService
implements WelcomeService {
    private static final String WELCOME_FILE = "WELCOME.md";
    private static final String CHECKSUM_PREFS_KEY = "checksum";
    @Parameter
    private LogService log;
    @Parameter
    private AppService appService;
    @Parameter
    private DisplayService displayService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private TextService textService;
    @Parameter
    private EventService eventService;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Override
    public void displayWelcome() {
        this.displayWelcome(true);
    }

    private void displayWelcome(boolean force) {
        File baseDir = this.appService.getApp().getBaseDirectory();
        File welcomeFile = new File(baseDir, WELCOME_FILE);
        try {
            if (welcomeFile.exists()) {
                String welcomeText = this.textService.asHTML(welcomeFile);
                String checksum = this.getChecksum(welcomeText);
                String previousChecksum = Prefs.get(this.getClass(), CHECKSUM_PREFS_KEY);
                if (!force && checksum.equals(previousChecksum)) {
                    return;
                }
                Prefs.put(this.getClass(), CHECKSUM_PREFS_KEY, checksum);
                this.displayService.createDisplay(welcomeText);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public boolean isFirstRun() {
        String firstRun = Prefs.get(this.getClass(), this.firstRunPrefKey());
        return firstRun == null || Boolean.parseBoolean(firstRun);
    }

    @Override
    public void setFirstRun(boolean firstRun) {
        Prefs.put(this.getClass(), this.firstRunPrefKey(), firstRun);
    }

    @EventHandler
    protected void onEvent(UIShownEvent evt) {
        if (!this.isFirstRun()) {
            return;
        }
        this.eventService.publish(new WelcomeEvent());
        this.setFirstRun(false);
        this.displayWelcome(false);
    }

    private String firstRunPrefKey() {
        return "firstRun-" + this.appService.getApp().getVersion();
    }

    private String getChecksum(String text) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(text.getBytes("UTF-8"));
            return this.toHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return "" + text.hashCode();
        }
        catch (UnsupportedEncodingException e) {
            return "" + text.hashCode();
        }
    }

    private String toHex(byte[] bytes) {
        char[] buffer = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            buffer[i * 2] = hex[(bytes[i] & 0xF0) >> 4];
            buffer[i * 2 + 1] = hex[bytes[i] & 0xF];
        }
        return new String(buffer);
    }
}

