/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.scijava.util.ConversionUtils;
import org.scijava.util.MiscUtils;

public final class ClassUtils {
    private ClassUtils() {
    }

    @Deprecated
    public static <T> T convert(Object value, Class<T> type) {
        return ConversionUtils.convert(value, type);
    }

    @Deprecated
    public static boolean canConvert(Class<?> c, Class<?> type) {
        return ConversionUtils.canConvert(c, type);
    }

    @Deprecated
    public static boolean canConvert(Object value, Class<?> type) {
        return ConversionUtils.canConvert(value, type);
    }

    @Deprecated
    public static <T> T cast(Object obj, Class<T> type) {
        return ConversionUtils.cast(obj, type);
    }

    @Deprecated
    public static boolean canCast(Class<?> c, Class<?> type) {
        return ConversionUtils.canCast(c, type);
    }

    @Deprecated
    public static boolean canCast(Object obj, Class<?> type) {
        return ConversionUtils.canCast(obj, type);
    }

    @Deprecated
    public static <T> Class<T> getNonprimitiveType(Class<T> type) {
        return ConversionUtils.getNonprimitiveType(type);
    }

    @Deprecated
    public static <T> T getNullValue(Class<T> type) {
        return ConversionUtils.getNullValue(type);
    }

    public static Class<?> loadClass(String className) {
        return ClassUtils.loadClass(className, null);
    }

    public static Class<?> loadClass(String name, ClassLoader classLoader) {
        if (name.equals("Z") || name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("B") || name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("C") || name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("D") || name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("F") || name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("I") || name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("J") || name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("S") || name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("V") || name.equals("void")) {
            return Void.TYPE;
        }
        String className = name.equals("string") ? "java.lang.String" : name;
        if (name.endsWith("[]")) {
            String elementClassName = name.substring(0, name.length() - 2);
            return ClassUtils.getArrayClass(ClassUtils.loadClass(elementClassName, classLoader));
        }
        if (name.startsWith("[L") && name.endsWith(";")) {
            String elementClassName = name.substring(2, name.length() - 1);
            return ClassUtils.getArrayClass(ClassUtils.loadClass(elementClassName, classLoader));
        }
        if (name.startsWith("[")) {
            String elementClassName = name.substring(1);
            return ClassUtils.getArrayClass(ClassUtils.loadClass(elementClassName, classLoader));
        }
        try {
            ClassLoader cl = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> getArrayClass(Class<?> elementClass) {
        if (elementClass == null) {
            return null;
        }
        try {
            return Array.newInstance(elementClass, 0).getClass();
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public static boolean hasClass(String className) {
        return ClassUtils.hasClass(className, null);
    }

    public static boolean hasClass(String className, ClassLoader classLoader) {
        return ClassUtils.loadClass(className, classLoader) != null;
    }

    public static URL getLocation(String className) {
        return ClassUtils.getLocation(className, null);
    }

    public static URL getLocation(String className, ClassLoader classLoader) {
        Class<?> c = ClassUtils.loadClass(className, classLoader);
        return ClassUtils.getLocation(c);
    }

    public static URL getLocation(Class<?> c) {
        String suffix;
        if (c == null) {
            return null;
        }
        try {
            URL codeSourceLocation = c.getProtectionDomain().getCodeSource().getLocation();
            if (codeSourceLocation != null) {
                return codeSourceLocation;
            }
        }
        catch (SecurityException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        URL classResource = c.getResource(c.getSimpleName() + ".class");
        if (classResource == null) {
            return null;
        }
        String url = classResource.toString();
        if (!url.endsWith(suffix = c.getCanonicalName().replace('.', '/') + ".class")) {
            return null;
        }
        String base = url.substring(0, url.length() - suffix.length());
        String path = base;
        if (path.startsWith("jar:")) {
            path = path.substring(4, path.length() - 2);
        }
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <A extends Annotation> List<Field> getAnnotatedFields(Class<?> c, Class<A> annotationClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassUtils.getAnnotatedFields(c, annotationClass, fields);
        return fields;
    }

    public static <A extends Annotation> void getAnnotatedFields(Class<?> c, Class<A> annotationClass, List<Field> fields) {
        if (c == null) {
            return;
        }
        ClassUtils.getAnnotatedFields(c.getSuperclass(), annotationClass, fields);
        for (Class<?> clazz : c.getInterfaces()) {
            ClassUtils.getAnnotatedFields(clazz, annotationClass, fields);
        }
        for (AnnotatedElement annotatedElement : c.getDeclaredFields()) {
            A ann = ((Field)annotatedElement).getAnnotation(annotationClass);
            if (ann == null) continue;
            fields.add((Field)annotatedElement);
        }
    }

    public static Field getField(String className, String fieldName) {
        return ClassUtils.getField(ClassUtils.loadClass(className), fieldName);
    }

    public static Field getField(Class<?> c, String fieldName) {
        if (c == null) {
            return null;
        }
        try {
            return c.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static List<Class<?>> getTypes(Field field, Class<?> type) {
        Type genericType = ClassUtils.getGenericType(field, type);
        return GenericTypeReflector.getUpperBoundClassAndInterfaces((Type)genericType);
    }

    public static Type getGenericType(Field field, Class<?> type) {
        Type wildType = GenericTypeReflector.addWildcardParameters(type);
        return GenericTypeReflector.getExactFieldType((Field)field, (Type)wildType);
    }

    public static Object getValue(Field field, Object instance) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static void setValue(Field field, Object instance, Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, ConversionUtils.convert(value, field.getGenericType()));
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("No access to field: " + field.getName(), e);
        }
    }

    public static boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || Boolean.class.isAssignableFrom(type);
    }

    public static boolean isByte(Class<?> type) {
        return type == Byte.TYPE || Byte.class.isAssignableFrom(type);
    }

    public static boolean isCharacter(Class<?> type) {
        return type == Character.TYPE || Character.class.isAssignableFrom(type);
    }

    public static boolean isDouble(Class<?> type) {
        return type == Double.TYPE || Double.class.isAssignableFrom(type);
    }

    public static boolean isFloat(Class<?> type) {
        return type == Float.TYPE || Float.class.isAssignableFrom(type);
    }

    public static boolean isInteger(Class<?> type) {
        return type == Integer.TYPE || Integer.class.isAssignableFrom(type);
    }

    public static boolean isLong(Class<?> type) {
        return type == Long.TYPE || Long.class.isAssignableFrom(type);
    }

    public static boolean isShort(Class<?> type) {
        return type == Short.TYPE || Short.class.isAssignableFrom(type);
    }

    public static boolean isNumber(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type == Byte.TYPE || type == Double.TYPE || type == Float.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE;
    }

    public static boolean isText(Class<?> type) {
        return String.class.isAssignableFrom(type) || ClassUtils.isCharacter(type);
    }

    public static int compare(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return 0;
        }
        String name1 = c1 == null ? null : c1.getName();
        String name2 = c2 == null ? null : c2.getName();
        return MiscUtils.compare(name1, name2);
    }
}

