/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.usage;

import java.util.HashMap;
import java.util.Map;
import org.scijava.Identifiable;
import org.scijava.Locatable;
import org.scijava.event.EventHandler;
import org.scijava.module.ModuleInfo;
import org.scijava.module.event.ModuleExecutedEvent;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.usage.UsageService;
import org.scijava.usage.UsageStats;

@Plugin(type=Service.class)
public class DefaultUsageService
extends AbstractService
implements UsageService {
    private HashMap<String, UsageStats> stats = new HashMap();

    @Override
    public Map<String, UsageStats> getStats() {
        return this.stats;
    }

    @Override
    public void clearStats() {
        this.stats = new HashMap();
    }

    @Override
    public UsageStats getUsage(Object o) {
        if (!(o instanceof Identifiable) || !(o instanceof Locatable)) {
            return null;
        }
        String id = ((Identifiable)o).getIdentifier();
        if (!this.stats.containsKey(id)) {
            this.stats.put(id, new UsageStats(o));
        }
        return this.stats.get(id);
    }

    @Override
    public void increment(Object o) {
        UsageStats usageStats = this.getUsage(o);
        if (usageStats == null) {
            return;
        }
        usageStats.increment();
    }

    @EventHandler
    private void onEvent(ModuleExecutedEvent evt) {
        ModuleInfo info = evt.getModule().getInfo();
        this.increment(info);
    }
}

