/*
 * Decompiled with CFR 0.152.
 */
package org.scijava;

import org.scijava.input.Accelerator;

public class MenuEntry {
    public static final double DEFAULT_WEIGHT = Double.POSITIVE_INFINITY;
    private String name;
    private double weight = Double.POSITIVE_INFINITY;
    private char mnemonic;
    private Accelerator accelerator;
    private String iconPath;

    public MenuEntry(String name) {
        this.setName(name);
    }

    public MenuEntry(String name, double weight) {
        this.setName(name);
        this.setWeight(weight);
    }

    public MenuEntry(String name, double weight, char mnemonic, Accelerator acc, String iconPath) {
        this.setName(name);
        this.setWeight(weight);
        this.setMnemonic(mnemonic);
        this.setAccelerator(acc);
        this.setIconPath(iconPath);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setMnemonic(char mnemonic) {
        this.mnemonic = mnemonic;
    }

    public char getMnemonic() {
        return this.mnemonic;
    }

    public void setAccelerator(Accelerator accelerator) {
        this.accelerator = accelerator;
    }

    public Accelerator getAccelerator() {
        return this.accelerator;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void assignProperties(MenuEntry entry) {
        if (this.name == null) {
            this.name = entry.getName();
        }
        if (this.weight == Double.POSITIVE_INFINITY) {
            this.weight = entry.getWeight();
        }
        if (this.mnemonic == '\u0000') {
            this.mnemonic = entry.getMnemonic();
        }
        if (this.accelerator == null) {
            this.accelerator = entry.getAccelerator();
        }
        if (this.iconPath == null) {
            this.iconPath = entry.getIconPath();
        }
    }

    public String toString() {
        return this.name;
    }
}

