/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.util.Map;
import org.scijava.Cancelable;
import org.scijava.Context;
import org.scijava.Contextual;
import org.scijava.InstantiableException;
import org.scijava.NullContextException;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandModuleItem;
import org.scijava.command.Previewable;
import org.scijava.module.AbstractModule;
import org.scijava.module.MethodCallException;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.util.ClassUtils;

public class CommandModule
extends AbstractModule
implements Cancelable,
Contextual {
    private final CommandInfo info;
    private final Command command;
    @Parameter
    private Context context;
    private String cancelReason;

    public CommandModule(CommandInfo info) throws ModuleException {
        this.info = info;
        this.command = this.instantiateCommand();
        this.assignPresets();
    }

    public CommandModule(CommandInfo info, Command command) {
        this.info = info;
        this.command = command;
        this.assignPresets();
    }

    public Command getCommand() {
        return this.command;
    }

    @Override
    public void preview() {
        if (!(this.command instanceof Previewable)) {
            return;
        }
        Previewable previewPlugin = (Previewable)((Object)this.command);
        previewPlugin.preview();
    }

    @Override
    public void cancel() {
        if (!(this.command instanceof Previewable)) {
            return;
        }
        Previewable previewPlugin = (Previewable)((Object)this.command);
        previewPlugin.cancel();
    }

    @Override
    public void initialize() throws MethodCallException {
        this.getContext().inject(this.command);
        super.initialize();
    }

    @Override
    public CommandInfo getInfo() {
        return this.info;
    }

    @Override
    public Object getDelegateObject() {
        return this.command;
    }

    @Override
    public Object getInput(String name) {
        ModuleItem item = this.info.getInput(name);
        return item == null ? null : ClassUtils.getValue(((CommandModuleItem)item).getField(), this.command);
    }

    @Override
    public Object getOutput(String name) {
        ModuleItem item = this.info.getOutput(name);
        return item == null ? null : ClassUtils.getValue(((CommandModuleItem)item).getField(), this.command);
    }

    @Override
    public void setInput(String name, Object value) {
        ModuleItem item = this.info.getInput(name);
        if (item == null) {
            throw new IllegalArgumentException("No such input: " + name);
        }
        ClassUtils.setValue(((CommandModuleItem)item).getField(), this.command, value);
    }

    @Override
    public void setOutput(String name, Object value) {
        ModuleItem item = this.info.getOutput(name);
        if (item == null) {
            throw new IllegalArgumentException("No such output: " + name);
        }
        ClassUtils.setValue(((CommandModuleItem)item).getField(), this.command, value);
    }

    public String toString() {
        return this.command.getClass().getName();
    }

    @Override
    public void run() {
        this.command.run();
    }

    @Override
    public boolean isCanceled() {
        return this.cancelReason != null;
    }

    @Override
    public void cancel(String reason) {
        String string = this.cancelReason = reason == null ? "" : reason;
        if (this.command instanceof Cancelable) {
            ((Cancelable)((Object)this.command)).cancel(reason);
        }
    }

    @Override
    public String getCancelReason() {
        return this.cancelReason;
    }

    @Override
    public Context context() {
        if (this.context == null) {
            throw new NullContextException();
        }
        return this.context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        context.inject(this);
    }

    private Command instantiateCommand() throws ModuleException {
        try {
            return this.info.createInstance();
        }
        catch (InstantiableException exc) {
            throw new ModuleException(exc);
        }
    }

    private void assignPresets() {
        Map<String, Object> presets = this.info.getPresets();
        for (String name : presets.keySet()) {
            Object value = presets.get(name);
            this.setInput(name, value);
            this.setResolved(name, true);
        }
    }
}

