/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.HashMap;
import java.util.List;
import org.scijava.annotations.Index;
import org.scijava.annotations.IndexItem;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginFinder;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.SciJavaPlugin;

public class DefaultPluginFinder
implements PluginFinder {
    private final ClassLoader customClassLoader;

    public DefaultPluginFinder() {
        this(null);
    }

    public DefaultPluginFinder(ClassLoader classLoader) {
        this.customClassLoader = classLoader;
    }

    public HashMap<String, Throwable> findPlugins(List<PluginInfo<?>> plugins) {
        HashMap<String, Throwable> exceptions = new HashMap<String, Throwable>();
        ClassLoader classLoader = this.getClassLoader();
        Index<Plugin> annotationIndex = Index.load(Plugin.class, classLoader);
        for (IndexItem<Plugin> indexItem : annotationIndex) {
            try {
                PluginInfo<SciJavaPlugin> info = this.createInfo(indexItem, classLoader);
                plugins.add(info);
            }
            catch (Throwable t) {
                exceptions.put(indexItem.className(), t);
            }
        }
        return exceptions;
    }

    private PluginInfo<SciJavaPlugin> createInfo(IndexItem<Plugin> item, ClassLoader classLoader) {
        String className = item.className();
        Plugin plugin = item.annotation();
        Class<? extends SciJavaPlugin> pluginType = plugin.type();
        return new PluginInfo<SciJavaPlugin>(className, pluginType, plugin, classLoader);
    }

    private ClassLoader getClassLoader() {
        if (this.customClassLoader != null) {
            return this.customClassLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }
}

