/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngineFactory;
import org.scijava.log.LogService;
import org.scijava.script.AdaptedScriptLanguage;
import org.scijava.script.ScriptLanguage;
import org.scijava.util.FileUtils;

public class ScriptLanguageIndex
extends ArrayList<ScriptLanguage> {
    private static final long serialVersionUID = 1L;
    private final Map<String, ScriptLanguage> byExtension = new HashMap<String, ScriptLanguage>();
    private final Map<String, ScriptLanguage> byName = new HashMap<String, ScriptLanguage>();
    private final LogService log;

    @Deprecated
    public ScriptLanguageIndex() {
        this((LogService)null);
    }

    public ScriptLanguageIndex(LogService logService) {
        this.log = logService;
    }

    public boolean add(ScriptEngineFactory factory, boolean gently) {
        String duplicateName = this.checkDuplicate(factory);
        if (duplicateName != null) {
            if (gently) {
                return false;
            }
            if (this.log != null) {
                this.log.warn("Duplicate scripting language '" + duplicateName + "': existing=" + this.byName.get(duplicateName).getClass().getName() + ", new=" + factory.getClass().getName());
            }
        }
        ScriptLanguage language = this.wrap(factory);
        this.byName.put(language.getLanguageName(), language);
        for (String name : language.getNames()) {
            this.byName.put(name, language);
        }
        for (String extension : language.getExtensions()) {
            if ("".equals(extension)) continue;
            this.byExtension.put(extension, language);
        }
        return super.add(language);
    }

    public ScriptLanguage getByExtension(String extension) {
        return this.byExtension.get(extension);
    }

    public ScriptLanguage getByName(String name) {
        return this.byName.get(name);
    }

    public String[] getFileExtensions(ScriptLanguage language) {
        List<String> extensions = language.getExtensions();
        return extensions.toArray(new String[extensions.size()]);
    }

    public boolean canHandleFile(File file) {
        String extension = FileUtils.getExtension(file);
        if ("".equals(extension)) {
            return false;
        }
        return this.byExtension.containsKey(extension);
    }

    public boolean canHandleFile(String fileName) {
        String extension = FileUtils.getExtension(fileName);
        if ("".equals(extension)) {
            return false;
        }
        return this.byExtension.containsKey(extension);
    }

    @Override
    public boolean add(ScriptLanguage language) {
        return this.add(language, false);
    }

    private String checkDuplicate(ScriptEngineFactory factory) {
        for (String name : factory.getNames()) {
            if (!this.byName.containsKey(name)) continue;
            return name;
        }
        return null;
    }

    private ScriptLanguage wrap(ScriptEngineFactory factory) {
        if (factory instanceof ScriptLanguage) {
            return (ScriptLanguage)factory;
        }
        return new AdaptedScriptLanguage(factory);
    }
}

