/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Collection;
import java.util.Iterator;
import org.scijava.util.AbstractPrimitiveArray;

public class LongArray
extends AbstractPrimitiveArray<long[], Long> {
    private long[] array;

    public LongArray() {
        super(Long.TYPE);
    }

    public LongArray(int size) {
        super(Long.TYPE, size);
    }

    public LongArray(long[] array) {
        super(Long.TYPE, array);
    }

    public void addValue(long value) {
        this.addValue(this.size(), value);
    }

    public boolean removeValue(long value) {
        int index = this.indexOf(value);
        if (index < 0) {
            return false;
        }
        this.delete(index, 1);
        return true;
    }

    public long getValue(int index) {
        this.checkBounds(index);
        return this.array[index];
    }

    public long setValue(int index, long value) {
        this.checkBounds(index);
        long oldValue = this.getValue(index);
        this.array[index] = value;
        return oldValue;
    }

    public void addValue(int index, long value) {
        this.insert(index, 1);
        this.array[index] = value;
    }

    public int indexOf(long value) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long value) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(long value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public long[] getArray() {
        return this.array;
    }

    @Override
    public void setArray(long[] array) {
        if (array.length < this.size()) {
            throw new IllegalArgumentException("Array too small");
        }
        this.array = array;
    }

    @Override
    public Long get(int index) {
        return this.getValue(index);
    }

    @Override
    public Long set(int index, Long element) {
        return this.setValue(index, element == null ? this.defaultValue() : element);
    }

    @Override
    public void add(int index, Long element) {
        this.addValue(index, element);
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Long)) {
            return -1;
        }
        long value = (Long)o;
        return this.indexOf(value);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof Long)) {
            return -1;
        }
        long value = (Long)o;
        return this.lastIndexOf(value);
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Long)) {
            return false;
        }
        long value = (Long)o;
        return this.contains(value);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Long)) {
            return false;
        }
        long value = (Long)o;
        return this.removeValue(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof Long)) {
                return false;
            }
            long value = (Long)o;
            if (this.indexOf(value) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> c) {
        if (c.size() == 0) {
            return false;
        }
        this.insert(index, c.size());
        int i = index;
        Iterator<? extends Long> i$ = c.iterator();
        while (i$.hasNext()) {
            long e = i$.next();
            this.setValue(i++, e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            long value;
            boolean result;
            if (!(o instanceof Long) || !(result = this.removeValue(value = ((Long)o).longValue()))) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public Long defaultValue() {
        return 0L;
    }
}

