/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.viewer;

import org.scijava.display.Display;
import org.scijava.display.event.DisplayActivatedEvent;
import org.scijava.display.event.DisplayCreatedEvent;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.display.event.DisplayUpdatedEvent;
import org.scijava.event.EventHandler;
import org.scijava.plugin.AbstractRichPlugin;
import org.scijava.ui.viewer.DisplayPanel;
import org.scijava.ui.viewer.DisplayViewer;
import org.scijava.ui.viewer.DisplayWindow;

public abstract class AbstractDisplayViewer<T>
extends AbstractRichPlugin
implements DisplayViewer<T> {
    private Display<T> display;
    private DisplayWindow window;
    private DisplayPanel panel;

    @Override
    public void view(DisplayWindow w, Display<?> d) {
        if (!this.canView(d)) {
            throw new IllegalArgumentException("Incompatible display: " + d);
        }
        Display<?> typedDisplay = d;
        this.display = typedDisplay;
        this.window = w;
    }

    @Override
    public Display<T> getDisplay() {
        return this.display;
    }

    @Override
    public DisplayWindow getWindow() {
        return this.window;
    }

    @Override
    public void setPanel(DisplayPanel panel) {
        this.panel = panel;
    }

    @Override
    public DisplayPanel getPanel() {
        return this.panel;
    }

    @Override
    public void onDisplayDeletedEvent(DisplayDeletedEvent e) {
        this.getPanel().getWindow().close();
    }

    @Override
    public void onDisplayUpdatedEvent(DisplayUpdatedEvent e) {
        if (e.getLevel() == DisplayUpdatedEvent.DisplayUpdateLevel.REBUILD) {
            this.getPanel().redoLayout();
        }
        this.getPanel().redraw();
    }

    @Override
    public void onDisplayActivatedEvent(DisplayActivatedEvent e) {
        this.getPanel().getWindow().requestFocus();
    }

    @Override
    public void dispose() {
        DisplayWindow w = this.getWindow();
        if (w != null) {
            w.close();
        }
    }

    protected void updateTitle() {
        String name = this.getDisplay().getName();
        if (name == null) {
            name = "";
        }
        this.getWindow().setTitle(name);
    }

    @EventHandler
    protected void onEvent(DisplayCreatedEvent event) {
        if (event.getObject() != this.getDisplay()) {
            return;
        }
        this.updateTitle();
    }

    @EventHandler
    protected void onEvent(DisplayUpdatedEvent event) {
        if (event.getDisplay() != this.getDisplay()) {
            return;
        }
        this.updateTitle();
    }
}

