/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.Optional;
import org.scijava.module.AbstractModuleItem;
import org.scijava.module.ModuleInfo;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.util.ClassUtils;
import org.scijava.util.ConversionUtils;
import org.scijava.util.NumberUtils;

public class CommandModuleItem<T>
extends AbstractModuleItem<T> {
    private final Field field;

    public CommandModuleItem(ModuleInfo info, Field field) {
        super(info);
        this.field = field;
    }

    public Field getField() {
        return this.field;
    }

    public Parameter getParameter() {
        return this.field.getAnnotation(Parameter.class);
    }

    @Override
    public Class<T> getType() {
        Class<?> type;
        Class<?> typedType = type = ClassUtils.getTypes(this.field, this.getDelegateClass()).get(0);
        return typedType;
    }

    @Override
    public Type getGenericType() {
        return ClassUtils.getGenericType(this.field, this.getDelegateClass());
    }

    @Override
    public ItemIO getIOType() {
        return this.getParameter().type();
    }

    @Override
    public ItemVisibility getVisibility() {
        return this.getParameter().visibility();
    }

    @Override
    public boolean isAutoFill() {
        return this.getParameter().autoFill();
    }

    @Override
    public boolean isRequired() {
        return this.getParameter().required() && !Optional.class.isAssignableFrom(this.getType());
    }

    @Override
    public boolean isPersisted() {
        return this.getParameter().persist();
    }

    @Override
    public String getPersistKey() {
        return this.getParameter().persistKey();
    }

    @Override
    public String getInitializer() {
        return this.getParameter().initializer();
    }

    @Override
    public String getCallback() {
        return this.getParameter().callback();
    }

    @Override
    public String getWidgetStyle() {
        return this.getParameter().style();
    }

    @Override
    public T getMinimumValue() {
        Class<T> saneType = ConversionUtils.getNonprimitiveType(this.getType());
        return ConversionUtils.convert((Object)this.getParameter().min(), saneType);
    }

    @Override
    public T getMaximumValue() {
        Class<T> saneType = ConversionUtils.getNonprimitiveType(this.getType());
        return ConversionUtils.convert((Object)this.getParameter().max(), saneType);
    }

    @Override
    public Number getStepSize() {
        Class<T> saneType = ConversionUtils.getNonprimitiveType(this.getType());
        return NumberUtils.toNumber(this.getParameter().stepSize(), saneType);
    }

    @Override
    public int getColumnCount() {
        return this.getParameter().columns();
    }

    @Override
    public List<T> getChoices() {
        ArrayList<T> choices = new ArrayList<T>();
        for (String choice : this.getParameter().choices()) {
            choices.add(ConversionUtils.convert((Object)choice, this.getType()));
        }
        return choices;
    }

    @Override
    public String getLabel() {
        return this.getParameter().label();
    }

    @Override
    public String getDescription() {
        return this.getParameter().description();
    }

    @Override
    public boolean is(String key) {
        for (Attr attr : this.getParameter().attrs()) {
            if (!attr.name().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String get(String key) {
        for (Attr attr : this.getParameter().attrs()) {
            if (!attr.name().equals(key)) continue;
            return attr.value();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }
}

