/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

public final class UnitUtils {
    private static final String[] BYTE_UNITS = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};
    private static final double LOG1024 = Math.log(1024.0);

    private UnitUtils() {
    }

    public static String getAbbreviatedByteLabel(double totBytes) {
        if (totBytes < 0.0) {
            throw new IllegalArgumentException("Bytes must be non-negative");
        }
        if (totBytes == 0.0) {
            return "0B";
        }
        int rawPow = (int)(Math.log(totBytes) / LOG1024);
        int pow = Math.min(rawPow, BYTE_UNITS.length - 1);
        double value = totBytes / Math.pow(1024.0, pow);
        String format = pow == 0 ? "%.0f%s" : "%.1f%s";
        return String.format(format, value, BYTE_UNITS[pow]);
    }
}

