/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import org.scijava.prefs.PrefService;
import org.scijava.util.LastRecentlyUsed;

class History {
    protected static final long serialVersionUID = 1L;
    private static final String PREFIX = "History.";
    private final int MAX_ENTRIES = 1000;
    private final PrefService prefs;
    private final String name;
    private final LastRecentlyUsed<String> entries = new LastRecentlyUsed(1000);
    private String currentCommand = "";
    private int position = -1;

    public History(PrefService prefs, String name) {
        this.prefs = prefs;
        this.name = name;
    }

    public void read() {
        this.entries.clear();
        for (String item : this.prefs.getIterable(this.getClass(), PREFIX + this.name)) {
            this.entries.addToEnd(item);
        }
    }

    public void write() {
        this.prefs.putIterable(this.getClass(), this.entries, PREFIX + this.name);
    }

    public void add(String command) {
        this.entries.add(command);
        this.position = -1;
        this.currentCommand = "";
    }

    public boolean replace(String currentCommand) {
        if (this.position < 0) {
            this.currentCommand = currentCommand;
            return false;
        }
        return this.entries.replace(this.position, currentCommand);
    }

    public String next() {
        this.position = this.entries.next(this.position);
        return this.position < 0 ? this.currentCommand : this.entries.get(this.position);
    }

    public String previous() {
        this.position = this.entries.previous(this.position);
        return this.position < 0 ? this.currentCommand : this.entries.get(this.position);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int position = -1;
        while ((position = this.entries.previous(position)) >= 0) {
            if (builder.length() > 0) {
                builder.append(" -> ");
            }
            if (this.position == position) {
                builder.append("[");
            }
            builder.append(this.entries.get(position));
            if (this.position != position) continue;
            builder.append("]");
        }
        return builder.toString();
    }
}

