/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Collection;
import java.util.Iterator;
import org.scijava.util.AbstractPrimitiveArray;

public class BoolArray
extends AbstractPrimitiveArray<boolean[], Boolean> {
    private boolean[] array;

    public BoolArray() {
        super(Boolean.TYPE);
    }

    public BoolArray(int size) {
        super(Boolean.TYPE, size);
    }

    public BoolArray(boolean[] array) {
        super(Boolean.TYPE, array);
    }

    public void addValue(boolean value) {
        this.addValue(this.size(), value);
    }

    public boolean removeValue(boolean value) {
        int index = this.indexOf(value);
        if (index < 0) {
            return false;
        }
        this.delete(index, 1);
        return true;
    }

    public boolean getValue(int index) {
        this.checkBounds(index);
        return this.array[index];
    }

    public boolean setValue(int index, boolean value) {
        this.checkBounds(index);
        boolean oldValue = this.getValue(index);
        this.array[index] = value;
        return oldValue;
    }

    public void addValue(int index, boolean value) {
        this.insert(index, 1);
        this.array[index] = value;
    }

    public int indexOf(boolean value) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(boolean value) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(boolean value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public boolean[] getArray() {
        return this.array;
    }

    @Override
    public void setArray(boolean[] array) {
        if (array.length < this.size()) {
            throw new IllegalArgumentException("Array too small");
        }
        this.array = array;
    }

    @Override
    public Boolean get(int index) {
        return this.getValue(index);
    }

    @Override
    public Boolean set(int index, Boolean element) {
        return this.setValue(index, element == null ? this.defaultValue() : element);
    }

    @Override
    public void add(int index, Boolean element) {
        this.addValue(index, element);
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Boolean)) {
            return -1;
        }
        boolean value = (Boolean)o;
        return this.indexOf(value);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof Boolean)) {
            return -1;
        }
        boolean value = (Boolean)o;
        return this.lastIndexOf(value);
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Boolean)) {
            return false;
        }
        boolean value = (Boolean)o;
        return this.contains(value);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Boolean)) {
            return false;
        }
        boolean value = (Boolean)o;
        return this.removeValue(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof Boolean)) {
                return false;
            }
            boolean value = (Boolean)o;
            if (this.indexOf(value) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Boolean> c) {
        if (c.size() == 0) {
            return false;
        }
        this.insert(index, c.size());
        int i = index;
        Iterator<? extends Boolean> i$ = c.iterator();
        while (i$.hasNext()) {
            boolean e = i$.next();
            this.setValue(i++, e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            boolean value;
            boolean result;
            if (!(o instanceof Boolean) || !(result = this.removeValue(value = ((Boolean)o).booleanValue()))) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public Boolean defaultValue() {
        return false;
    }
}

