/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.DoubleArray;
import org.scijava.util.PrimitiveArray;
import org.scijava.util.PrimitiveArrayTest;

public class DoubleArrayTest
extends PrimitiveArrayTest {
    @Test
    public void testConstructorNoArgs() {
        DoubleArray array = new DoubleArray();
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)((double[])array.copyArray()).length);
    }

    @Test
    public void testConstructorSize() {
        int size = 24;
        DoubleArray array = new DoubleArray(24);
        Assert.assertEquals((long)24L, (long)array.size());
        Assert.assertEquals((long)24L, (long)((double[])array.copyArray()).length);
    }

    @Test
    public void testConstructorArray() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
        Assert.assertEquals((long)raw.length, (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (double)raw[i], (double)array.getValue(i), (double)0.0);
        }
        Assert.assertArrayEquals((double[])raw, (double[])((double[])array.copyArray()), (double)0.0);
    }

    @Test
    public void testAddValue() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        double e6 = 1.1f;
        double e7 = 2.2f;
        array.addValue((double)1.1f);
        array.addValue((double)2.2f);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (double)raw[i], (double)array.getValue(i), (double)0.0);
        }
        Assert.assertEquals((double)1.1f, (double)array.getValue(5), (double)0.0);
        Assert.assertEquals((double)2.2f, (double)array.getValue(6), (double)0.0);
    }

    public void testRemoveValue() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeValue(raw[0]);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.removeValue(raw[2]);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.removeValue(raw[4]);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((double)raw[1], (double)array.getValue(0), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(1), (double)0.0);
    }

    public void testGetValue() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (double)raw[i], (double)array.getValue(i), (double)0.0);
        }
    }

    @Test
    public void testSetValue() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        double e0 = 7.7f;
        double e2 = 1.1f;
        double e4 = 2.2f;
        array.setValue(0, (double)7.7f);
        array.setValue(2, (double)1.1f);
        array.setValue(4, (double)2.2f);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((double)7.7f, (double)array.getValue(0), (double)0.0);
        Assert.assertEquals((double)raw[1], (double)array.getValue(1), (double)0.0);
        Assert.assertEquals((double)1.1f, (double)array.getValue(2), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(3), (double)0.0);
        Assert.assertEquals((double)2.2f, (double)array.getValue(4), (double)0.0);
    }

    @Test
    public void testAddValueIndex() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        double e0 = 7.7f;
        double e4 = 1.1f;
        double e7 = 2.2f;
        array.addValue(0, (double)7.7f);
        array.addValue(4, (double)1.1f);
        array.addValue(7, (double)2.2f);
        Assert.assertEquals((long)(raw.length + 3), (long)array.size());
        Assert.assertEquals((double)7.7f, (double)array.getValue(0), (double)0.0);
        Assert.assertEquals((double)raw[0], (double)array.getValue(1), (double)0.0);
        Assert.assertEquals((double)raw[1], (double)array.getValue(2), (double)0.0);
        Assert.assertEquals((double)raw[2], (double)array.getValue(3), (double)0.0);
        Assert.assertEquals((double)1.1f, (double)array.getValue(4), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(5), (double)0.0);
        Assert.assertEquals((double)raw[4], (double)array.getValue(6), (double)0.0);
        Assert.assertEquals((double)2.2f, (double)array.getValue(7), (double)0.0);
    }

    public void testRemoveIndex() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove(0);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove(2);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove(4);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((double)raw[1], (double)array.getValue(0), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(1), (double)0.0);
    }

    @Test
    public void testIndexOf() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf(-1.0));
        Assert.assertEquals((long)-1L, (long)array.indexOf(0.0));
        Assert.assertEquals((long)-1L, (long)array.indexOf(1.0));
        Assert.assertEquals((long)-1L, (long)array.indexOf(Double.NaN));
        Assert.assertEquals((long)-1L, (long)array.indexOf(Double.POSITIVE_INFINITY));
        Assert.assertEquals((long)-1L, (long)array.indexOf(Double.NEGATIVE_INFINITY));
    }

    @Test
    public void testLastIndexOf() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(-1.0));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(0.0));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(1.0));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(Double.NaN));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(Double.POSITIVE_INFINITY));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(Double.NEGATIVE_INFINITY));
    }

    @Test
    public void testContains() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains(raw[i]));
        }
        Assert.assertFalse((boolean)array.contains(-1.0));
        Assert.assertFalse((boolean)array.contains(0.0));
        Assert.assertFalse((boolean)array.contains(1.0));
        Assert.assertFalse((boolean)array.contains(Double.NaN));
        Assert.assertFalse((boolean)array.contains(Double.POSITIVE_INFINITY));
        Assert.assertFalse((boolean)array.contains(Double.NEGATIVE_INFINITY));
    }

    @Test
    public void testSetArray() {
        DoubleArray array = new DoubleArray();
        double[] raw = new double[]{1.0, 2.0, 3.0, 5.0, 8.0, 13.0, 21.0};
        array.setArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
    }

    @Test
    public void testInsert() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        this.testInsert((PrimitiveArray<?, ?>)new DoubleArray(raw));
    }

    @Test
    public void testDelete() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        this.testDelete((PrimitiveArray<?, ?>)new DoubleArray(raw));
    }

    @Test
    public void testGet() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (double)raw[i], (double)array.get(i), (double)0.0);
        }
    }

    @Test
    public void testSet() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        Double e0 = 7.7;
        Double e2 = 1.1;
        Double e4 = 2.2;
        array.set(0, e0);
        array.set(2, e2);
        array.set(4, e4);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((double)e0, (double)array.get(0), (double)0.0);
        Assert.assertEquals((double)raw[1], (double)array.getValue(1), (double)0.0);
        Assert.assertEquals((double)e2, (double)array.get(2), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(3), (double)0.0);
        Assert.assertEquals((double)e4, (double)array.get(4), (double)0.0);
    }

    @Test
    public void testAdd() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        Double e6 = 1.1;
        Double e7 = 2.2;
        array.add((Object)e6);
        array.add((Object)e7);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (double)raw[i], (double)array.getValue(i), (double)0.0);
        }
        Assert.assertEquals((double)e6, (double)array.get(5), (double)0.0);
        Assert.assertEquals((double)e7, (double)array.get(6), (double)0.0);
    }

    @Test
    public void testIndexOfBoxed() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf((Object)new Double(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Double(-1.0)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Double(0.0)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Double(1.0)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Double(Double.NaN)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Double(Double.POSITIVE_INFINITY)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Double(Double.NEGATIVE_INFINITY)));
        Assert.assertEquals((long)-1L, (long)array.indexOf(null));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)"Not a double"));
    }

    @Test
    public void testLastIndexOfBoxed() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf((Object)new Double(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Double(-1.0)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Double(0.0)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Double(1.0)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Double(Double.NaN)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Double(Double.POSITIVE_INFINITY)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Double(Double.NEGATIVE_INFINITY)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(null));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)"Not a double"));
    }

    @Test
    public void testContainsBoxed() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains((Object)new Double(raw[i])));
        }
        Assert.assertFalse((boolean)array.contains((Object)new Double(-1.0)));
        Assert.assertFalse((boolean)array.contains((Object)new Double(0.0)));
        Assert.assertFalse((boolean)array.contains((Object)new Double(1.0)));
        Assert.assertFalse((boolean)array.contains((Object)new Double(Double.NaN)));
        Assert.assertFalse((boolean)array.contains((Object)new Double(Double.POSITIVE_INFINITY)));
        Assert.assertFalse((boolean)array.contains((Object)new Double(Double.NEGATIVE_INFINITY)));
        Assert.assertFalse((boolean)array.contains(null));
        Assert.assertFalse((boolean)array.contains((Object)"Not a double"));
    }

    @Test
    public void testRemove() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove((Object)new Double(raw[0]));
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove((Object)new Double(raw[2]));
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove((Object)new Double(raw[4]));
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((double)raw[1], (double)array.getValue(0), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(1), (double)0.0);
    }

    @Test
    public void testContainsAll() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        ArrayList<Double> list = new ArrayList<Double>();
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(13.0);
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(1.0);
        Assert.assertFalse((boolean)array.containsAll(list));
        DoubleArray yes = new DoubleArray(new double[]{3.0, 8.0, 21.0});
        Assert.assertTrue((boolean)array.containsAll((Collection)yes));
        DoubleArray no = new DoubleArray(new double[]{5.0, 13.0, 1.0});
        Assert.assertFalse((boolean)array.containsAll((Collection)no));
    }

    @Test
    public void testAddAll() {
        int i;
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        double[] add = new double[]{1.1f, 7.7f};
        DoubleArray toAdd = new DoubleArray((double[])add.clone());
        int index = 3;
        array.addAll(3, (Collection)toAdd);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((double)raw[i], (double)array.getValue(i), (double)0.0);
        }
        for (i = 3; i < 3 + add.length; ++i) {
            Assert.assertEquals((double)add[i - 3], (double)array.getValue(i), (double)0.0);
        }
        for (i = 3 + add.length; i < raw.length + add.length; ++i) {
            Assert.assertEquals((double)raw[i - add.length], (double)array.getValue(i), (double)0.0);
        }
    }

    @Test
    public void testRemoveAll() {
        double[] raw = new double[]{3.0, 5.0, 8.0, 13.0, 21.0};
        DoubleArray array = new DoubleArray((double[])raw.clone());
        DoubleArray toRemove = new DoubleArray(new double[]{3.0, 8.0, 21.0});
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeAll((Collection)toRemove);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((double)raw[1], (double)array.getValue(0), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(1), (double)0.0);
    }
}

