/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.util.Collections;
import java.util.List;
import org.scijava.plugin.AbstractRichPlugin;
import org.scijava.script.ScriptLanguage;
import org.scijava.util.VersionUtils;

public abstract class AbstractScriptLanguage
extends AbstractRichPlugin
implements ScriptLanguage {
    @Override
    public String toString() {
        return this.getLanguageName();
    }

    @Override
    public boolean isCompiledLanguage() {
        return false;
    }

    @Override
    public Object decode(Object object) {
        return object;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getProgram(String ... statements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getExtensions() {
        return Collections.emptyList();
    }

    @Override
    public String getEngineName() {
        return this.inferNameFromClassName();
    }

    @Override
    public String getLanguageName() {
        String name = this.getInfo().getName();
        return name != null && !name.isEmpty() ? name : this.inferNameFromClassName();
    }

    @Override
    public List<String> getNames() {
        return Collections.singletonList(this.getEngineName());
    }

    @Override
    public String getLanguageVersion() {
        return VersionUtils.getVersion(this.getClass());
    }

    @Override
    public List<String> getMimeTypes() {
        return Collections.emptyList();
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.name")) {
            List<String> list = this.getNames();
            return list.size() > 0 ? list.get(0) : null;
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        return null;
    }

    @Override
    public String getEngineVersion() {
        return "0.0";
    }

    private String inferNameFromClassName() {
        String className = this.getClass().getSimpleName();
        if (className.endsWith("ScriptLanguage")) {
            className = className.substring(0, className.length() - 14);
        }
        className = className.replace('_', ' ');
        return className;
    }
}

