/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module.process;

import org.scijava.Context;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=PreprocessorPlugin.class, priority=10000.0)
public class ServicePreprocessor
extends AbstractPreprocessorPlugin {
    @Override
    public void process(Module module) {
        for (ModuleItem<?> input : module.getInfo().inputs()) {
            if (!input.isAutoFill()) continue;
            Class<?> type = input.getType();
            if (Service.class.isAssignableFrom(type)) {
                ModuleItem<?> serviceInput = input;
                this.setServiceValue(this.getContext(), module, serviceInput);
            }
            if (!type.isAssignableFrom(this.getContext().getClass())) continue;
            String name = input.getName();
            module.setInput(name, this.getContext());
            module.setResolved(name, true);
        }
    }

    private <S extends Service> void setServiceValue(Context context, Module module, ModuleItem<S> input) {
        S service = context.getService(input.getType());
        input.setValue(module, service);
        module.setResolved(input.getName(), true);
    }
}

