/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.log.LogService;
import org.scijava.object.LazyObjects;
import org.scijava.object.ObjectService;
import org.scijava.plugin.AbstractPTService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.SingletonPlugin;
import org.scijava.plugin.SingletonService;

public abstract class AbstractSingletonService<PT extends SingletonPlugin>
extends AbstractPTService<PT>
implements SingletonService<PT> {
    @Parameter
    private LogService log;
    @Parameter
    private ObjectService objectService;
    private List<PT> instances;
    private Map<Class<? extends PT>, PT> instanceMap;

    @Override
    public List<PT> getInstances() {
        if (this.instances == null) {
            this.initInstances();
        }
        return this.instances;
    }

    @Override
    public <P extends PT> P getInstance(Class<P> pluginClass) {
        if (this.instanceMap == null) {
            this.initInstances();
        }
        return (P)((SingletonPlugin)this.instanceMap.get(pluginClass));
    }

    @Override
    public <P extends PT> P create(Class<P> pluginClass) {
        throw new UnsupportedOperationException("Cannot create singleton plugin instance. Use getInstance(Class) instead.");
    }

    @Override
    public void initialize() {
        this.objectService.getIndex().addLater(new LazyObjects<Object>(){

            @Override
            public ArrayList<Object> get() {
                return new ArrayList<Object>(AbstractSingletonService.this.getInstances());
            }
        });
    }

    protected List<? extends PT> filterInstances(List<PT> list) {
        return list;
    }

    private synchronized void initInstances() {
        if (this.instances != null) {
            return;
        }
        List<SingletonPlugin> list = Collections.unmodifiableList(this.filterInstances(this.getPluginService().createInstancesOfType(this.getPluginType())));
        HashMap<Class<PT>, PT> map = new HashMap<Class<PT>, PT>();
        for (SingletonPlugin plugin : list) {
            Class<?> ptClass = plugin.getClass();
            map.put(ptClass, plugin);
        }
        this.log.debug("Found " + list.size() + " " + this.getPluginType().getSimpleName() + " plugins.");
        this.instanceMap = map;
        this.instances = list;
    }
}

