/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.plugin.Plugin;
import org.scijava.util.BoolArray;
import org.scijava.util.CharArray;
import org.scijava.util.ClassUtils;
import org.scijava.util.DoubleArray;
import org.scijava.util.FloatArray;
import org.scijava.util.IntArray;
import org.scijava.util.LongArray;
import org.scijava.util.ShortArray;

public class ConvertServiceTest {
    private ConvertService convertService;

    @Before
    public void setUp() {
        Context context = new Context(new Class[]{ConvertService.class});
        this.convertService = (ConvertService)context.getService(ConvertService.class);
    }

    @After
    public void tearDown() {
        this.convertService.getContext().dispose();
    }

    @Test
    public void testNull() {
        Assert.assertTrue((boolean)this.convertService.supports(null, Object.class));
        Assert.assertTrue((boolean)this.convertService.supports((Class)null, Object.class));
        Assert.assertTrue((boolean)this.convertService.supports(Object.class, (Class)null));
        Assert.assertTrue((boolean)this.convertService.supports(Object.class, (Type)null));
        Assert.assertTrue((boolean)this.convertService.supports(new Object(), (Class)null));
        Assert.assertTrue((boolean)this.convertService.supports(new Object(), (Type)null));
        Assert.assertTrue((boolean)this.convertService.supports((Object)new ConversionRequest(null, Object.class)));
        Assert.assertTrue((boolean)this.convertService.supports((Object)new ConversionRequest((Type)null, Object.class)));
        Assert.assertTrue((boolean)this.convertService.supports((Object)new ConversionRequest(Object.class, (Type)null)));
        Assert.assertTrue((boolean)this.convertService.supports((Object)new ConversionRequest(Object.class, (Type)null)));
        Assert.assertTrue((boolean)this.convertService.supports((Object)new ConversionRequest(new Object(), (Type)null)));
        Assert.assertTrue((boolean)this.convertService.supports((Object)new ConversionRequest(new Object(), (Type)null)));
        Assert.assertNull((Object)this.convertService.convert(null, Object.class));
        Assert.assertNull((Object)this.convertService.convert((Object)null, Object.class));
        Assert.assertNull((Object)this.convertService.convert(Object.class, (Class)null));
        Assert.assertNull((Object)this.convertService.convert(Object.class, (Type)null));
        Assert.assertNull((Object)this.convertService.convert(new Object(), (Class)null));
        Assert.assertNull((Object)this.convertService.convert(new Object(), (Type)null));
        Assert.assertNull((Object)this.convertService.convert(new ConversionRequest(null, Object.class)));
        Assert.assertNull((Object)this.convertService.convert(new ConversionRequest((Type)null, Object.class)));
        Assert.assertNull((Object)this.convertService.convert(new ConversionRequest(Object.class, (Type)null)));
        Assert.assertNull((Object)this.convertService.convert(new ConversionRequest(Object.class, (Type)null)));
        Assert.assertNull((Object)this.convertService.convert(new ConversionRequest(new Object(), (Type)null)));
        Assert.assertNull((Object)this.convertService.convert(new ConversionRequest(new Object(), (Type)null)));
    }

    @Test
    public void testPrimitives() {
        Assert.assertTrue((1.0 == (Double)this.convertService.convert((Object)1, Double.TYPE) ? 1 : 0) != 0);
        Assert.assertTrue((1.0 == (Double)this.convertService.convert((Object)1L, Double.TYPE) ? 1 : 0) != 0);
        Assert.assertTrue((1.0 == (Double)this.convertService.convert((Object)Float.valueOf(1.0f), Double.TYPE) ? 1 : 0) != 0);
        Assert.assertTrue((1.0 == (Double)this.convertService.convert((Object)1, Double.TYPE) ? 1 : 0) != 0);
        Assert.assertTrue((1.0 == (Double)this.convertService.convert((Object)1.0, Double.TYPE) ? 1 : 0) != 0);
    }

    @Test
    public void testArrays() {
        this.testIntechangeable(int[].class, IntArray.class);
        this.testIntechangeable(long[].class, LongArray.class);
        this.testIntechangeable(double[].class, DoubleArray.class);
        this.testIntechangeable(float[].class, FloatArray.class);
        this.testIntechangeable(short[].class, ShortArray.class);
        this.testIntechangeable(char[].class, CharArray.class);
        this.testIntechangeable(boolean[].class, BoolArray.class);
        Assert.assertFalse((boolean)this.convertService.supports(int[].class, LongArray.class));
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 100; ++i) {
            list.add((int)(10000.0 * Math.random()));
        }
        Assert.assertTrue((boolean)this.convertService.supports(list, int[].class));
        Assert.assertTrue((boolean)this.convertService.supports(list, long[].class));
        Assert.assertTrue((boolean)this.convertService.supports(list, double[].class));
        Assert.assertTrue((boolean)this.convertService.supports(list, float[].class));
        Assert.assertTrue((boolean)this.convertService.supports(list, short[].class));
        Assert.assertTrue((boolean)this.convertService.supports(list, char[].class));
        Assert.assertTrue((boolean)this.convertService.supports(list, boolean[].class));
        int[] primitives = (int[])this.convertService.convert(list, int[].class);
        IntArray intArray = (IntArray)this.convertService.convert((Object)primitives, IntArray.class);
        Assert.assertTrue((primitives == this.convertService.convert((Object)intArray, int[].class) ? 1 : 0) != 0);
        for (int i = 0; i < list.size(); ++i) {
            Assert.assertTrue(((Integer)list.get(i) == primitives[i] ? 1 : 0) != 0);
            Assert.assertTrue((((Integer)list.get(i)).intValue() == intArray.getValue(i) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCanConvert() {
        Assert.assertTrue((boolean)this.convertService.supports(String.class, Object.class));
        Assert.assertTrue((boolean)this.convertService.supports(ArrayList.class, Collection.class));
        Assert.assertTrue((boolean)this.convertService.supports(Double.TYPE, Float.TYPE));
        Assert.assertTrue((boolean)this.convertService.supports(Float.TYPE, Double.TYPE));
        Assert.assertTrue((boolean)this.convertService.supports(Integer.TYPE, Number.class));
        Assert.assertTrue((boolean)this.convertService.supports(Integer.class, Double.TYPE));
        Assert.assertTrue((boolean)this.convertService.supports(Object.class, String.class));
        Assert.assertTrue((boolean)this.convertService.supports(String.class, Character.TYPE));
        Assert.assertTrue((boolean)this.convertService.supports(String.class, Character.class));
        Assert.assertTrue((boolean)this.convertService.supports(String.class, Words.class));
        Assert.assertTrue((boolean)this.convertService.supports(String.class, Double.class));
        Assert.assertTrue((boolean)this.convertService.supports(Collection.class, ArrayList.class));
        Assert.assertTrue((boolean)this.convertService.supports(HashSet.class, ArrayList.class));
        Assert.assertTrue((boolean)this.convertService.supports(Long.TYPE, Date.class));
        Assert.assertFalse((boolean)this.convertService.supports(Collection.class, List.class));
        Assert.assertFalse((boolean)this.convertService.supports(Integer.TYPE, Date.class));
    }

    public void testConvert() {
        String string = "Hello";
        Object stringToObject = this.convertService.convert((Object)"Hello", Object.class);
        Assert.assertSame((Object)"Hello", (Object)stringToObject);
        ArrayList arrayList = new ArrayList();
        Collection arrayListToCollection = (Collection)this.convertService.convert(arrayList, Collection.class);
        Assert.assertSame(arrayList, (Object)arrayListToCollection);
        Words fubar = (Words)((Object)this.convertService.convert((Object)"FUBAR", Words.class));
        Assert.assertSame((Object)((Object)Words.FUBAR), (Object)((Object)fubar));
        Words noConstant = (Words)((Object)this.convertService.convert((Object)"NONE", Words.class));
        Assert.assertNull((Object)((Object)noConstant));
        double d = 5.1;
        float doubleToFloat = ((Float)this.convertService.convert((Object)5.1, Float.TYPE)).floatValue();
        Assert.assertTrue((5.1f == doubleToFloat ? 1 : 0) != 0);
        float f = 6.2f;
        double floatToDouble = (Double)this.convertService.convert(Float.TYPE, Double.TYPE);
        Assert.assertEquals((double)6.2f, (double)floatToDouble, (double)0.0);
        Number intToNumber = (Number)this.convertService.convert((Object)5, Number.class);
        Assert.assertSame(Integer.class, intToNumber.getClass());
        Assert.assertEquals((long)5L, (long)intToNumber.intValue());
        Object object = new Object();
        String objectToString = (String)this.convertService.convert(object, String.class);
        Assert.assertEquals((Object)object.toString(), (Object)objectToString);
        String name = "Houdini";
        char c = ((Character)this.convertService.convert((Object)"Houdini", Character.TYPE)).charValue();
        Assert.assertTrue(("Houdini".charAt(0) == c ? 1 : 0) != 0);
        String ns = "8.7";
        double stringToDouble = (Double)this.convertService.convert((Object)"8.7", Double.class);
        Assert.assertEquals((double)8.7, (double)stringToDouble, (double)0.0);
        HashSet<String> set = new HashSet<String>();
        set.add("Foo");
        set.add("Bar");
        ArrayList setToArrayList = (ArrayList)this.convertService.convert(set, ArrayList.class);
        Assert.assertEquals((long)2L, (long)setToArrayList.size());
        Collections.sort(setToArrayList);
        Assert.assertEquals((Object)"Bar", setToArrayList.get(0));
        Assert.assertEquals((Object)"Foo", setToArrayList.get(1));
        Date date = new Date();
        long datestamp = date.getTime();
        Date longToDate = (Date)this.convertService.convert((Object)datestamp, Date.class);
        Assert.assertEquals((Object)date, (Object)longToDate);
        List setToList = (List)this.convertService.convert(set, List.class);
        Assert.assertNull((Object)setToList);
        int intStamp = (int)datestamp;
        Date intToDate = (Date)this.convertService.convert((Object)intStamp, Date.class);
        Assert.assertNull((Object)intToDate);
    }

    @Test
    public void testConvertSubclass() {
        HisList hisList = new HisList();
        hisList.add("Foo");
        hisList.add("Bar");
        HerList herList = (HerList)this.convertService.convert((Object)hisList, HerList.class);
        Assert.assertEquals((long)2L, (long)herList.size());
        Assert.assertEquals((Object)"Foo", herList.get(0));
        Assert.assertEquals((Object)"Bar", herList.get(1));
        ObjectList objectList = (ObjectList)this.convertService.convert((Object)hisList, ObjectList.class);
        Assert.assertEquals((long)2L, (long)objectList.size());
        Assert.assertEquals((Object)"Foo", objectList.get(0));
        Assert.assertEquals((Object)"Bar", objectList.get(1));
        HisList objectToHisList = (HisList)this.convertService.convert((Object)objectList, HisList.class);
        Assert.assertEquals((long)2L, (long)objectToHisList.size());
        Assert.assertEquals((Object)"Foo", objectToHisList.get(0));
        Assert.assertEquals((Object)"Bar", objectToHisList.get(1));
        NumberList hisToNumberList = (NumberList)this.convertService.convert((Object)hisList, NumberList.class);
        Assert.assertEquals((long)2L, (long)hisToNumberList.size());
        Assert.assertEquals((Object)"Foo", hisToNumberList.get(0));
        Assert.assertEquals((Object)"Bar", hisToNumberList.get(1));
        try {
            Number n0 = (Number)hisToNumberList.get(0);
            Assert.fail((String)("expected ClassCastException but got: " + n0));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testConvertTypeCasting() {
        class Struct {
            private INumberList iNumberList;
            private List<String> list;

            Struct() {
            }
        }
        Struct struct = new Struct();
        NumberList numberList = new NumberList();
        numberList.add(5);
        this.setFieldValue(struct, "iNumberList", numberList);
        Assert.assertSame((Object)numberList, (Object)struct.iNumberList);
        this.setFieldValue(struct, "list", numberList);
        Assert.assertSame((Object)numberList, (Object)struct.list);
    }

    @Test
    public void testToCollectionSubclass() {
        class Struct {
            private ListExtension<Double> myDoubles;
            private StringListExtension myStrings;

            Struct() {
            }
        }
        Struct struct = new Struct();
        LongArray longArray = new LongArray();
        longArray.add((Object)123456789012L);
        longArray.add((Object)987654321098L);
        this.setFieldValue(struct, "myDoubles", longArray);
        Assert.assertNotNull((Object)struct.myDoubles);
        Assert.assertEquals((long)2L, (long)struct.myDoubles.size());
        Assert.assertEquals((double)1.23456789012E11, (double)((Double)struct.myDoubles.get(0)), (double)0.0);
        Assert.assertEquals((double)9.87654321098E11, (double)((Double)struct.myDoubles.get(1)), (double)0.0);
        this.setFieldValue(struct, "myStrings", longArray);
        Assert.assertNull((Object)struct.myStrings);
    }

    @Test
    public void testNestingMultiElements() {
        class Struct {
            private Set<char[]> nestedArray;

            Struct() {
            }
        }
        Struct struct = new Struct();
        HashSet<char[]> nestedSetValues = new HashSet<char[]>();
        char[] chars = new char[]{'a', 'b', 'c'};
        nestedSetValues.add(chars);
        this.setFieldValue(struct, "nestedArray", nestedSetValues);
        for (char[] charVals : struct.nestedArray) {
            for (int i = 0; i < chars.length; ++i) {
                Assert.assertEquals((long)chars[i], (long)charVals[i]);
            }
        }
    }

    @Test
    public void testSettingSingleElements() {
        class Struct {
            private Double[] doubleArray;
            private List<String> stringList;

            Struct() {
            }
        }
        Struct struct = new Struct();
        double dVal = 6.3;
        this.setFieldValue(struct, "doubleArray", 6.3);
        Assert.assertEquals((Object)new Double(6.3), (Object)struct.doubleArray[0]);
        String sVal = "I am a ghost";
        this.setFieldValue(struct, "stringList", "I am a ghost");
        Assert.assertEquals((Object)"I am a ghost", struct.stringList.get(0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadPrimitiveArray() {
        class Struct {
            private int[] intArray;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "intArray", "not an int array");
    }

    @Test
    public void testBadObjectElements() {
        class Struct {
            private Double[] doubleArray;
            private List<String> stringList;
            private Set<char[]> nestedArray;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "doubleArray", "not a double array");
        Assert.assertEquals(null, (Object)struct.doubleArray[0]);
        this.setFieldValue(struct, "nestedArray", "definitely not a set of char arrays");
        Assert.assertNull((Object)struct.stringList);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadSingleton() {
        class Struct {
            private int singleValue;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "singleValue", new int[]{4, 8, 2});
    }

    @Test
    public void testLegitimateSingletonInt() {
        class Struct {
            private IntWrapper intWrapper;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "intWrapper", 12);
        Assert.assertNotNull((Object)struct.intWrapper);
    }

    @Test
    public void testLegitimateSingletonArray() {
        class Struct {
            private ArrayWrapper arrayWrapper;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "arrayWrapper", new int[]{4, 8, 2});
        Assert.assertNotNull((Object)struct.arrayWrapper);
    }

    @Test
    public void testLegitimateSingletonCollection() {
        class Struct {
            private ListWrapper listWrapper;

            Struct() {
            }
        }
        Struct struct = new Struct();
        this.setFieldValue(struct, "listWrapper", this.getValueList(4, 8, 2));
        Assert.assertNotNull((Object)struct.listWrapper);
    }

    @Test
    public void testGetCompatibleInputs() {
        ArrayList compatibleInputs = new ArrayList(this.convertService.getCompatibleInputs(HisList.class));
        Assert.assertEquals((long)4L, (long)compatibleInputs.size());
        Assert.assertEquals((Object)"THIS_IS_A_TEST", compatibleInputs.get(0));
        Assert.assertEquals((Object)"WHY_AM_I_HERE", compatibleInputs.get(1));
        Assert.assertEquals((Object)"I_LIKE_TURTLES", compatibleInputs.get(2));
        Assert.assertEquals((Object)"OVER_9000", compatibleInputs.get(3));
    }

    private void setFieldValue(Object o, String fieldName, Object value) {
        ClassUtils.setValue((Field)ClassUtils.getField(o.getClass(), (String)fieldName), (Object)o, (Object)value);
    }

    private <T> List<T> getValueList(T ... values) {
        ArrayList<T> list = new ArrayList<T>();
        for (T value : values) {
            list.add(value);
        }
        return list;
    }

    private void testIntechangeable(Class<?> c1, Class<?> c2) {
        Assert.assertTrue((boolean)this.convertService.supports(c1, c2));
        Assert.assertTrue((boolean)this.convertService.supports(c2, c1));
    }

    @Plugin(type=Converter.class, priority=-Infinity)
    public static class StringHisListConverter
    extends AbstractConverter<String, HisList> {
        private static final String S1 = "THIS_IS_A_TEST";
        private static final String S2 = "WHY_AM_I_HERE";
        private static final String S3 = "I_LIKE_TURTLES";
        private static final String S4 = "OVER_9000";

        public void populateInputCandidates(Collection<Object> objects) {
            objects.add(S1);
            objects.add(S2);
            objects.add(S3);
            objects.add(S4);
        }

        public Class<HisList> getOutputType() {
            return HisList.class;
        }

        public Class<String> getInputType() {
            return String.class;
        }

        public boolean canConvert(Class<?> src, Class<?> dest) {
            return false;
        }

        public <T> T convert(Object src, Class<T> dest) {
            return null;
        }
    }

    public static enum Words {
        FOO,
        BAR,
        FUBAR;

    }

    public static class StringListExtension
    extends ArrayList<String> {
    }

    public static class ListExtension<T>
    extends ArrayList<T> {
    }

    public static class ListWrapper {
        public ListWrapper(List<?> gonnaWrapThisList) {
        }
    }

    public static class ArrayWrapper {
        public ArrayWrapper(int[] gonnaWrapThisArray) {
        }
    }

    public static class IntWrapper {
        public IntWrapper(int gonnaWrapThisInt) {
        }
    }

    private static interface INumberList
    extends List<Number> {
    }

    public static class NumberList
    extends ArrayList<Number>
    implements INumberList {
        public NumberList() {
        }

        public NumberList(Collection<? extends Number> c) {
            super(c);
        }
    }

    public static class ObjectList
    extends ArrayList<Object> {
        public ObjectList(Collection<? extends Object> c) {
            super(c);
        }
    }

    public static class HerList
    extends ArrayList<String> {
        public HerList(Collection<? extends String> c) {
            super(c);
        }
    }

    public static class HisList
    extends ArrayList<String> {
        public HisList() {
        }

        public HisList(Collection<? extends String> c) {
            super(c);
        }
    }
}

