/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module;

import java.util.List;
import org.scijava.Identifiable;
import org.scijava.Locatable;
import org.scijava.UIDetails;
import org.scijava.Validated;
import org.scijava.ValidityProblem;
import org.scijava.Versioned;
import org.scijava.event.EventService;
import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleItem;
import org.scijava.module.event.ModulesUpdatedEvent;
import org.scijava.util.ClassUtils;
import org.scijava.util.VersionUtils;

public interface ModuleInfo
extends UIDetails,
Validated,
Identifiable,
Locatable,
Versioned {
    public ModuleItem<?> getInput(String var1);

    public <T> ModuleItem<T> getInput(String var1, Class<T> var2);

    public ModuleItem<?> getOutput(String var1);

    public <T> ModuleItem<T> getOutput(String var1, Class<T> var2);

    public Iterable<ModuleItem<?>> inputs();

    public Iterable<ModuleItem<?>> outputs();

    public String getDelegateClassName();

    public Class<?> loadDelegateClass() throws ClassNotFoundException;

    public Module createModule() throws ModuleException;

    default public boolean isInteractive() {
        return false;
    }

    default public boolean canPreview() {
        return false;
    }

    default public boolean canCancel() {
        return true;
    }

    default public boolean canRunHeadless() {
        return false;
    }

    default public String getInitializer() {
        return null;
    }

    default public void update(EventService eventService) {
        eventService.publish(new ModulesUpdatedEvent(this));
    }

    @Override
    default public String getTitle() {
        String title = UIDetails.super.getTitle();
        if (!title.equals(this.getClass().getSimpleName())) {
            return title;
        }
        String className = this.getDelegateClassName();
        int dot = className.lastIndexOf(".");
        return dot < 0 ? className : className.substring(dot + 1);
    }

    @Override
    default public boolean isValid() {
        return true;
    }

    @Override
    default public List<ValidityProblem> getProblems() {
        return null;
    }

    @Override
    default public String getIdentifier() {
        return "module:" + this.getDelegateClassName();
    }

    @Override
    default public String getLocation() {
        try {
            return ClassUtils.getLocation(this.loadDelegateClass()).toExternalForm();
        }
        catch (ClassNotFoundException exc) {
            return null;
        }
    }

    @Override
    default public String getVersion() {
        try {
            return VersionUtils.getVersion(this.loadDelegateClass());
        }
        catch (ClassNotFoundException exc) {
            return null;
        }
    }
}

