/*
 * Decompiled with CFR 0.152.
 */
package org.scijava;

import org.scijava.Context;
import org.scijava.Gateway;
import org.scijava.app.App;
import org.scijava.app.AppService;
import org.scijava.app.StatusService;
import org.scijava.command.CommandService;
import org.scijava.console.ConsoleService;
import org.scijava.convert.ConvertService;
import org.scijava.display.DisplayService;
import org.scijava.event.EventHistory;
import org.scijava.event.EventService;
import org.scijava.input.InputService;
import org.scijava.io.IOService;
import org.scijava.io.RecentFileService;
import org.scijava.log.LogService;
import org.scijava.main.MainService;
import org.scijava.menu.MenuService;
import org.scijava.module.ModuleService;
import org.scijava.object.ObjectService;
import org.scijava.options.OptionsService;
import org.scijava.platform.AppEventService;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.AbstractRichPlugin;
import org.scijava.plugin.PluginService;
import org.scijava.prefs.PrefService;
import org.scijava.script.ScriptService;
import org.scijava.service.Service;
import org.scijava.startup.StartupService;
import org.scijava.text.TextService;
import org.scijava.thread.ThreadService;
import org.scijava.tool.IconService;
import org.scijava.tool.ToolService;
import org.scijava.ui.UIService;
import org.scijava.widget.WidgetService;

public abstract class AbstractGateway
extends AbstractRichPlugin
implements Gateway {
    private final String appName;

    public AbstractGateway() {
        this("SciJava", null);
    }

    public AbstractGateway(String appName, Context context) {
        this.appName = appName;
        if (context != null) {
            this.setContext(context);
        }
    }

    @Override
    public void launch(String ... args) {
        this.console().processArgs(args);
        int mainCount = this.main().execMains();
        if (mainCount == 0) {
            this.ui().showUI();
        }
        this.startup().executeOperations();
        if (this.ui().isHeadless()) {
            this.getContext().dispose();
        }
    }

    @Override
    public String getShortName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    @Override
    public <S extends Service> S get(Class<S> serviceClass) {
        return this.context().service(serviceClass);
    }

    @Override
    public Service get(String serviceClassName) {
        return this.context().service(serviceClassName);
    }

    @Override
    public AppEventService appEvent() {
        return this.get(AppEventService.class);
    }

    @Override
    public AppService app() {
        return this.get(AppService.class);
    }

    @Override
    public CommandService command() {
        return this.get(CommandService.class);
    }

    @Override
    public ConsoleService console() {
        return this.get(ConsoleService.class);
    }

    public ConvertService convert() {
        return this.get(ConvertService.class);
    }

    @Override
    public DisplayService display() {
        return this.get(DisplayService.class);
    }

    @Override
    public EventHistory eventHistory() {
        return this.get(EventHistory.class);
    }

    @Override
    public EventService event() {
        return this.get(EventService.class);
    }

    @Override
    public IconService icon() {
        return this.get(IconService.class);
    }

    @Override
    public InputService input() {
        return this.get(InputService.class);
    }

    @Override
    public IOService io() {
        return this.get(IOService.class);
    }

    @Override
    public LogService log() {
        return this.get(LogService.class);
    }

    @Override
    public MainService main() {
        return this.get(MainService.class);
    }

    @Override
    public MenuService menu() {
        return this.get(MenuService.class);
    }

    @Override
    public ModuleService module() {
        return this.get(ModuleService.class);
    }

    @Override
    public ObjectService object() {
        return this.get(ObjectService.class);
    }

    @Override
    public OptionsService options() {
        return this.get(OptionsService.class);
    }

    @Override
    public PlatformService platform() {
        return this.get(PlatformService.class);
    }

    @Override
    public PluginService plugin() {
        return this.get(PluginService.class);
    }

    public PrefService prefs() {
        return this.get(PrefService.class);
    }

    @Override
    public RecentFileService recentFile() {
        return this.get(RecentFileService.class);
    }

    @Override
    public ScriptService script() {
        return this.get(ScriptService.class);
    }

    @Override
    public StartupService startup() {
        return this.get(StartupService.class);
    }

    @Override
    public StatusService status() {
        return this.get(StatusService.class);
    }

    @Override
    public TextService text() {
        return this.get(TextService.class);
    }

    @Override
    public ThreadService thread() {
        return this.get(ThreadService.class);
    }

    @Override
    public ToolService tool() {
        return this.get(ToolService.class);
    }

    @Override
    public UIService ui() {
        return this.get(UIService.class);
    }

    @Override
    public WidgetService widget() {
        return this.get(WidgetService.class);
    }

    @Override
    public App getApp() {
        return this.app().getApp(this.appName);
    }

    @Override
    public String getTitle() {
        return this.getApp().getTitle();
    }

    @Override
    public String getInfo(boolean mem) {
        return this.getApp().getInfo(mem);
    }

    @Override
    public String getVersion() {
        return this.getApp().getVersion();
    }
}

