/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.io.handle.AbstractHigherOrderHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandles;
import org.scijava.io.location.Location;

public class ReadBufferDataHandle
extends AbstractHigherOrderHandle<Location> {
    private static final int DEFAULT_PAGE_SIZE = 10000;
    private static final int DEFAULT_NUM_PAGES = 10;
    private final int pageSize;
    private final List<byte[]> pages;
    private final int[] slotToPage;
    private final LRUReplacementStrategy replacementStrategy;
    private final Map<Integer, Integer> pageToSlot;
    private long offset = 0L;
    private byte[] currentPage;
    private int currentPageID = -1;

    public ReadBufferDataHandle(DataHandle<Location> handle) {
        this(handle, 10000);
    }

    public ReadBufferDataHandle(DataHandle<Location> handle, int pageSize) {
        this(handle, pageSize, 10);
    }

    public ReadBufferDataHandle(DataHandle<Location> handle, int pageSize, int numPages) {
        super(handle);
        this.pageSize = pageSize;
        this.slotToPage = new int[numPages];
        Arrays.fill(this.slotToPage, -1);
        this.pages = new ArrayList<byte[]>(numPages);
        for (int i = 0; i < numPages; ++i) {
            this.pages.add(null);
        }
        this.pageToSlot = new HashMap<Integer, Integer>();
        this.replacementStrategy = new LRUReplacementStrategy(numPages);
    }

    private void ensureBuffered(long globalOffset) throws IOException {
        this.ensureOpen();
        int pageID = (int)(globalOffset / (long)this.pageSize);
        if (pageID == this.currentPageID) {
            return;
        }
        int slotID = this.pageToSlot.computeIfAbsent(pageID, this.replacementStrategy::pickVictim);
        int inSlotID = this.slotToPage[slotID];
        if (inSlotID != pageID) {
            this.slotToPage[slotID] = pageID;
            this.pageToSlot.put(pageID, slotID);
            this.pageToSlot.put(inSlotID, null);
            this.currentPage = this.readPage(pageID, slotID);
        } else {
            this.currentPage = this.pages.get(slotID);
        }
        this.replacementStrategy.accessed(slotID);
        this.currentPageID = pageID;
    }

    private byte[] readPage(int pageID, int slotID) throws IOException {
        this.replacementStrategy.accessed(slotID);
        byte[] page = this.pages.get(slotID);
        if (page == null) {
            page = new byte[this.pageSize];
            this.pages.set(slotID, page);
        }
        long startOfPage = (long)pageID * (long)this.pageSize;
        if (this.handle().offset() != startOfPage) {
            this.handle().seek(startOfPage);
        }
        this.handle().read(page);
        return page;
    }

    private int globalToLocalOffset(long off) {
        return (int)off % this.pageSize;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.offset = pos;
    }

    @Override
    public int read(byte[] b, int targetOffset, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        long endPos = this.offset + (long)len;
        int readLength = (int)(endPos < this.length() ? (long)len : this.length() - this.offset);
        int read = 0;
        int localTargetOff = targetOffset;
        while (read < readLength) {
            this.ensureBuffered(this.offset);
            int pageOffset = this.globalToLocalOffset(this.offset);
            int localLength = this.pageSize - pageOffset;
            if (read + localLength > readLength) {
                localLength = readLength - read;
            }
            System.arraycopy(this.currentPage, pageOffset, b, localTargetOff, localLength);
            read += localLength;
            this.offset += (long)localLength;
            localTargetOff += localLength;
        }
        return read != 0 ? read : -1;
    }

    @Override
    public byte readByte() throws IOException {
        this.ensureBuffered(this.offset);
        return this.currentPage[this.globalToLocalOffset(this.offset++)];
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public long offset() throws IOException {
        return this.offset;
    }

    @Override
    protected void cleanup() {
        this.pages.clear();
        this.currentPage = null;
    }

    @Override
    public void write(int b) throws IOException {
        throw DataHandles.readOnlyException();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        throw DataHandles.readOnlyException();
    }

    @Override
    public void setLength(long length) throws IOException {
        throw DataHandles.readOnlyException();
    }

    private class LRUReplacementStrategy {
        private final Deque<Integer> queue;

        public LRUReplacementStrategy(int numSlots) {
            this.queue = new ArrayDeque<Integer>(numSlots);
            for (int i = 0; i < numSlots; ++i) {
                this.queue.add(i);
            }
        }

        public void accessed(int slotID) {
            this.queue.remove(slotID);
            this.queue.add(slotID);
        }

        public int pickVictim(int pageID) {
            return this.queue.peek();
        }
    }
}

