/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import org.scijava.io.handle.AbstractDataHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.FileLocation;
import org.scijava.plugin.Plugin;

@Plugin(type=DataHandle.class)
public class FileHandle
extends AbstractDataHandle<FileLocation> {
    private RandomAccessFile raf;
    private String mode = "rw";
    private boolean closed;

    public RandomAccessFile getRandomAccessFile() throws IOException {
        return this.writer();
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        if (this.raf != null) {
            throw new IllegalStateException("File already initialized");
        }
        this.mode = mode;
    }

    @Override
    public boolean isReadable() {
        return this.getMode().contains("r");
    }

    @Override
    public boolean isWritable() {
        return this.getMode().contains("w");
    }

    @Override
    public boolean exists() {
        return ((FileLocation)this.get()).getFile().exists();
    }

    @Override
    public Date lastModified() {
        long lastModified = ((FileLocation)this.get()).getFile().lastModified();
        return lastModified == 0L ? null : new Date(lastModified);
    }

    @Override
    public long offset() throws IOException {
        return this.exists() ? this.reader().getFilePointer() : 0L;
    }

    @Override
    public long length() throws IOException {
        return this.exists() ? this.reader().length() : -1L;
    }

    @Override
    public void setLength(long length) throws IOException {
        this.writer().setLength(length);
    }

    @Override
    public int read() throws IOException {
        return this.reader().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.reader().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.reader().read(b, off, len);
    }

    @Override
    public void seek(long pos) throws IOException {
        this.reader().seek(pos);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.reader().readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.reader().readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.reader().readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.reader().readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.reader().readFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.reader().readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.reader().readFully(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        return this.reader().readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.reader().readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.reader().readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.reader().readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.reader().readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.reader().readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.reader().readUTF();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.reader().skipBytes(n);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writer().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writer().write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.writer().write(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.writer().writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.writer().writeByte(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.writer().writeBytes(s);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writer().writeChar(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.writer().writeChars(s);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writer().writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writer().writeFloat(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.writer().writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writer().writeLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writer().writeShort(v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.writer().writeUTF(str);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.closed = true;
    }

    @Override
    public Class<FileLocation> getType() {
        return FileLocation.class;
    }

    private RandomAccessFile writer() throws IOException {
        if (this.raf == null) {
            this.initRAF(true);
        }
        return this.raf;
    }

    private RandomAccessFile reader() throws IOException {
        if (this.raf == null) {
            this.initRAF(false);
        }
        return this.raf;
    }

    private synchronized void initRAF(boolean create) throws IOException {
        if (!create && !this.exists()) {
            throw new IOException("Trying to read from non-existent file!");
        }
        if (this.closed) {
            throw new IOException("Handle already closed");
        }
        if (this.raf != null) {
            return;
        }
        this.raf = new RandomAccessFile(((FileLocation)this.get()).getFile(), this.getMode());
    }
}

